/*
 * Decompiled with CFR 0.152.
 */
package net.shaddii.smartsorter.screen.tabs;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_8710;
import net.shaddii.smartsorter.network.FilterCategoryChangePayload;
import net.shaddii.smartsorter.network.SortModeChangePayload;
import net.shaddii.smartsorter.screen.StorageControllerScreen;
import net.shaddii.smartsorter.screen.StorageControllerScreenHandler;
import net.shaddii.smartsorter.screen.tabs.TabComponent;
import net.shaddii.smartsorter.screen.util.ItemCacheManager;
import net.shaddii.smartsorter.screen.util.ItemGridRenderer;
import net.shaddii.smartsorter.screen.util.TooltipRenderer;
import net.shaddii.smartsorter.util.Category;
import net.shaddii.smartsorter.util.CategoryManager;
import net.shaddii.smartsorter.util.SortMode;
import net.shaddii.smartsorter.widget.DropdownWidget;
import org.lwjgl.glfw.GLFW;

public class StorageTabComponent
extends TabComponent {
    private static final int ITEMS_PER_ROW = 9;
    private static final int VISIBLE_ROWS = 5;
    private static final int ITEMS_PER_PAGE = 45;
    private static final int GRID_START_X = 8;
    private static final int GRID_START_Y = 18;
    private static final int SLOT_SIZE = 18;
    private static final int SCROLLBAR_X = 174;
    private static final int SCROLLBAR_Y = 18;
    private static final int SCROLLBAR_WIDTH = 14;
    private static final int SCROLLBAR_HEIGHT = 90;
    private static final long CAPACITY_UPDATE_INTERVAL = 1000L;
    private class_342 searchBox;
    private class_4185 sortButton;
    private DropdownWidget filterDropdown;
    private String currentSearch = "";
    private float scrollProgress = 0.0f;
    private boolean isScrolling = false;
    private int maxScrollRows = 0;
    private final ItemCacheManager cacheManager;
    private final ItemGridRenderer gridRenderer;
    private final TooltipRenderer tooltipRenderer;
    private List<Map.Entry<ItemVariant, Long>> networkItemsList = new ArrayList<Map.Entry<ItemVariant, Long>>();
    private String cachedCapacityText = "";
    private int cachedCapacityColor = -1;
    private long lastCapacityCheck = 0L;

    public StorageTabComponent(StorageControllerScreen parent, StorageControllerScreenHandler handler) {
        super(parent, handler);
        this.cacheManager = new ItemCacheManager();
        this.gridRenderer = new ItemGridRenderer(parent.method_64506());
        this.tooltipRenderer = new TooltipRenderer(parent.method_64506());
    }

    @Override
    protected void initWidgets() {
        this.searchBox = new class_342(this.parent.method_64506(), this.guiX + 82, this.guiY + 6, 90, 13, (class_2561)class_2561.method_43470((String)""));
        this.searchBox.method_1858(false);
        this.searchBox.method_1863(this::onSearchChanged);
        this.parent.addWidget((class_339)this.searchBox);
        this.sortButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)this.handler.getSortMode().getDisplayName()), btn -> this.cycleSortMode()).method_46434(this.guiX + 82, this.guiY + 6 + 13 - 34, 30, 12).method_46431();
        this.parent.addWidget((class_339)this.sortButton);
        this.filterDropdown = new DropdownWidget(this.guiX + 82 + 30 + 2, this.guiY + 6 + 13 - 34, 60, 12, (class_2561)class_2561.method_43470((String)""));
        this.initFilterDropdown();
        this.parent.addWidget(this.filterDropdown);
        this.updateNetworkItems();
    }

    @Override
    public void render(class_332 context, int mouseX, int mouseY, float delta) {
        this.renderTitle(context);
        this.renderCapacity(context);
        this.renderNetworkItems(context, mouseX, mouseY);
        this.drawScrollbar(context);
        if (this.filterDropdown != null && this.filterDropdown.isOpen()) {
            this.filterDropdown.renderDropdown(context, mouseX, mouseY);
        }
    }

    private void renderTitle(class_332 context) {
        context.method_51439(this.parent.method_64506(), (class_2561)class_2561.method_43470((String)"Controller"), this.guiX + 7, this.guiY + 6, -12566464, false);
        context.method_51439(this.parent.method_64506(), (class_2561)class_2561.method_43470((String)"Inventory"), this.guiX + 8, this.guiY + 109, -12566464, false);
    }

    private void renderCapacity(class_332 context) {
        if (this.handler.controller == null) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastCapacityCheck > 1000L) {
            this.updateCapacityCache();
            this.lastCapacityCheck = currentTime;
        }
        if (!this.cachedCapacityText.isEmpty()) {
            int textWidth = this.parent.method_64506().method_1727(this.cachedCapacityText);
            int textX = this.guiX + this.backgroundWidth - textWidth - 26;
            int textY = this.guiY + 6;
            context.method_51439(this.parent.method_64506(), (class_2561)class_2561.method_43470((String)this.cachedCapacityText), textX, textY, 0xFF000000 | this.cachedCapacityColor, false);
        }
    }

    private void updateCapacityCache() {
        int free = this.handler.controller.calculateTotalFreeSlots();
        int total = this.handler.controller.calculateTotalCapacity();
        if (total > 0) {
            float percentFree = (float)free / (float)total * 100.0f;
            this.cachedCapacityColor = percentFree > 50.0f ? 0x55FF55 : (percentFree > 25.0f ? 0xFFFF55 : (percentFree > 10.0f ? 0xFFAA00 : 0xFF5555));
            this.cachedCapacityText = free + "/" + total;
        }
    }

    private void renderNetworkItems(class_332 context, int mouseX, int mouseY) {
        int scrollOffset = (int)(this.scrollProgress * (float)this.maxScrollRows);
        int startIndex = scrollOffset * 9;
        int endIndex = Math.min(startIndex + 45, this.networkItemsList.size());
        this.gridRenderer.renderItems(context, this.networkItemsList, startIndex, endIndex, this.guiX + 8, this.guiY + 18, 9, 18, mouseX, mouseY);
    }

    public boolean isSearchFieldFocused() {
        return this.searchBox != null && this.searchBox.method_25370();
    }

    private void drawScrollbar(class_332 context) {
        int scrollbarX = this.guiX + 174;
        int scrollbarY = this.guiY + 18;
        this.gridRenderer.renderScrollbar(context, scrollbarX, scrollbarY, 14, 90, this.scrollProgress, this.maxScrollRows > 0);
    }

    public void renderTooltip(class_332 context, int mouseX, int mouseY) {
        if (this.filterDropdown != null && this.filterDropdown.isOpen() && this.filterDropdown.method_25405(mouseX, mouseY)) {
            return;
        }
        int scrollOffset = (int)(this.scrollProgress * (float)this.maxScrollRows);
        int startIndex = scrollOffset * 9;
        int endIndex = Math.min(startIndex + 45, this.networkItemsList.size());
        for (int i = startIndex; i < endIndex; ++i) {
            int relativeIndex = i - startIndex;
            int col = relativeIndex % 9;
            int slotX = this.guiX + 8 + col * 18;
            int row = relativeIndex / 9;
            int slotY = this.guiY + 18 + row * 18;
            if (!this.isMouseOverSlot(slotX, slotY, mouseX, mouseY)) continue;
            Map.Entry<ItemVariant, Long> entry = this.networkItemsList.get(i);
            List<class_2561> tooltip = this.tooltipRenderer.createItemTooltip(entry.getKey(), entry.getValue());
            context.method_51434(this.parent.method_64506(), tooltip, mouseX, mouseY);
            break;
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.filterDropdown != null) {
            if (this.filterDropdown.method_25405(mouseX, mouseY)) {
                this.filterDropdown.method_25402(mouseX, mouseY, button);
                return true;
            }
            if (this.filterDropdown.isOpen()) {
                this.filterDropdown.close();
                return true;
            }
        }
        if (this.searchBox != null) {
            int sx = this.searchBox.method_46426();
            int sy = this.searchBox.method_46427();
            if (mouseX >= (double)sx && mouseX < (double)(sx + this.searchBox.method_25368()) && mouseY >= (double)sy && mouseY < (double)(sy + this.searchBox.method_25364())) {
                this.parent.setWidgetFocused((class_364)this.searchBox);
                this.searchBox.method_25365(true);
                return true;
            }
        }
        if (this.needsScrollbar() && this.isMouseOverScrollbar(mouseX, mouseY)) {
            this.isScrolling = true;
            this.updateScrollFromMouse(mouseY);
            return true;
        }
        return this.handleGridClick(mouseX, mouseY, button);
    }

    private boolean handleGridClick(double mouseX, double mouseY, int button) {
        int gridStartX = this.guiX + 8;
        int gridStartY = this.guiY + 18;
        int gridEndX = gridStartX + 162;
        int gridEndY = gridStartY + 90;
        if (mouseX >= (double)gridStartX && mouseX < (double)gridEndX && mouseY >= (double)gridStartY && mouseY < (double)gridEndY) {
            int scrollOffset = (int)(this.scrollProgress * (float)this.maxScrollRows);
            int startIndex = scrollOffset * 9;
            int endIndex = Math.min(startIndex + 45, this.networkItemsList.size());
            for (int i = startIndex; i < endIndex; ++i) {
                int relativeIndex = i - startIndex;
                int col = relativeIndex % 9;
                int slotX = this.guiX + 8 + col * 18;
                int row = relativeIndex / 9;
                int slotY = this.guiY + 18 + row * 18;
                if (!this.isMouseOverSlot(slotX, slotY, mouseX, mouseY)) continue;
                this.handleNetworkSlotClick(i, button, this.isShiftDown(), this.isControlDown());
                return true;
            }
            if (!this.handler.method_34255().method_7960()) {
                this.handleEmptyAreaClick(button);
                return true;
            }
        }
        return false;
    }

    private void handleNetworkSlotClick(int slotIndex, int button, boolean isShift, boolean isCtrl) {
        Map.Entry<ItemVariant, Long> entry = this.networkItemsList.get(slotIndex);
        ItemVariant variant = entry.getKey();
        long itemCount = entry.getValue();
        class_1799 cursorStack = this.handler.method_34255();
        if (!cursorStack.method_7960()) {
            ItemVariant cursorVariant = ItemVariant.of((class_1799)cursorStack);
            if (cursorVariant.equals((Object)variant)) {
                if (button == 0) {
                    this.handler.requestDeposit(cursorStack, cursorStack.method_7947());
                    this.handler.method_34254(class_1799.field_8037);
                } else if (button == 1) {
                    this.handler.requestDeposit(cursorStack, 1);
                    cursorStack.method_7934(1);
                    this.handler.method_34254(cursorStack.method_7960() ? class_1799.field_8037 : cursorStack);
                }
            } else {
                this.handler.requestDeposit(cursorStack, cursorStack.method_7947());
                this.handler.method_34254(class_1799.field_8037);
            }
            return;
        }
        int amount = isShift ? (int)Math.min(64L, itemCount) : (isCtrl && button == 0 ? (int)Math.min(16L, Math.max(1L, itemCount / 4L)) : (button == 0 ? (int)Math.min(64L, itemCount) : (button == 1 ? (int)Math.min(32L, Math.max(1L, itemCount / 2L)) : (int)Math.min((long)variant.getItem().method_7882(), itemCount))));
        if (!isShift) {
            class_1799 extracted = variant.toStack(amount);
            this.handler.method_34254(extracted);
        }
        this.handler.requestExtraction(variant, amount, isShift);
    }

    private void handleEmptyAreaClick(int button) {
        class_1799 cursorStack = this.handler.method_34255();
        if (cursorStack.method_7960()) {
            return;
        }
        if (button == 0) {
            this.handler.requestDeposit(cursorStack, cursorStack.method_7947());
            this.handler.method_34254(class_1799.field_8037);
        } else if (button == 1) {
            this.handler.requestDeposit(cursorStack, 1);
            cursorStack.method_7934(1);
            this.handler.method_34254(cursorStack.method_7960() ? class_1799.field_8037 : cursorStack);
        }
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.isScrolling = false;
        }
        return false;
    }

    @Override
    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.isScrolling && this.needsScrollbar()) {
            this.updateScrollFromMouse(mouseY);
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (this.filterDropdown != null && this.filterDropdown.isOpen() && this.filterDropdown.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount)) {
            return true;
        }
        if (this.needsScrollbar()) {
            float scrollAmount = (float)(-verticalAmount / (double)(this.maxScrollRows + 1));
            this.scrollProgress = Math.max(0.0f, Math.min(1.0f, this.scrollProgress + scrollAmount));
            return true;
        }
        return false;
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.searchBox != null && this.searchBox.method_25370()) {
            if (keyCode == 256 || keyCode == 257 || keyCode == 335) {
                this.searchBox.method_25365(false);
                return true;
            }
            return this.handleKeyPress(this.searchBox, keyCode, scanCode, modifiers);
        }
        if (this.searchBox != null && !this.searchBox.method_25370()) {
            if (keyCode == 70 && (modifiers & 2) != 0) {
                this.searchBox.method_25365(true);
                this.parent.setWidgetFocused((class_364)this.searchBox);
                return true;
            }
            if (keyCode == 47) {
                this.searchBox.method_25365(true);
                this.parent.setWidgetFocused((class_364)this.searchBox);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean charTyped(char chr, int modifiers) {
        if (this.searchBox != null && this.searchBox.method_25370()) {
            return this.handleCharType(this.searchBox, chr, modifiers);
        }
        return false;
    }

    @Override
    public void markDirty() {
        this.cacheManager.invalidate();
        this.updateNetworkItems();
    }

    @Override
    public void onClose() {
        this.cacheManager.clearAll();
        this.tooltipRenderer.invalidateCache();
    }

    public void updateNetworkItems() {
        Map<ItemVariant, Long> items = this.handler.getNetworkItems();
        SortMode sortMode = this.handler.getSortMode();
        Category category = this.handler.getFilterCategory();
        this.networkItemsList = this.cacheManager.getFilteredItems(items, this.currentSearch, sortMode, category);
        int totalRows = (int)Math.ceil((double)this.networkItemsList.size() / 9.0);
        this.maxScrollRows = Math.max(0, totalRows - 5);
    }

    private void onSearchChanged(String searchText) {
        this.currentSearch = searchText.toLowerCase();
        this.markDirty();
        this.scrollProgress = 0.0f;
    }

    private void cycleSortMode() {
        SortMode currentMode = this.handler.getSortMode();
        SortMode newMode = currentMode.next();
        this.sortButton.method_25355((class_2561)class_2561.method_43470((String)newMode.getDisplayName()));
        this.handler.setSortMode(newMode);
        this.markDirty();
        ClientPlayNetworking.send((class_8710)new SortModeChangePayload(newMode.method_15434()));
    }

    private void initFilterDropdown() {
        List<Category> allCategories = CategoryManager.getInstance().getAllCategories();
        if (allCategories.isEmpty()) {
            allCategories = List.of(Category.ALL, Category.MISC);
        }
        ArrayList<Category> categoryList = new ArrayList<Category>(allCategories);
        for (Category category : categoryList) {
            this.filterDropdown.addEntry(category.getShortName(), category.getDisplayName());
        }
        Category currentCategory = this.handler.getFilterCategory();
        int selectedIndex = 0;
        for (int i = 0; i < categoryList.size(); ++i) {
            if (!((Category)categoryList.get(i)).getId().equals((Object)currentCategory.getId())) continue;
            selectedIndex = i;
            break;
        }
        this.filterDropdown.setSelectedIndex(selectedIndex);
        this.filterDropdown.setOnSelect(index -> {
            if (index >= 0 && index < categoryList.size()) {
                Category selected = (Category)categoryList.get((int)index);
                this.handler.setFilterCategory(selected);
                this.markDirty();
                ClientPlayNetworking.send((class_8710)new FilterCategoryChangePayload(selected.asString()));
            }
        });
        this.filterDropdown.field_22763 = true;
        this.filterDropdown.field_22764 = true;
    }

    private boolean isMouseOverSlot(int slotX, int slotY, double mouseX, double mouseY) {
        return mouseX >= (double)slotX && mouseX < (double)(slotX + 16) && mouseY >= (double)slotY && mouseY < (double)(slotY + 16);
    }

    private boolean needsScrollbar() {
        return this.maxScrollRows > 0;
    }

    private boolean isMouseOverScrollbar(double mouseX, double mouseY) {
        int barX = this.guiX + 174;
        int barY = this.guiY + 18;
        return mouseX >= (double)barX && mouseX < (double)(barX + 14) && mouseY >= (double)barY && mouseY < (double)(barY + 90);
    }

    private void updateScrollFromMouse(double mouseY) {
        int barY = this.guiY + 18;
        int handleHeight = 15;
        int maxHandleOffset = 90 - handleHeight;
        float relativeY = (float)(mouseY - (double)barY - (double)handleHeight / 2.0);
        this.scrollProgress = Math.max(0.0f, Math.min(1.0f, relativeY / (float)maxHandleOffset));
    }

    private boolean isControlDown() {
        long handle = class_310.method_1551().method_22683().method_4490();
        return GLFW.glfwGetKey((long)handle, (int)341) == 1 || GLFW.glfwGetKey((long)handle, (int)345) == 1;
    }

    private boolean isShiftDown() {
        long handle = class_310.method_1551().method_22683().method_4490();
        return GLFW.glfwGetKey((long)handle, (int)340) == 1 || GLFW.glfwGetKey((long)handle, (int)344) == 1;
    }
}

