/*
 * Decompiled with CFR 0.152.
 */
package net.shaddii.smartsorter.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_2338;
import net.shaddii.smartsorter.util.ChestConfig;

public class ChestPriorityManager {
    private static final int CUSTOM_PRIORITY = 0;
    private final Map<class_2338, Integer> priorityCache = new ConcurrentHashMap<class_2338, Integer>();
    private boolean isDirty = true;

    public Map<class_2338, Integer> addChest(class_2338 pos, ChestConfig config, Map<class_2338, ChestConfig> allConfigs) {
        if (config.simplePrioritySelection == null) {
            config.simplePrioritySelection = ChestConfig.SimplePriority.MEDIUM;
        }
        if (config.filterMode == ChestConfig.FilterMode.OVERFLOW) {
            config.simplePrioritySelection = ChestConfig.SimplePriority.LOWEST;
        }
        allConfigs.put(pos, config);
        return this.reorderAllChests(allConfigs);
    }

    public Map<class_2338, Integer> removeChest(class_2338 pos, Map<class_2338, ChestConfig> allConfigs) {
        allConfigs.remove(pos);
        return this.reorderAllChests(allConfigs);
    }

    public Map<class_2338, Integer> updateChestPriority(class_2338 pos, ChestConfig.SimplePriority newPriority, Map<class_2338, ChestConfig> allConfigs) {
        ChestConfig config = allConfigs.get(pos);
        if (config == null) {
            return new HashMap<class_2338, Integer>(this.priorityCache);
        }
        config.simplePrioritySelection = newPriority;
        return this.reorderAllChests(allConfigs);
    }

    public Map<class_2338, Integer> recalculateAll(Map<class_2338, ChestConfig> allConfigs) {
        this.priorityCache.clear();
        return this.reorderAllChests(allConfigs);
    }

    /*
     * WARNING - void declaration
     */
    private Map<class_2338, Integer> reorderAllChests(Map<class_2338, ChestConfig> allConfigs) {
        HashMap<class_2338, Integer> result = new HashMap<class_2338, Integer>();
        for (Map.Entry<class_2338, ChestConfig> entry : allConfigs.entrySet()) {
            if (entry.getValue().filterMode != ChestConfig.FilterMode.CUSTOM) continue;
            ChestConfig chestConfig = entry.getValue();
            chestConfig.priority = 0;
            chestConfig.updateHiddenPriority();
            this.priorityCache.put(entry.getKey(), 0);
            result.put(entry.getKey(), 0);
        }
        ArrayList<ChestEntry> regularChests = new ArrayList<ChestEntry>();
        for (Map.Entry<class_2338, ChestConfig> entry : allConfigs.entrySet()) {
            if (entry.getValue().filterMode == ChestConfig.FilterMode.CUSTOM) continue;
            regularChests.add(new ChestEntry(entry.getKey(), entry.getValue()));
        }
        regularChests.sort((a, b) -> {
            int bOrder;
            int aOrder = this.getSimplePriorityOrder(a.config.simplePrioritySelection);
            if (aOrder != (bOrder = this.getSimplePriorityOrder(b.config.simplePrioritySelection))) {
                return Integer.compare(aOrder, bOrder);
            }
            return Integer.compare(a.config.priority, b.config.priority);
        });
        boolean bl = true;
        for (ChestEntry chest : regularChests) {
            void var4_7;
            chest.config.priority = var4_7;
            chest.config.updateHiddenPriority();
            allConfigs.put(chest.pos, chest.config);
            this.priorityCache.put(chest.pos, (int)var4_7);
            result.put(chest.pos, (int)var4_7);
            ++var4_7;
        }
        this.isDirty = false;
        return result;
    }

    private int getSimplePriorityOrder(ChestConfig.SimplePriority priority) {
        if (priority == null) {
            return 3;
        }
        return switch (priority) {
            default -> throw new MatchException(null, null);
            case ChestConfig.SimplePriority.HIGHEST -> 1;
            case ChestConfig.SimplePriority.HIGH -> 2;
            case ChestConfig.SimplePriority.MEDIUM -> 3;
            case ChestConfig.SimplePriority.LOW -> 4;
            case ChestConfig.SimplePriority.LOWEST -> 5;
        };
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void markDirty() {
        this.isDirty = true;
    }

    public int getCachedPriority(class_2338 pos) {
        return this.priorityCache.getOrDefault(pos, -1);
    }

    public Map<class_2338, Integer> getPriorityCache() {
        return new HashMap<class_2338, Integer>(this.priorityCache);
    }

    public int getRegularChestCount(Map<class_2338, ChestConfig> allConfigs) {
        return (int)allConfigs.values().stream().filter(config -> config.filterMode != ChestConfig.FilterMode.CUSTOM).count();
    }

    private static class ChestEntry {
        final class_2338 pos;
        final ChestConfig config;

        ChestEntry(class_2338 pos, ChestConfig config) {
            this.pos = pos;
            this.config = config;
        }
    }
}

