/*
 * Decompiled with CFR 0.152.
 */
package net.shaddii.smartsorter.widget;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_6379;
import net.minecraft.class_6382;
import net.minecraft.class_8710;
import net.shaddii.smartsorter.network.ChestConfigUpdatePayload;
import net.shaddii.smartsorter.util.Category;
import net.shaddii.smartsorter.util.CategoryManager;
import net.shaddii.smartsorter.util.ChestConfig;
import net.shaddii.smartsorter.widget.CheckboxWidget;
import net.shaddii.smartsorter.widget.DropdownWidget;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fc;

public class ChestConfigPanel
implements class_4068,
class_364,
class_6379 {
    private final int x;
    private final int y;
    private final int width;
    private final int height;
    private final class_327 textRenderer;
    private ChestConfig currentConfig;
    private Consumer<ChestConfig> onConfigUpdate;
    private DropdownWidget categoryDropdown;
    private DropdownWidget filterModeDropdown;
    private CheckboxWidget strictNBTCheckbox;
    private class_342 priorityField;
    private DropdownWidget priorityDropdown;
    private class_342 nameField;
    private class_4185 renameButton;
    private int maxPriority = 1;
    private final boolean showHeader;
    private boolean externalDropdownOpen = false;
    private final List<Category> categoryList = new ArrayList<Category>();
    private static final int PADDING = 5;
    private static final int LINE_HEIGHT = 11;
    private boolean isRenaming = false;
    private final boolean showRenameButton;

    public ChestConfigPanel(int x, int y, int width, int height, class_327 textRenderer, boolean showRenameButton, boolean showHeader) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.textRenderer = textRenderer;
        this.showRenameButton = showRenameButton;
        this.showHeader = showHeader;
        this.initWidgets();
    }

    public ChestConfigPanel(int x, int y, int width, int height, class_327 textRenderer, boolean showRenameButton) {
        this(x, y, width, height, textRenderer, showRenameButton, true);
    }

    public ChestConfigPanel(int x, int y, int width, int height, class_327 textRenderer) {
        this(x, y, width, height, textRenderer, false, true);
    }

    private void initWidgets() {
        int innerX = this.x + 5;
        int innerY = this.y + 18;
        if (this.showRenameButton) {
            this.nameField = new class_342(this.textRenderer, innerX, innerY, this.width - 10 - 45, 10, (class_2561)class_2561.method_43470((String)""));
            this.nameField.method_1880(32);
            this.nameField.method_1862(false);
            this.nameField.method_1863(this::onNameChanged);
            this.renameButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u270e"), btn -> this.toggleRename()).method_46434(innerX + this.width - 10 - 40, innerY, 35, 10).method_46431();
            innerY += 13;
        }
        this.categoryDropdown = new DropdownWidget(innerX, innerY, 80, 10, (class_2561)class_2561.method_43470((String)""));
        List<Category> allCategories = CategoryManager.getInstance().getAllCategories();
        for (Category category : allCategories) {
            this.categoryList.add(category);
            this.categoryDropdown.addEntry(category.getShortName(), category.getDisplayName());
        }
        this.categoryDropdown.setOnSelect(this::onCategoryChanged);
        if (!this.showHeader) {
            this.priorityDropdown = new DropdownWidget(innerX + 35, innerY, 70, 10, (class_2561)class_2561.method_43470((String)""));
            for (ChestConfig.SimplePriority simplePriority : ChestConfig.SimplePriority.values()) {
                this.priorityDropdown.addEntry(simplePriority.getDisplayName(), simplePriority.getDescription());
            }
            this.priorityDropdown.setOnSelect(this::onPriorityDropdownChanged);
        } else {
            this.priorityField = new class_342(this.textRenderer, innerX + 35, innerY, 30, 10, (class_2561)class_2561.method_43470((String)""));
            this.priorityField.method_1880(3);
            this.priorityField.method_1852("1");
            this.priorityField.method_1863(this::onPriorityChanged);
        }
        this.filterModeDropdown = new DropdownWidget(innerX + 35, innerY + 36, 100, 10, (class_2561)class_2561.method_43470((String)""));
        for (Enum enum_ : ChestConfig.FilterMode.values()) {
            this.filterModeDropdown.addEntry(((ChestConfig.FilterMode)enum_).getDisplayName(), ((ChestConfig.FilterMode)enum_).getDisplayName());
        }
        this.filterModeDropdown.setOnSelect(this::onFilterModeChanged);
        this.strictNBTCheckbox = CheckboxWidget.builder((class_2561)class_2561.method_43470((String)"Match NBT"), this.textRenderer).pos(innerX, innerY + 50).dimensions(60, 9).checked(false).callback(this::onStrictNBTChanged).build();
    }

    private void toggleRename() {
        this.isRenaming = !this.isRenaming;
        this.nameField.method_1862(this.isRenaming);
        if (this.isRenaming) {
            this.nameField.method_25365(true);
            if (this.currentConfig != null && this.currentConfig.customName != null) {
                this.nameField.method_1852(this.currentConfig.customName);
            }
        } else {
            this.nameField.method_25365(false);
            if (this.currentConfig != null && !this.nameField.method_1882().equals(this.currentConfig.customName)) {
                this.currentConfig.customName = this.nameField.method_1882();
                this.notifyUpdate();
            }
        }
    }

    private void onNameChanged(String text) {
    }

    private void onPriorityChanged(String text) {
        if (this.currentConfig == null || text.isEmpty()) {
            return;
        }
        try {
            int value = Integer.parseInt(text);
            if (value < 1) {
                value = 1;
            }
            if (value > this.maxPriority) {
                value = this.maxPriority;
            }
            if (this.currentConfig.priority == value) {
                return;
            }
            ChestConfig updatedConfig = new ChestConfig(this.currentConfig.position, this.currentConfig.customName, this.currentConfig.filterCategory, value, this.currentConfig.filterMode, this.currentConfig.autoItemFrame);
            updatedConfig.strictNBTMatch = this.currentConfig.strictNBTMatch;
            updatedConfig.simplePrioritySelection = null;
            updatedConfig.updateHiddenPriority();
            ClientPlayNetworking.send((class_8710)new ChestConfigUpdatePayload(updatedConfig));
            if (this.onConfigUpdate != null) {
                this.onConfigUpdate.accept(updatedConfig);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void onPriorityDropdownChanged(int index) {
        if (this.currentConfig != null && index >= 0 && index < ChestConfig.SimplePriority.values().length) {
            ChestConfig.SimplePriority selected;
            this.currentConfig.simplePrioritySelection = selected = ChestConfig.SimplePriority.values()[index];
            this.currentConfig.priority = selected.getNumericValue(this.maxPriority);
            this.currentConfig.updateHiddenPriority();
            this.notifyUpdate();
        }
    }

    private void onStrictNBTChanged(boolean checked) {
        if (this.currentConfig != null) {
            this.currentConfig.strictNBTMatch = checked;
            this.notifyUpdate();
        }
    }

    public boolean method_25370() {
        return this.priorityField != null && this.priorityField.method_25370() || this.nameField != null && this.nameField.method_25370();
    }

    public void method_25365(boolean focused) {
        if (this.priorityField != null) {
            this.priorityField.method_25365(focused);
        }
        if (this.nameField != null && !focused) {
            this.nameField.method_25365(false);
        }
    }

    public void setConfig(ChestConfig config) {
        this.currentConfig = config;
        if (config == null) {
            this.categoryDropdown.setSelectedIndex(0);
            this.priorityField.method_1852("1");
            this.filterModeDropdown.setSelectedIndex(0);
            if (this.nameField != null) {
                this.nameField.method_1852("");
                this.nameField.method_1862(false);
            }
            this.isRenaming = false;
            return;
        }
        int categoryIndex = 0;
        for (int i = 0; i < this.categoryList.size(); ++i) {
            if (!this.categoryList.get(i).getId().equals((Object)config.filterCategory.getId())) continue;
            categoryIndex = i;
            break;
        }
        this.categoryDropdown.setSelectedIndex(categoryIndex);
        if (this.priorityDropdown != null) {
            ChestConfig.SimplePriority sp = config.simplePrioritySelection != null ? config.simplePrioritySelection : ChestConfig.SimplePriority.fromNumeric(config.priority, this.maxPriority);
            this.priorityDropdown.setSelectedIndex(sp.ordinal());
        } else if (this.priorityField != null) {
            String priorityText = String.valueOf(config.priority);
            if (!this.priorityField.method_1882().equals(priorityText)) {
                this.priorityField.method_1852(priorityText);
            }
        }
        this.filterModeDropdown.setSelectedIndex(config.filterMode.ordinal());
        this.strictNBTCheckbox.setChecked(config.strictNBTMatch);
        if (this.nameField != null) {
            if (config.customName != null && !config.customName.isEmpty()) {
                this.nameField.method_1852(config.customName);
            } else {
                this.nameField.method_1852("");
            }
        }
    }

    public void setMaxPriority(int max) {
        this.maxPriority = Math.max(1, max);
    }

    public void setOnConfigUpdate(Consumer<ChestConfig> callback) {
        this.onConfigUpdate = callback;
    }

    private void onCategoryChanged(int index) {
        if (this.currentConfig != null && index >= 0 && index < this.categoryList.size()) {
            this.currentConfig.filterCategory = this.categoryList.get(index);
            this.currentConfig.updateHiddenPriority();
            this.notifyUpdate();
        }
    }

    private void onFilterModeChanged(int index) {
        if (this.currentConfig != null && index >= 0 && index < ChestConfig.FilterMode.values().length) {
            ChestConfig.FilterMode newMode = ChestConfig.FilterMode.values()[index];
            ChestConfig.FilterMode oldMode = this.currentConfig.filterMode;
            this.currentConfig.filterMode = newMode;
            if (newMode == ChestConfig.FilterMode.OVERFLOW && oldMode != ChestConfig.FilterMode.OVERFLOW) {
                this.currentConfig.simplePrioritySelection = ChestConfig.SimplePriority.LOWEST;
                this.currentConfig.priority = this.maxPriority;
                if (this.priorityDropdown != null) {
                    this.priorityDropdown.setSelectedIndex(ChestConfig.SimplePriority.LOWEST.ordinal());
                } else if (this.priorityField != null) {
                    this.priorityField.method_1852(String.valueOf(this.maxPriority));
                }
            }
            this.currentConfig.updateHiddenPriority();
            this.notifyUpdate();
        }
    }

    private void notifyUpdate() {
        if (this.onConfigUpdate != null && this.currentConfig != null) {
            this.currentConfig.updateHiddenPriority();
            ClientPlayNetworking.send((class_8710)new ChestConfigUpdatePayload(this.currentConfig));
            this.onConfigUpdate.accept(this.currentConfig);
        }
    }

    public void setExternalDropdownOpen(boolean open) {
        this.externalDropdownOpen = open;
    }

    public void renderDropdownsOnly(class_332 context, int mouseX, int mouseY) {
        if (this.currentConfig == null) {
            return;
        }
        if (this.categoryDropdown != null && this.categoryDropdown.isOpen() && this.currentConfig.filterMode.needsCategoryFilter()) {
            this.categoryDropdown.renderDropdown(context, mouseX, mouseY);
        }
        if (this.filterModeDropdown != null && this.filterModeDropdown.isOpen()) {
            this.filterModeDropdown.renderDropdown(context, mouseX, mouseY);
        }
        if (this.priorityDropdown != null && this.priorityDropdown.isOpen()) {
            this.priorityDropdown.renderDropdown(context, mouseX, mouseY);
        }
    }

    public boolean isAnyDropdownOpen() {
        return this.categoryDropdown != null && this.categoryDropdown.isOpen() || this.filterModeDropdown != null && this.filterModeDropdown.isOpen() || this.priorityDropdown != null && this.priorityDropdown.isOpen();
    }

    public void closeAllDropdowns() {
        if (this.categoryDropdown != null) {
            this.categoryDropdown.close();
        }
        if (this.filterModeDropdown != null) {
            this.filterModeDropdown.close();
        }
        if (this.priorityDropdown != null) {
            this.priorityDropdown.close();
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        boolean anyDropdownOpen;
        context.method_25294(this.x, this.y, this.x + this.width, this.y + this.height, -13948117);
        context.method_25294(this.x + 1, this.y + 1, this.x + this.width - 1, this.y + this.height - 1, -12829636);
        if (this.currentConfig == null) {
            this.drawScaledText(context, "No chest selected", this.x + this.width / 2 - 30, this.y + this.height / 2, -7829368, 0.65f);
            return;
        }
        boolean bl = anyDropdownOpen = this.categoryDropdown != null && this.categoryDropdown.isOpen() || this.filterModeDropdown != null && this.filterModeDropdown.isOpen() || this.priorityDropdown != null && this.priorityDropdown.isOpen() || this.externalDropdownOpen;
        if (this.nameField != null && this.isRenaming) {
            this.nameField.method_1862(!anyDropdownOpen);
        }
        int currentY = this.y + 4;
        int innerX = this.x + 5;
        if (this.showHeader) {
            this.drawScaledText(context, "Chest Config", innerX, currentY, -1, 0.7f);
            currentY += 8;
        }
        if (this.showRenameButton) {
            if (this.isRenaming && !anyDropdownOpen) {
                this.nameField.method_46421(innerX);
                this.nameField.method_46419(currentY);
                this.nameField.method_25358(this.width - 10 - 40);
                this.nameField.method_25394(context, mouseX, mouseY, delta);
            } else if (this.currentConfig.customName != null && !this.currentConfig.customName.isEmpty()) {
                nameDisplay = this.currentConfig.customName.length() > 25 ? this.currentConfig.customName.substring(0, 22) + "..." : this.currentConfig.customName;
                this.drawScaledText(context, "\u00a77Name: \u00a7f" + nameDisplay, innerX, currentY, -1, 0.65f);
            } else {
                this.drawScaledText(context, "\u00a77Name: \u00a78(unnamed)", innerX, currentY, -7829368, 0.65f);
            }
            if (this.renameButton != null) {
                this.renameButton.method_46421(innerX + this.width - 10 - 40);
                this.renameButton.method_46419(currentY - 1);
                this.renameButton.method_25394(context, mouseX, mouseY, delta);
            }
            currentY += 12;
        } else if (this.currentConfig.customName != null && !this.currentConfig.customName.isEmpty()) {
            nameDisplay = this.currentConfig.customName.length() > 25 ? this.currentConfig.customName.substring(0, 22) + "..." : this.currentConfig.customName;
            this.drawScaledText(context, "\u00a77Name: \u00a7f" + nameDisplay, innerX, currentY, -1, 0.65f);
            currentY += 7;
        }
        if (this.showHeader) {
            String location = String.format("\u00a78[%d, %d, %d]", this.currentConfig.position.method_10263(), this.currentConfig.position.method_10264(), this.currentConfig.position.method_10260());
            this.drawScaledText(context, location, innerX, currentY, -5592406, 0.65f);
            currentY += 10;
        }
        if (this.currentConfig.filterMode.needsCategoryFilter()) {
            this.drawScaledText(context, "\u00a77Filter:", innerX, currentY + 1, -5592406, 0.65f);
            this.categoryDropdown.method_46421(innerX + 35);
            this.categoryDropdown.method_46419(currentY);
            this.categoryDropdown.method_25394(context, mouseX, mouseY, delta);
            currentY += 13;
        }
        this.drawScaledText(context, "\u00a77Priority:", innerX, currentY + 1, -5592406, 0.65f);
        if (this.priorityDropdown != null) {
            this.priorityDropdown.method_46421(innerX + 35);
            this.priorityDropdown.method_46419(currentY);
            this.priorityDropdown.method_25394(context, mouseX, mouseY, delta);
        } else if (this.priorityField != null) {
            this.priorityField.method_46421(innerX + 35);
            this.priorityField.method_46419(currentY);
            this.priorityField.method_1862(true);
            this.priorityField.method_1888(!anyDropdownOpen);
            this.priorityField.method_25394(context, mouseX, mouseY, delta);
            this.drawScaledText(context, "\u00a78(1-" + this.maxPriority + ")", innerX + 68, currentY + 1, -7829368, 0.55f);
        }
        this.drawScaledText(context, "\u00a77Mode:", innerX, (currentY += 13) + 1, -5592406, 0.65f);
        this.filterModeDropdown.method_46421(innerX + 35);
        this.filterModeDropdown.method_46419(currentY);
        this.filterModeDropdown.method_25394(context, mouseX, mouseY, delta);
        currentY += 13;
        if (this.currentConfig.filterMode != null) {
            String description = "\u00a78" + this.currentConfig.filterMode.getDescription();
            this.drawScaledText(context, description, innerX + 2, currentY, -7829368, 0.55f);
            currentY += 8;
        }
        if (this.currentConfig.filterMode == ChestConfig.FilterMode.CUSTOM) {
            this.strictNBTCheckbox.method_46421(innerX);
            this.strictNBTCheckbox.method_46419(currentY);
            this.strictNBTCheckbox.method_25394(context, mouseX, mouseY, delta);
            int descX = innerX + 63;
            if (this.currentConfig.strictNBTMatch) {
                this.drawScaledText(context, "\u00a78- Exact match (enchants, damage)", descX, currentY + 1, -7829368, 0.55f);
            } else {
                this.drawScaledText(context, "\u00a78- Item type only (ignores NBT)", descX, currentY + 1, -7829368, 0.55f);
            }
        }
        if (this.priorityField != null) {
            this.priorityField.method_1862(true);
        }
        if (this.nameField != null) {
            this.nameField.method_1862(this.isRenaming && !anyDropdownOpen);
        }
        if (this.categoryDropdown != null && this.categoryDropdown.isOpen()) {
            this.categoryDropdown.renderDropdown(context, mouseX, mouseY);
        }
        if (this.filterModeDropdown != null && this.filterModeDropdown.isOpen()) {
            this.filterModeDropdown.renderDropdown(context, mouseX, mouseY);
        }
        if (this.priorityDropdown != null && this.priorityDropdown.isOpen()) {
            this.priorityDropdown.renderDropdown(context, mouseX, mouseY);
        }
    }

    private void drawScaledText(class_332 context, String text, int x, int y, int color, float scale) {
        Matrix3x2f oldMatrix = new Matrix3x2f((Matrix3x2fc)context.method_51448());
        Matrix3x2f scaleMatrix = new Matrix3x2f().scaling(scale, scale);
        context.method_51448().mul((Matrix3x2fc)scaleMatrix);
        Matrix3x2f translateMatrix = new Matrix3x2f().translation((float)x / scale, (float)y / scale);
        context.method_51448().mul((Matrix3x2fc)translateMatrix);
        context.method_51433(this.textRenderer, text, 0, 0, color, false);
        context.method_51448().set((Matrix3x2fc)oldMatrix);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.nameField != null && this.nameField.method_25370()) {
            if (keyCode == 257) {
                this.toggleRename();
                return true;
            }
            return this.nameField.method_25404(keyCode, scanCode, modifiers);
        }
        if (this.priorityField != null && this.priorityField.method_25370()) {
            return this.priorityField.method_25404(keyCode, scanCode, modifiers);
        }
        return false;
    }

    public boolean method_25400(char chr, int modifiers) {
        if (this.nameField != null && this.nameField.method_25370()) {
            return this.nameField.method_25400(chr, modifiers);
        }
        if (this.priorityField != null && this.priorityField.method_25370()) {
            return this.priorityField.method_25400(chr, modifiers);
        }
        return false;
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (this.currentConfig == null) {
            return false;
        }
        if (this.filterModeDropdown.isOpen()) {
            return this.filterModeDropdown.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
        }
        if (this.priorityDropdown != null && this.priorityDropdown.isOpen()) {
            return this.priorityDropdown.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
        }
        if (this.currentConfig.filterMode.needsCategoryFilter() && this.categoryDropdown.isOpen()) {
            return this.categoryDropdown.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
        }
        return false;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.currentConfig == null) {
            return false;
        }
        if (this.showRenameButton && this.renameButton != null) {
            if (this.renameButton.method_25402(mouseX, mouseY, button)) {
                return true;
            }
            if (this.isRenaming && this.nameField.method_25402(mouseX, mouseY, button)) {
                this.nameField.method_25365(true);
                return true;
            }
        }
        if (this.currentConfig.filterMode.needsCategoryFilter() && this.categoryDropdown.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        if (this.priorityDropdown != null && this.priorityDropdown.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        if (this.priorityField != null) {
            int px = this.priorityField.method_46426();
            int py = this.priorityField.method_46427();
            int pw = this.priorityField.method_25368();
            int ph = this.priorityField.method_25364();
            if (mouseX >= (double)px && mouseX < (double)(px + pw) && mouseY >= (double)py && mouseY < (double)(py + ph)) {
                this.priorityField.method_25365(true);
                this.priorityField.method_25402(mouseX, mouseY, button);
                return true;
            }
        }
        if (this.filterModeDropdown.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        return this.currentConfig.filterMode == ChestConfig.FilterMode.CUSTOM && this.strictNBTCheckbox.method_25402(mouseX, mouseY, button);
    }

    public class_6379.class_6380 method_37018() {
        return class_6379.class_6380.field_33784;
    }

    public void method_37020(class_6382 builder) {
    }
}

