/*
 * Decompiled with CFR 0.152.
 */
package net.shaddii.smartsorter;

import java.util.Objects;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.shaddii.smartsorter.block.IntakeBlock;
import net.shaddii.smartsorter.blockentity.IntakeBlockEntity;
import net.shaddii.smartsorter.blockentity.OutputProbeBlockEntity;
import net.shaddii.smartsorter.blockentity.StorageControllerBlockEntity;

public final class StorageLogic {
    private static final int MAX_PULL_PER_OP = 8;

    private StorageLogic() {
    }

    public static boolean pullAndRoute(IntakeBlockEntity intake) {
        if (intake == null || intake.method_10997() == null || intake.method_10997().method_8608()) {
            return false;
        }
        if (!intake.getBuffer().method_7960()) {
            return StorageLogic.tryRouteBuffer(intake);
        }
        class_1937 world = intake.method_10997();
        class_2350 facing = (class_2350)intake.method_11010().method_11654(IntakeBlock.FACING);
        class_2338 sourcePos = intake.method_11016().method_10093(facing);
        Storage<ItemVariant> fromStorage = StorageLogic.locateItemStorage(world, sourcePos, facing.method_10153());
        if (fromStorage == null) {
            return false;
        }
        for (StorageView view : fromStorage) {
            if (view.isResourceBlank() || view.getAmount() == 0L) continue;
            ItemVariant variant = (ItemVariant)view.getResource();
            int maxAmount = (int)Math.min(8L, view.getAmount());
            Transaction tx = Transaction.openOuter();
            try {
                class_1799 remainder;
                long extractedAmount = view.extract((Object)variant, (long)maxAmount, (TransactionContext)tx);
                if (extractedAmount == 0L) continue;
                class_1799 extractedStack = variant.toStack((int)extractedAmount);
                if (intake.isInManagedMode()) {
                    StorageControllerBlockEntity controller = StorageLogic.getController(world, intake);
                    if (controller == null) {
                        tx.abort();
                        continue;
                    }
                    remainder = controller.insertItem(extractedStack).remainder();
                } else if (intake.isInDirectMode()) {
                    remainder = StorageLogic.insertIntoDirectOutputs(world, intake, extractedStack);
                } else {
                    tx.abort();
                    boolean controller = false;
                    return controller;
                }
                long insertedAmount = extractedAmount - (long)remainder.method_7947();
                if (insertedAmount > 0L) {
                    intake.setBuffer(remainder);
                    tx.commit();
                    boolean bl = true;
                    return bl;
                }
                tx.abort();
            }
            finally {
                if (tx == null) continue;
                tx.close();
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean tryRouteBuffer(IntakeBlockEntity intake) {
        class_1799 remainder;
        class_1937 world = intake.method_10997();
        class_1799 bufferStack = intake.getBuffer();
        if (world == null || bufferStack.method_7960()) {
            return false;
        }
        if (intake.isInManagedMode()) {
            StorageControllerBlockEntity controller = StorageLogic.getController(world, intake);
            if (controller == null) return false;
            remainder = controller.insertItem(bufferStack).remainder();
        } else {
            if (!intake.isInDirectMode()) return false;
            remainder = StorageLogic.insertIntoDirectOutputs(world, intake, bufferStack);
        }
        if (remainder.method_7947() >= bufferStack.method_7947()) return false;
        intake.setBuffer(remainder);
        return true;
    }

    private static StorageControllerBlockEntity getController(class_1937 world, IntakeBlockEntity intake) {
        StorageControllerBlockEntity controller;
        class_2338 controllerPos = intake.getController();
        if (controllerPos == null) {
            return null;
        }
        class_2586 be = world.method_8321(controllerPos);
        return be instanceof StorageControllerBlockEntity ? (controller = (StorageControllerBlockEntity)be) : null;
    }

    private static class_1799 insertIntoDirectOutputs(class_1937 world, IntakeBlockEntity intake, class_1799 stackToInsert) {
        ItemVariant variant = ItemVariant.of((class_1799)stackToInsert);
        class_1799 currentStack = stackToInsert.method_7972();
        for (class_2338 probePos : intake.getOutputs()) {
            int inserted;
            OutputProbeBlockEntity probe;
            if (currentStack.method_7960()) break;
            class_2586 target = world.method_8321(probePos);
            if (!(target instanceof OutputProbeBlockEntity) || !(probe = (OutputProbeBlockEntity)target).accepts(variant) || (inserted = StorageLogic.insertIntoInventoryFacingProbe(world, probe, variant, currentStack.method_7947())) <= 0) continue;
            currentStack.method_7934(inserted);
        }
        return currentStack;
    }

    private static int insertIntoInventoryFacingProbe(class_1937 world, OutputProbeBlockEntity probe, ItemVariant variant, int amount) {
        class_1263 inventory = probe.getTargetInventory();
        if (inventory == null) {
            return 0;
        }
        class_1799 toInsert = variant.toStack(amount);
        int originalCount = toInsert.method_7947();
        int maxStackSize = Math.min(toInsert.method_7914(), inventory.method_5444());
        boolean inventoryChanged = false;
        for (int i = 0; i < inventory.method_5439() && !toInsert.method_7960(); ++i) {
            int canAdd;
            class_1799 slot = inventory.method_5438(i);
            if (slot.method_7960()) {
                int insertCount = Math.min(maxStackSize, toInsert.method_7947());
                inventory.method_5447(i, toInsert.method_46651(insertCount));
                toInsert.method_7934(insertCount);
                inventoryChanged = true;
                continue;
            }
            if (!class_1799.method_31577((class_1799)slot, (class_1799)toInsert) || (canAdd = maxStackSize - slot.method_7947()) <= 0) continue;
            int add = Math.min(canAdd, toInsert.method_7947());
            slot.method_7933(add);
            toInsert.method_7934(add);
            inventoryChanged = true;
        }
        if (inventoryChanged) {
            inventory.method_5431();
            probe.invalidateConfigCache();
        }
        return originalCount - toInsert.method_7947();
    }

    private static Storage<ItemVariant> locateItemStorage(class_1937 world, class_2338 pos, class_2350 searchSide) {
        Objects.requireNonNull(world);
        Objects.requireNonNull(pos);
        Storage found = (Storage)ItemStorage.SIDED.find(world, pos, (Object)searchSide);
        if (found == null) {
            found = (Storage)ItemStorage.SIDED.find(world, pos, null);
        }
        class_2586 be = world.method_8321(pos);
        if (found == null && be instanceof class_1263) {
            class_1263 inv = (class_1263)be;
            found = InventoryStorage.of((class_1263)inv, null);
        }
        return found;
    }
}

