/*
 * Decompiled with CFR 0.152.
 */
package net.shaddii.smartsorter.blockentity;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_7225;
import net.minecraft.class_8824;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.shaddii.smartsorter.SmartSorter;
import net.shaddii.smartsorter.block.OutputProbeBlock;
import net.shaddii.smartsorter.blockentity.IntakeBlockEntity;
import net.shaddii.smartsorter.blockentity.StorageControllerBlockEntity;
import net.shaddii.smartsorter.screen.OutputProbeScreenHandler;
import net.shaddii.smartsorter.util.Category;
import net.shaddii.smartsorter.util.CategoryManager;
import net.shaddii.smartsorter.util.ChestConfig;
import net.shaddii.smartsorter.util.SortUtil;
import org.jetbrains.annotations.Nullable;

public class OutputProbeBlockEntity
extends class_2586
implements ExtendedScreenHandlerFactory {
    private static final long VALIDATION_INTERVAL = 200L;
    public boolean ignoreComponents = true;
    public boolean useTags = false;
    public boolean requireAllTags = false;
    public ProbeMode mode = ProbeMode.FILTER;
    private ChestConfig localChestConfig = null;
    private final List<class_2338> linkedBlocks = new ArrayList<class_2338>();
    private List<class_2338> linkedBlocksCopy = null;
    private boolean linkedBlocksCopyDirty = true;
    private class_2338 cachedChestPos = null;
    private ChestConfig cachedConfig = null;
    private long cacheValidUntil = 0L;
    private static final long CACHE_DURATION = 20L;
    private Boolean cachedHasSpace = null;
    private long spaceCheckTime = 0L;

    public OutputProbeBlockEntity(class_2338 pos, class_2680 state) {
        super(SmartSorter.PROBE_BE_TYPE, pos, state);
    }

    public void onPlaced(class_1937 world) {
        if (world.method_8608()) {
            return;
        }
        class_2338 targetPos = this.getTargetPos();
        if (targetPos != null && this.localChestConfig == null) {
            class_2487 nbt;
            this.localChestConfig = new ChestConfig(targetPos);
            if (this.localChestConfig.filterMode == ChestConfig.FilterMode.OVERFLOW) {
                this.localChestConfig.simplePrioritySelection = ChestConfig.SimplePriority.LOWEST;
                this.localChestConfig.priority = 999;
            } else {
                this.localChestConfig.simplePrioritySelection = ChestConfig.SimplePriority.MEDIUM;
                this.localChestConfig.priority = 5;
            }
            class_2586 be = world.method_8321(targetPos);
            if (be != null && (nbt = be.method_38244((class_7225.class_7874)world.method_30349())).method_10545("CustomName")) {
                try {
                    DataResult result = class_8824.field_46597.parse((DynamicOps)world.method_30349().method_57093((DynamicOps)class_2509.field_11560), (Object)nbt.method_10580("CustomName"));
                    result.result().ifPresent(text -> {
                        this.localChestConfig.customName = text.getString();
                    });
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.localChestConfig.updateHiddenPriority();
            this.method_5431();
        }
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, OutputProbeBlockEntity be) {
        if (world.method_8608()) {
            return;
        }
        if (world.method_8510() % 200L == 0L) {
            be.validateLinkedBlocks();
        }
    }

    private void validateLinkedBlocks() {
        if (this.field_11863 == null) {
            return;
        }
        this.linkedBlocks.removeIf(blockPos -> {
            class_2586 be = this.field_11863.method_8321(blockPos);
            return !(be instanceof StorageControllerBlockEntity) && !(be instanceof IntakeBlockEntity);
        });
    }

    public ChestConfig getChestConfig() {
        long currentTime;
        class_2338 targetPos = this.getTargetPos();
        if (targetPos == null) {
            return null;
        }
        long l = currentTime = this.field_11863 != null ? this.field_11863.method_8510() : 0L;
        if (this.cachedConfig != null && currentTime < this.cacheValidUntil) {
            return this.cachedConfig;
        }
        for (class_2338 blockPos : this.linkedBlocks) {
            StorageControllerBlockEntity controller;
            ChestConfig controllerConfig;
            if (this.field_11863 == null) break;
            class_2586 be = this.field_11863.method_8321(blockPos);
            if (!(be instanceof StorageControllerBlockEntity) || (controllerConfig = (controller = (StorageControllerBlockEntity)be).getChestConfig(targetPos)) == null) continue;
            this.cachedConfig = controllerConfig;
            this.cacheValidUntil = currentTime + 20L;
            return controllerConfig;
        }
        if (this.localChestConfig == null) {
            this.localChestConfig = new ChestConfig(targetPos);
            this.localChestConfig.simplePrioritySelection = ChestConfig.SimplePriority.MEDIUM;
            if (this.localChestConfig.filterMode == ChestConfig.FilterMode.OVERFLOW) {
                this.localChestConfig.simplePrioritySelection = ChestConfig.SimplePriority.LOWEST;
            }
        } else if (!this.localChestConfig.position.equals((Object)targetPos)) {
            this.localChestConfig = new ChestConfig(targetPos);
            this.localChestConfig.simplePrioritySelection = ChestConfig.SimplePriority.MEDIUM;
            if (this.localChestConfig.filterMode == ChestConfig.FilterMode.OVERFLOW) {
                this.localChestConfig.simplePrioritySelection = ChestConfig.SimplePriority.LOWEST;
            }
        }
        this.cachedConfig = this.localChestConfig;
        this.cacheValidUntil = currentTime + 20L;
        return this.localChestConfig;
    }

    public void invalidateConfigCache() {
        this.cachedConfig = null;
        this.cacheValidUntil = 0L;
        this.cachedHasSpace = null;
        this.spaceCheckTime = 0L;
    }

    public void setChestConfig(ChestConfig config) {
        if (config == null) {
            return;
        }
        this.localChestConfig = config.copy();
        if (this.localChestConfig.simplePrioritySelection == null) {
            this.localChestConfig.simplePrioritySelection = ChestConfig.SimplePriority.MEDIUM;
        }
        this.localChestConfig.updateHiddenPriority();
        this.invalidateConfigCache();
        this.method_5431();
        if (this.field_11863 != null) {
            class_2680 state = this.method_11010();
            this.field_11863.method_8413(this.field_11867, state, state, 3);
        }
        this.syncConfigToController();
    }

    private void syncConfigToController() {
        if (this.field_11863 == null || this.field_11863.method_8608() || this.localChestConfig == null) {
            return;
        }
        for (class_2338 blockPos : this.linkedBlocks) {
            class_2586 be = this.field_11863.method_8321(blockPos);
            if (!(be instanceof StorageControllerBlockEntity)) continue;
            StorageControllerBlockEntity controller = (StorageControllerBlockEntity)be;
            controller.updateChestConfig(this.localChestConfig.position, this.localChestConfig);
            controller.method_5431();
        }
    }

    public boolean addLinkedBlock(class_2338 blockPos) {
        if (this.field_11863 == null) {
            return false;
        }
        class_2586 newBE = this.field_11863.method_8321(blockPos);
        if (newBE instanceof StorageControllerBlockEntity) {
            this.linkedBlocks.removeIf(existingPos -> {
                class_2586 existingBE = this.field_11863.method_8321(existingPos);
                return existingBE == null || existingBE instanceof StorageControllerBlockEntity;
            });
        }
        if (!this.linkedBlocks.contains(blockPos)) {
            this.linkedBlocks.add(blockPos);
            this.linkedBlocksCopyDirty = true;
            this.method_5431();
            if (this.field_11863 != null) {
                class_2680 state = this.field_11863.method_8320(this.field_11867);
                this.field_11863.method_8413(this.field_11867, state, state, 3);
                if (newBE instanceof StorageControllerBlockEntity) {
                    StorageControllerBlockEntity controller = (StorageControllerBlockEntity)newBE;
                    if (this.localChestConfig != null) {
                        controller.updateChestConfig(this.localChestConfig.position, this.localChestConfig);
                    }
                }
            }
            return true;
        }
        return false;
    }

    public boolean removeLinkedBlock(class_2338 blockPos) {
        boolean removed = this.linkedBlocks.remove(blockPos);
        if (removed) {
            this.linkedBlocksCopyDirty = true;
            this.method_5431();
            if (this.field_11863 != null) {
                class_2680 state = this.field_11863.method_8320(this.field_11867);
                this.field_11863.method_8413(this.field_11867, state, state, 3);
            }
        }
        return removed;
    }

    public List<class_2338> getLinkedBlocks() {
        if (this.linkedBlocksCopyDirty || this.linkedBlocksCopy == null) {
            this.linkedBlocksCopy = new ArrayList<class_2338>(this.linkedBlocks);
            this.linkedBlocksCopyDirty = false;
        }
        return this.linkedBlocksCopy;
    }

    public void updateLocalConfig(ChestConfig config) {
        if (config == null) {
            return;
        }
        this.localChestConfig = config.copy();
        if (this.localChestConfig.simplePrioritySelection == null) {
            this.localChestConfig.simplePrioritySelection = ChestConfig.SimplePriority.MEDIUM;
        }
        this.method_5431();
        if (this.field_11863 != null) {
            class_2680 state = this.method_11010();
            this.field_11863.method_8413(this.field_11867, state, state, 3);
        }
    }

    @Deprecated
    public void setLinkedController(class_2338 controllerPos) {
        this.addLinkedBlock(controllerPos);
    }

    @Deprecated
    public class_2338 getLinkedController() {
        if (this.field_11863 == null) {
            return null;
        }
        for (class_2338 blockPos : this.linkedBlocks) {
            class_2586 be = this.field_11863.method_8321(blockPos);
            if (!(be instanceof StorageControllerBlockEntity)) continue;
            return blockPos;
        }
        return null;
    }

    public class_2338 getTargetPos() {
        if (this.field_11863 == null) {
            return null;
        }
        class_2350 face = (class_2350)this.method_11010().method_11654(OutputProbeBlock.FACING);
        return this.field_11867.method_10093(face);
    }

    public Storage<ItemVariant> getTargetStorage() {
        if (this.field_11863 == null) {
            return null;
        }
        class_2350 face = (class_2350)this.method_11010().method_11654(OutputProbeBlock.FACING);
        class_2338 targetPos = this.field_11867.method_10093(face);
        Storage sidedStorage = (Storage)ItemStorage.SIDED.find(this.field_11863, targetPos, (Object)face.method_10153());
        if (sidedStorage != null) {
            return sidedStorage;
        }
        Storage storage = (Storage)ItemStorage.SIDED.find(this.field_11863, targetPos, null);
        if (storage != null) {
            return storage;
        }
        class_1263 inv = this.getTargetInventory();
        if (inv != null) {
            return InventoryStorage.of((class_1263)inv, null);
        }
        return null;
    }

    public class_1263 getTargetInventory() {
        class_2281 chestBlock;
        class_1263 chestInv;
        if (this.field_11863 == null) {
            return null;
        }
        class_2350 face = (class_2350)this.method_11010().method_11654(OutputProbeBlock.FACING);
        class_2338 targetPos = this.field_11867.method_10093(face);
        class_2680 targetState = this.field_11863.method_8320(targetPos);
        class_2248 class_22482 = targetState.method_26204();
        if (class_22482 instanceof class_2281 && (chestInv = class_2281.method_17458((class_2281)(chestBlock = (class_2281)class_22482), (class_2680)targetState, (class_1937)this.field_11863, (class_2338)targetPos, (boolean)true)) != null) {
            return chestInv;
        }
        class_2586 be = this.field_11863.method_8321(targetPos);
        if (be instanceof class_1263) {
            class_1263 inv = (class_1263)be;
            return inv;
        }
        return null;
    }

    public boolean accepts(ItemVariant incoming) {
        if (this.field_11863 == null) {
            return false;
        }
        long currentTime = this.field_11863.method_8510();
        if (this.cachedHasSpace != null && currentTime == this.spaceCheckTime && !this.cachedHasSpace.booleanValue()) {
            return false;
        }
        class_1263 inv = this.getTargetInventory();
        if (inv == null) {
            this.cachedHasSpace = false;
            this.spaceCheckTime = currentTime;
            return false;
        }
        boolean hasSpace = this.hasSpaceInInventoryFast(inv, incoming, 1);
        if (!hasSpace) {
            this.cachedHasSpace = false;
            this.spaceCheckTime = currentTime;
            return false;
        }
        this.cachedHasSpace = true;
        this.spaceCheckTime = currentTime;
        ChestConfig chestConfig = this.getChestConfig();
        if (chestConfig != null) {
            CategoryManager categoryManager = CategoryManager.getInstance();
            Category itemCategory = categoryManager.categorize(incoming.getItem());
            switch (chestConfig.filterMode) {
                case NONE: 
                case PRIORITY: {
                    return true;
                }
                case CATEGORY: 
                case CATEGORY_AND_PRIORITY: 
                case OVERFLOW: {
                    return itemCategory.equals(chestConfig.filterCategory) || chestConfig.filterCategory.equals(Category.ALL);
                }
                case BLACKLIST: {
                    return !itemCategory.equals(chestConfig.filterCategory);
                }
                case CUSTOM: {
                    return this.acceptsByChestContents(inv, incoming, chestConfig.strictNBTMatch);
                }
            }
            return false;
        }
        if (this.mode == ProbeMode.ACCEPT_ALL || this.mode == ProbeMode.PRIORITY) {
            return true;
        }
        if (this.mode == ProbeMode.FILTER) {
            if (this.useTags) {
                return SortUtil.acceptsByInventoryTags(inv, incoming, this.requireAllTags);
            }
            for (int i = 0; i < inv.method_5439(); ++i) {
                class_1799 stack = inv.method_5438(i);
                if (stack.method_7960()) continue;
                ItemVariant present = ItemVariant.of((class_1799)stack);
                if (!(this.ignoreComponents ? present.isOf((Object)incoming.getItem()) : present.equals((Object)incoming))) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private boolean hasSpaceInInventoryFast(class_1263 inv, ItemVariant variant, int amount) {
        if (inv == null) {
            return false;
        }
        int invSize = inv.method_5439();
        class_1799 variantStack = variant.toStack(1);
        for (int i = 0; i < invSize; ++i) {
            class_1799 stack = inv.method_5438(i);
            if (stack.method_7960()) {
                return true;
            }
            if (!class_1799.method_31577((class_1799)stack, (class_1799)variantStack)) continue;
            int maxStack = Math.min(stack.method_7914(), inv.method_5444());
            if (stack.method_7947() >= maxStack) continue;
            return true;
        }
        return false;
    }

    public boolean contains(ItemVariant variant) {
        if (this.field_11863 == null) {
            return false;
        }
        class_1263 inv = this.getTargetInventory();
        if (inv == null) {
            return false;
        }
        for (int i = 0; i < inv.method_5439(); ++i) {
            ItemVariant stackVariant;
            class_1799 stack = inv.method_5438(i);
            if (stack.method_7960() || !(stackVariant = ItemVariant.of((class_1799)stack)).equals((Object)variant)) continue;
            return true;
        }
        return false;
    }

    private boolean acceptsByChestContents(class_1263 inv, ItemVariant incoming, boolean strictNBT) {
        if (inv == null) {
            return false;
        }
        boolean foundAnyItem = false;
        boolean foundMatch = false;
        for (int i = 0; i < inv.method_5439(); ++i) {
            class_1799 stack = inv.method_5438(i);
            if (stack.method_7960()) continue;
            foundAnyItem = true;
            if (strictNBT) {
                ItemVariant existingVariant = ItemVariant.of((class_1799)stack);
                if (!existingVariant.equals((Object)incoming)) continue;
                foundMatch = true;
                break;
            }
            if (stack.method_7909() != incoming.getItem()) continue;
            foundMatch = true;
            break;
        }
        if (!foundAnyItem) {
            return false;
        }
        return foundMatch && this.hasSpaceInInventory(inv, incoming, 1);
    }

    private boolean hasSpaceInInventory(class_1263 inv, ItemVariant variant, int amount) {
        if (inv == null) {
            return false;
        }
        int invSize = inv.method_5439();
        for (int i = 0; i < invSize; ++i) {
            int maxStack;
            int canAdd;
            class_1799 stack = inv.method_5438(i);
            if (stack.method_7960()) {
                return true;
            }
            if (!class_1799.method_31577((class_1799)stack, (class_1799)variant.toStack(1)) || (canAdd = (maxStack = Math.min(stack.method_7914(), inv.method_5444())) - stack.method_7947()) <= 0) continue;
            return true;
        }
        return false;
    }

    public boolean hasSpace(ItemVariant variant, int amount) {
        class_1263 inv = this.getTargetInventory();
        return this.hasSpaceInInventory(inv, variant, amount);
    }

    public void cycleMode() {
        this.mode = switch (this.mode.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> ProbeMode.ACCEPT_ALL;
            case 1 -> ProbeMode.FILTER;
            case 2 -> ProbeMode.FILTER;
        };
        this.method_5431();
    }

    public String getModeName() {
        return switch (this.mode.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> "Filter Mode";
            case 1 -> "Accept All";
            case 2 -> "Priority Mode";
        };
    }

    public class_2561 method_5476() {
        return class_2561.method_43470((String)"Output Probe");
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new OutputProbeScreenHandler(syncId, playerInventory, this);
    }

    public ProbeData getScreenOpeningData(class_3222 player) {
        class_2338 targetPos = this.getTargetPos();
        ChestConfig config = this.getChestConfig();
        return new ProbeData(targetPos != null ? targetPos : class_2338.field_10980, config);
    }

    public void onRemoved(class_1937 world) {
        if (world == null || world.method_8608()) {
            return;
        }
        class_2338 targetPos = this.getTargetPos();
        ArrayList<class_2338> linkedBlocksCopy = new ArrayList<class_2338>(this.linkedBlocks);
        for (class_2338 blockPos : linkedBlocksCopy) {
            class_2586 be = world.method_8321(blockPos);
            if (!(be instanceof StorageControllerBlockEntity)) continue;
            StorageControllerBlockEntity controller = (StorageControllerBlockEntity)be;
            controller.removeProbe(this.field_11867);
            if (targetPos == null) continue;
            boolean stillHasProbe = false;
            List<class_2338> remainingProbes = controller.getLinkedProbes();
            for (class_2338 otherProbePos : remainingProbes) {
                OutputProbeBlockEntity otherProbe;
                class_2338 otherTarget;
                class_2586 otherBe;
                if (otherProbePos.equals((Object)this.field_11867) || !((otherBe = world.method_8321(otherProbePos)) instanceof OutputProbeBlockEntity) || !targetPos.equals((Object)(otherTarget = (otherProbe = (OutputProbeBlockEntity)otherBe).getTargetPos()))) continue;
                stillHasProbe = true;
                break;
            }
            if (stillHasProbe) continue;
            controller.removeChestConfig(targetPos);
        }
        this.linkedBlocks.clear();
        this.localChestConfig = null;
    }

    public void clearController() {
        this.linkedBlocks.removeIf(blockPos -> true);
        this.linkedBlocksCopyDirty = true;
        this.method_5431();
        if (this.field_11863 != null) {
            class_2680 state = this.field_11863.method_8320(this.field_11867);
            this.field_11863.method_8413(this.field_11867, state, state, 3);
        }
    }

    public void removeController(class_2338 controllerPos) {
        if (this.linkedBlocks.remove(controllerPos)) {
            this.linkedBlocksCopyDirty = true;
            this.method_5431();
            if (this.field_11863 != null) {
                class_2680 state = this.field_11863.method_8320(this.field_11867);
                this.field_11863.method_8413(this.field_11867, state, state, 3);
            }
        }
    }

    private void writeProbeData(class_11372 view) {
        view.method_71472("ignoreComponents", this.ignoreComponents);
        view.method_71472("useTags", this.useTags);
        view.method_71472("requireAllTags", this.requireAllTags);
        view.method_71469("mode", this.mode.name());
        view.method_71465("linked_blocks_count", this.linkedBlocks.size());
        for (int i = 0; i < this.linkedBlocks.size(); ++i) {
            view.method_71466("linked_block_" + i, this.linkedBlocks.get(i).method_10063());
        }
        if (this.localChestConfig != null) {
            view.method_71472("has_local_config", true);
            view.method_71466("local_chest_pos", this.localChestConfig.position.method_10063());
            view.method_71469("local_chest_name", this.localChestConfig.customName != null ? this.localChestConfig.customName : "");
            view.method_71469("local_chest_category", this.localChestConfig.filterCategory.asString());
            view.method_71465("local_chest_priority", this.localChestConfig.priority);
            view.method_71469("local_chest_mode", this.localChestConfig.filterMode.name());
            view.method_71472("local_chest_nbt", this.localChestConfig.strictNBTMatch);
            view.method_71472("local_chest_frame", this.localChestConfig.autoItemFrame);
            if (this.localChestConfig.simplePrioritySelection != null) {
                view.method_71469("local_simple_priority", this.localChestConfig.simplePrioritySelection.name());
            }
        } else {
            view.method_71472("has_local_config", false);
        }
    }

    private void writeProbeData(class_2487 nbt) {
        nbt.method_10556("ignoreComponents", this.ignoreComponents);
        nbt.method_10556("useTags", this.useTags);
        nbt.method_10556("requireAllTags", this.requireAllTags);
        nbt.method_10582("mode", this.mode.name());
        nbt.method_10569("linked_blocks_count", this.linkedBlocks.size());
        for (int i = 0; i < this.linkedBlocks.size(); ++i) {
            nbt.method_10544("linked_block_" + i, this.linkedBlocks.get(i).method_10063());
        }
        if (this.localChestConfig != null) {
            nbt.method_10556("has_local_config", true);
            nbt.method_10544("local_chest_pos", this.localChestConfig.position.method_10063());
            nbt.method_10582("local_chest_name", this.localChestConfig.customName != null ? this.localChestConfig.customName : "");
            nbt.method_10582("local_chest_category", this.localChestConfig.filterCategory.asString());
            nbt.method_10569("local_chest_priority", this.localChestConfig.priority);
            nbt.method_10582("local_chest_mode", this.localChestConfig.filterMode.name());
            nbt.method_10556("local_chest_nbt", this.localChestConfig.strictNBTMatch);
            nbt.method_10556("local_chest_frame", this.localChestConfig.autoItemFrame);
            if (this.localChestConfig.simplePrioritySelection != null) {
                nbt.method_10582("local_simple_priority", this.localChestConfig.simplePrioritySelection.name());
            }
        } else {
            nbt.method_10556("has_local_config", false);
        }
    }

    private void readProbeData(class_11368 view) {
        this.ignoreComponents = view.method_71433("ignoreComponents", true);
        this.useTags = view.method_71433("useTags", false);
        this.requireAllTags = view.method_71433("requireAllTags", false);
        try {
            this.mode = ProbeMode.valueOf(view.method_71428("mode", "FILTER"));
        }
        catch (IllegalArgumentException e) {
            this.mode = ProbeMode.FILTER;
        }
        this.linkedBlocks.clear();
        int count = view.method_71424("linked_blocks_count", 0);
        for (int i = 0; i < count; ++i) {
            view.method_71440("linked_block_" + i).ifPresent(posLong -> this.linkedBlocks.add(class_2338.method_10092((long)posLong)));
        }
        if (view.method_71433("has_local_config", false)) {
            view.method_71440("local_chest_pos").ifPresent(posLong -> {
                class_2338 chestPos = class_2338.method_10092((long)posLong);
                String name = view.method_71428("local_chest_name", "");
                String categoryStr = view.method_71428("local_chest_category", "smartsorter:all");
                int priority = view.method_71424("local_chest_priority", 1);
                String modeStr = view.method_71428("local_chest_mode", "NONE");
                boolean strictNBT = view.method_71433("local_chest_nbt", false);
                boolean autoFrame = view.method_71433("local_chest_frame", false);
                Category category = CategoryManager.getInstance().getCategory(categoryStr);
                ChestConfig.FilterMode filterMode = ChestConfig.FilterMode.valueOf(modeStr);
                this.localChestConfig = new ChestConfig(chestPos, name, category, priority, filterMode, autoFrame);
                this.localChestConfig.strictNBTMatch = strictNBT;
                String simplePriorityStr = view.method_71428("local_simple_priority", null);
                if (simplePriorityStr != null && !simplePriorityStr.isEmpty()) {
                    try {
                        this.localChestConfig.simplePrioritySelection = ChestConfig.SimplePriority.valueOf(simplePriorityStr);
                    }
                    catch (Exception e) {
                        this.localChestConfig.simplePrioritySelection = ChestConfig.SimplePriority.MEDIUM;
                    }
                } else {
                    this.localChestConfig.simplePrioritySelection = ChestConfig.SimplePriority.MEDIUM;
                }
            });
        }
    }

    public void method_11007(class_11372 view) {
        super.method_11007(view);
        this.writeProbeData(view);
    }

    public void method_11014(class_11368 view) {
        super.method_11014(view);
        this.readProbeData(view);
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 registryLookup) {
        return this.method_38244(registryLookup);
    }

    public static enum ProbeMode {
        FILTER,
        ACCEPT_ALL,
        PRIORITY;

    }

    public record ProbeData(class_2338 chestPos, @Nullable ChestConfig config) {
        public static final class_9139<class_9129, ProbeData> CODEC = class_9139.method_56438((value, buf) -> {
            buf.method_10807(value.chestPos);
            buf.method_52964(value.config != null);
            if (value.config != null) {
                buf.method_10807(value.config.position);
                buf.method_10814(value.config.customName != null ? value.config.customName : "");
                buf.method_10814(value.config.filterCategory.asString());
                buf.method_10804(value.config.priority);
                buf.method_10814(value.config.filterMode.name());
                buf.method_52964(value.config.strictNBTMatch);
                buf.method_52964(value.config.autoItemFrame);
                if (value.config.simplePrioritySelection != null) {
                    buf.method_52964(true);
                    buf.method_10814(value.config.simplePrioritySelection.name());
                } else {
                    buf.method_52964(false);
                }
            }
        }, buf -> {
            class_2338 chestPos = buf.method_10811();
            boolean hasConfig = buf.readBoolean();
            ChestConfig config = null;
            if (hasConfig) {
                class_2338 configPos = buf.method_10811();
                String customName = buf.method_19772();
                String categoryId = buf.method_19772();
                int priority = buf.method_10816();
                String filterMode = buf.method_19772();
                boolean strictNBT = buf.readBoolean();
                boolean autoFrame = buf.readBoolean();
                config = new ChestConfig(configPos);
                config.customName = customName;
                config.filterCategory = CategoryManager.getInstance().getCategory(categoryId);
                config.priority = priority;
                config.filterMode = ChestConfig.FilterMode.valueOf(filterMode);
                config.strictNBTMatch = strictNBT;
                config.autoItemFrame = autoFrame;
                boolean hasSimplePriority = buf.readBoolean();
                if (hasSimplePriority) {
                    String simplePriorityStr = buf.method_19772();
                    try {
                        config.simplePrioritySelection = ChestConfig.SimplePriority.valueOf(simplePriorityStr);
                    }
                    catch (Exception e) {
                        config.simplePrioritySelection = ChestConfig.SimplePriority.MEDIUM;
                    }
                } else {
                    config.simplePrioritySelection = ChestConfig.SimplePriority.MEDIUM;
                }
            }
            return new ProbeData(chestPos, config);
        });
    }
}

