/*
 * Decompiled with CFR 0.152.
 */
package net.shaddii.smartsorter.blockentity.controller;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_3222;
import net.shaddii.smartsorter.blockentity.OutputProbeBlockEntity;
import net.shaddii.smartsorter.blockentity.controller.ItemRoutingService;
import net.shaddii.smartsorter.blockentity.controller.NetworkInventoryManager;
import net.shaddii.smartsorter.blockentity.controller.ProbeRegistry;

public class ChestSortingService {
    private final ItemRoutingService routingService;
    private final ProbeRegistry probeRegistry;
    private final NetworkInventoryManager networkManager;

    public ChestSortingService(ItemRoutingService routingService, ProbeRegistry probeRegistry, NetworkInventoryManager networkManager) {
        this.routingService = routingService;
        this.probeRegistry = probeRegistry;
        this.networkManager = networkManager;
    }

    public void sortChests(class_1937 world, List<class_2338> chestPositions, class_3222 player) {
        if (world == null || world.method_8608()) {
            return;
        }
        HashMap<ItemVariant, Long> overflowCounts = new HashMap<ItemVariant, Long>();
        HashMap<ItemVariant, String> overflowDestinations = new HashMap<ItemVariant, String>();
        for (class_2338 chestPos : chestPositions) {
            this.sortChest(world, chestPos, overflowCounts, overflowDestinations);
        }
        if (player != null && !overflowCounts.isEmpty()) {
            this.sendOverflowNotification(player, overflowCounts, overflowDestinations);
        }
    }

    public void sortChest(class_1937 world, class_2338 chestPos, Map<ItemVariant, Long> overflowCounts, Map<ItemVariant, String> overflowDestinations) {
        OutputProbeBlockEntity sourceProbe = this.findProbeForChest(world, chestPos);
        if (sourceProbe == null) {
            return;
        }
        class_1263 sourceInv = sourceProbe.getTargetInventory();
        if (sourceInv == null) {
            return;
        }
        List<class_1799> itemsToSort = this.extractAllItems(sourceInv);
        if (itemsToSort.isEmpty()) {
            return;
        }
        ArrayList<class_1799> unsortedItems = new ArrayList<class_1799>();
        for (class_1799 stack : itemsToSort) {
            long overflowed;
            ItemVariant variant = ItemVariant.of((class_1799)stack);
            int originalCount = stack.method_7947();
            ItemRoutingService.InsertionResult result = this.routingService.insertItem(world, stack);
            if (result.overflowed() && (overflowed = (long)(originalCount - result.remainder().method_7947())) > 0L) {
                overflowCounts.merge(variant, overflowed, Long::sum);
                if (result.destinationName() != null) {
                    overflowDestinations.put(variant, result.destinationName());
                }
            }
            if (result.remainder().method_7960()) continue;
            unsortedItems.add(result.remainder());
        }
        for (class_1799 stack : unsortedItems) {
            this.insertIntoInventory(sourceProbe, stack);
        }
    }

    private List<class_1799> extractAllItems(class_1263 inv) {
        ArrayList<class_1799> items = new ArrayList<class_1799>();
        for (int i = 0; i < inv.method_5439(); ++i) {
            class_1799 stack = inv.method_5438(i);
            if (stack.method_7960()) continue;
            items.add(inv.method_5441(i));
        }
        inv.method_5431();
        return items;
    }

    private OutputProbeBlockEntity findProbeForChest(class_1937 world, class_2338 chestPos) {
        for (class_2338 probePos : this.probeRegistry.getLinkedProbes()) {
            OutputProbeBlockEntity probe;
            class_2586 be = world.method_8321(probePos);
            if (!(be instanceof OutputProbeBlockEntity) || !chestPos.equals((Object)(probe = (OutputProbeBlockEntity)be).getTargetPos())) continue;
            return probe;
        }
        return null;
    }

    private void insertIntoInventory(OutputProbeBlockEntity probe, class_1799 stack) {
        class_1263 inv = probe.getTargetInventory();
        if (inv == null) {
            return;
        }
        int maxStackSize = Math.min(stack.method_7914(), inv.method_5444());
        boolean inventoryChanged = false;
        for (int i = 0; i < inv.method_5439() && !stack.method_7960(); ++i) {
            int canAdd;
            class_1799 slotStack = inv.method_5438(i);
            if (slotStack.method_7960()) {
                int toAdd = Math.min(maxStackSize, stack.method_7947());
                inv.method_5447(i, stack.method_46651(toAdd));
                stack.method_7934(toAdd);
                inventoryChanged = true;
                continue;
            }
            if (!class_1799.method_31577((class_1799)slotStack, (class_1799)stack) || (canAdd = maxStackSize - slotStack.method_7947()) <= 0) continue;
            int toAdd = Math.min(canAdd, stack.method_7947());
            slotStack.method_7933(toAdd);
            stack.method_7934(toAdd);
            inventoryChanged = true;
        }
        if (inventoryChanged) {
            inv.method_5431();
        }
    }

    private void sendOverflowNotification(class_3222 player, Map<ItemVariant, Long> overflowCounts, Map<ItemVariant, String> destinations) {
    }
}

