/*
 * Decompiled with CFR 0.152.
 */
package net.shaddii.smartsorter.util;

public enum ChestSortMode {
    PRIORITY("Priority"),
    NAME("Name"),
    FULLNESS("Fullness"),
    COORDINATES("Position");

    private final String displayName;

    private ChestSortMode(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public ChestSortMode next() {
        ChestSortMode[] values = ChestSortMode.values();
        return values[(this.ordinal() + 1) % values.length];
    }

    public static ChestSortMode fromString(String str) {
        for (ChestSortMode mode : ChestSortMode.values()) {
            if (!mode.name().equalsIgnoreCase(str)) continue;
            return mode;
        }
        return PRIORITY;
    }

    public String asString() {
        return this.name();
    }
}

