/*
 * Decompiled with CFR 0.152.
 */
package net.shaddii.smartsorter.blockentity.processor;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2462;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.shaddii.smartsorter.blockentity.StorageControllerBlockEntity;

public class ControllerFinder {
    private static final int[] SEARCH_STAGES = new int[]{8, 16, 32, 64, 128};
    private static final Map<class_2338, CachedResult> cache = new HashMap<class_2338, CachedResult>();
    private static final long CACHE_DURATION = 200L;

    public static class_2338 findController(class_3218 world, class_2338 start) {
        int radius;
        CachedResult cached = cache.get(start);
        if (cached != null && cached.isValid(world.method_8510())) {
            class_2586 be;
            if (cached.controllerPos != null && (be = world.method_8321(cached.controllerPos)) instanceof StorageControllerBlockEntity) {
                return cached.controllerPos;
            }
            return null;
        }
        class_2338 result = null;
        int[] nArray = SEARCH_STAGES;
        int n = nArray.length;
        for (int i = 0; i < n && (result = ControllerFinder.searchRadius(world, start, radius = nArray[i])) == null; ++i) {
        }
        cache.put(start, new CachedResult(result, world.method_8510()));
        if (cache.size() > 100) {
            ControllerFinder.cleanCache(world.method_8510());
        }
        return result;
    }

    private static class_2338 searchRadius(class_3218 world, class_2338 start, int radius) {
        HashSet<class_2338> visited = new HashSet<class_2338>();
        LinkedList<class_2338> queue = new LinkedList<class_2338>();
        queue.add(start);
        for (class_2350 dir : class_2350.values()) {
            queue.add(start.method_10093(dir));
        }
        int blocksChecked = 0;
        int maxBlocks = radius * radius * 4;
        class_2338 closestController = null;
        double closestDistance = Double.MAX_VALUE;
        while (!queue.isEmpty() && blocksChecked < maxBlocks) {
            int manhattanDist;
            class_2338 current = (class_2338)queue.poll();
            if (!visited.add(current) || (manhattanDist = ControllerFinder.getManhattanDistance(current, start)) > radius) continue;
            ++blocksChecked;
            class_2586 be = world.method_8321(current);
            if (be instanceof StorageControllerBlockEntity) {
                double dist = start.method_10262((class_2382)current);
                if (!(dist < closestDistance)) continue;
                closestDistance = dist;
                closestController = current;
                continue;
            }
            class_2680 state = world.method_8320(current);
            if (!ControllerFinder.isRedstoneComponent(state)) continue;
            ControllerFinder.expandSearch(queue, visited, current, state);
        }
        return closestController;
    }

    private static void expandSearch(Queue<class_2338> queue, Set<class_2338> visited, class_2338 current, class_2680 state) {
        block5: {
            block4: {
                if (!state.method_27852(class_2246.field_10450)) break block4;
                class_2350 facing = (class_2350)state.method_11654((class_2769)class_2462.field_11177);
                queue.add(current.method_10093(facing));
                queue.add(current.method_10093(facing.method_10153()));
                for (class_2350 side : class_2350.class_2353.field_11062) {
                    class_2338 sidePos;
                    if (side == facing || side == facing.method_10153() || visited.contains(sidePos = current.method_10093(side))) continue;
                    queue.add(sidePos);
                }
                break block5;
            }
            for (class_2350 dir : class_2350.values()) {
                class_2338 neighbor = current.method_10093(dir);
                if (visited.contains(neighbor)) continue;
                queue.add(neighbor);
            }
            if (!state.method_27852(class_2246.field_10091)) break block5;
            for (class_2350 horizontal : class_2350.class_2353.field_11062) {
                for (class_2350 vertical : new class_2350[]{class_2350.field_11036, class_2350.field_11033}) {
                    class_2338 diagonal = current.method_10093(horizontal).method_10093(vertical);
                    if (visited.contains(diagonal)) continue;
                    queue.add(diagonal);
                }
            }
        }
    }

    private static boolean isRedstoneComponent(class_2680 state) {
        return state.method_27852(class_2246.field_10091) || state.method_27852(class_2246.field_10363) || state.method_27852(class_2246.field_10523) || state.method_27852(class_2246.field_10301) || state.method_27852(class_2246.field_10002) || state.method_27852(class_2246.field_10450) || state.method_27852(class_2246.field_10377) || state.method_26219();
    }

    private static int getManhattanDistance(class_2338 a, class_2338 b) {
        return Math.abs(a.method_10263() - b.method_10263()) + Math.abs(a.method_10264() - b.method_10264()) + Math.abs(a.method_10260() - b.method_10260());
    }

    private static void cleanCache(long currentTime) {
        cache.entrySet().removeIf(entry -> !((CachedResult)entry.getValue()).isValid(currentTime));
    }

    public static void clearCache() {
        cache.clear();
    }

    private static class CachedResult {
        final class_2338 controllerPos;
        final long timestamp;

        CachedResult(class_2338 pos, long time) {
            this.controllerPos = pos;
            this.timestamp = time;
        }

        boolean isValid(long currentTime) {
            return currentTime - this.timestamp < 200L;
        }
    }
}

