/*
 * Decompiled with CFR 0.152.
 */
package net.shaddii.smartsorter.blockentity.processor;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1874;
import net.minecraft.class_2609;
import net.minecraft.class_3218;
import net.minecraft.class_3720;
import net.minecraft.class_3723;
import net.minecraft.class_3866;
import net.minecraft.class_3956;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_9696;

public class ExperienceCollector {
    private static final int XP_CACHE_MAX = 200;
    private final Map<ItemVariant, Float> experienceCache = new HashMap<ItemVariant, Float>();

    public int collectFurnaceExperience(class_3218 world, class_2609 furnace, class_1799 outputStack) {
        class_3956<?> recipeType = this.getRecipeType(furnace);
        if (recipeType == null) {
            return 0;
        }
        ItemVariant outputVariant = ItemVariant.of((class_1799)outputStack);
        Float experiencePerItem = this.experienceCache.get(outputVariant);
        if (experiencePerItem == null) {
            experiencePerItem = Float.valueOf(this.calculateExperience(world, outputStack, recipeType));
            this.experienceCache.put(outputVariant, experiencePerItem);
            if (this.experienceCache.size() > 200) {
                this.trimCache();
            }
        }
        return Math.round(experiencePerItem.floatValue() * (float)outputStack.method_7947());
    }

    private float calculateExperience(class_3218 world, class_1799 output, class_3956<?> recipeType) {
        try {
            Collection allRecipes = world.method_64577().method_8126();
            for (class_8786 recipeEntry : allRecipes) {
                class_1874 cookingRecipe;
                class_1799 recipeOutput;
                class_1860 recipe = recipeEntry.comp_1933();
                if (recipe.method_17716() != recipeType || !(recipe instanceof class_1874) || !class_1799.method_7984((class_1799)(recipeOutput = (cookingRecipe = (class_1874)recipe).method_59998(new class_9696(class_1799.field_8037), (class_7225.class_7874)world.method_30349())), (class_1799)output)) continue;
                return cookingRecipe.method_8171();
            }
        }
        catch (Exception e) {
            return 0.1f;
        }
        return 0.1f;
    }

    private class_3956<?> getRecipeType(class_2609 furnace) {
        if (furnace instanceof class_3866) {
            return class_3956.field_17546;
        }
        if (furnace instanceof class_3720) {
            return class_3956.field_17547;
        }
        if (furnace instanceof class_3723) {
            return class_3956.field_17548;
        }
        return null;
    }

    private void trimCache() {
        Iterator<Map.Entry<ItemVariant, Float>> it = this.experienceCache.entrySet().iterator();
        for (int toRemove = this.experienceCache.size() / 2; it.hasNext() && toRemove > 0; --toRemove) {
            it.next();
            it.remove();
        }
    }

    public void clearCache() {
        this.experienceCache.clear();
    }
}

