/*
 * Decompiled with CFR 0.152.
 */
package net.shaddii.smartsorter.screen.tabs;

import java.util.ArrayList;
import java.util.Map;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_2338;
import net.minecraft.class_332;
import net.minecraft.class_8710;
import net.shaddii.smartsorter.network.CollectXpPayload;
import net.shaddii.smartsorter.screen.StorageControllerScreen;
import net.shaddii.smartsorter.screen.StorageControllerScreenHandler;
import net.shaddii.smartsorter.screen.tabs.TabComponent;
import net.shaddii.smartsorter.util.ProcessProbeConfig;
import net.shaddii.smartsorter.widget.ProbeConfigPanel;
import net.shaddii.smartsorter.widget.ProbeSelectorWidget;

public class AutoProcessingTabComponent
extends TabComponent {
    private ProbeSelectorWidget probeSelector;
    private ProbeConfigPanel configPanel;
    private class_2338 lastSelectedProbePos = null;
    private int lastCollectedXp = 0;
    private long lastCollectionTime = 0L;

    public AutoProcessingTabComponent(StorageControllerScreen parent, StorageControllerScreenHandler handler) {
        super(parent, handler);
    }

    @Override
    protected void initWidgets() {
        this.probeSelector = new ProbeSelectorWidget(this.guiX + 8, this.guiY + 18, this.backgroundWidth - 16, 10, this.parent.method_64506());
        Map<class_2338, ProcessProbeConfig> configs = this.handler.getProcessProbeConfigs();
        this.probeSelector.updateProbes(configs);
        if (this.lastSelectedProbePos != null && configs.containsKey(this.lastSelectedProbePos)) {
            this.restoreSelection(configs);
        }
        this.probeSelector.setOnSelectionChange(config -> {
            if (this.configPanel != null) {
                this.configPanel.setConfig((ProcessProbeConfig)config);
                this.lastSelectedProbePos = config != null ? config.position : null;
            }
        });
        this.probeSelector.setOnConfigUpdate(config -> this.markDirty());
        this.configPanel = new ProbeConfigPanel(this.guiX + 8, this.guiY + 30, this.backgroundWidth - 16, 75, this.parent.method_64506());
        ProcessProbeConfig selected = this.probeSelector.getSelectedProbe();
        this.configPanel.setConfig(selected);
        if (selected != null) {
            this.lastSelectedProbePos = selected.position;
        }
        this.configPanel.setOnConfigUpdate(config -> this.markDirty());
    }

    @Override
    public void render(class_332 context, int mouseX, int mouseY, float delta) {
        context.method_51433(this.parent.method_64506(), "Process Config", this.guiX + 8, this.guiY + 6, -12566464, false);
        this.renderXpDisplay(context, mouseX, mouseY);
        if (this.probeSelector != null) {
            this.probeSelector.render(context, mouseX, mouseY, delta);
        }
        if (this.configPanel != null) {
            this.configPanel.render(context, mouseX, mouseY, delta);
        }
        this.renderFloatingText(context);
        if (this.probeSelector != null) {
            this.probeSelector.renderDropdownIfOpen(context, mouseX, mouseY);
        }
    }

    private void renderXpDisplay(class_332 context, int mouseX, int mouseY) {
        boolean justClicked;
        int xp = this.handler.getStoredExperience();
        long timeSinceCollection = System.currentTimeMillis() - this.lastCollectionTime;
        float textScale = 0.7f;
        String xpText = "XP: " + xp;
        int xpTextWidth = (int)((float)this.parent.method_64506().method_1727(xpText) * textScale);
        int xpX = this.guiX + this.backgroundWidth - 85;
        int xpY = this.guiY + 6;
        context.method_25294(xpX - 2, xpY - 1, xpX + xpTextWidth + 32, xpY + 10, -1442840576);
        context.method_25294(xpX - 3, xpY - 2, xpX + xpTextWidth + 33, xpY - 1, -1);
        context.method_25294(xpX - 3, xpY + 10, xpX + xpTextWidth + 33, xpY + 11, -7829368);
        this.parent.drawScaledText(context, xpText, xpX, xpY + 1, textScale, -256);
        int btnX = xpX + xpTextWidth + 3;
        int btnY = xpY;
        int btnWidth = 28;
        int btnHeight = 9;
        boolean hovered = mouseX >= btnX && mouseX < btnX + btnWidth && mouseY >= btnY && mouseY < btnY + btnHeight;
        boolean bl = justClicked = timeSinceCollection < 200L;
        int btnBg = xp > 0 ? (justClicked ? -171 : (hovered ? -11141291 : -16733696)) : -12303292;
        int textColor = xp > 0 ? -1 : -7829368;
        context.method_25294(btnX, btnY, btnX + btnWidth, btnY + btnHeight, btnBg);
        context.method_25294(btnX, btnY, btnX + btnWidth, btnY + 1, -1);
        context.method_25294(btnX, btnY + btnHeight - 1, btnX + btnWidth, btnY + btnHeight, -7829368);
        context.method_25294(btnX, btnY, btnX + 1, btnY + btnHeight, -1);
        context.method_25294(btnX + btnWidth - 1, btnY, btnX + btnWidth, btnY + btnHeight, -7829368);
        float btnTextScale = 0.65f;
        this.parent.drawScaledText(context, "Collect", btnX + 3, btnY + 2, btnTextScale, textColor);
    }

    private void renderFloatingText(class_332 context) {
        long timeSinceCollection = System.currentTimeMillis() - this.lastCollectionTime;
        if (timeSinceCollection < 2000L && this.lastCollectedXp > 0) {
            float alpha = 1.0f - (float)timeSinceCollection / 2000.0f;
            int yOffset = (int)(timeSinceCollection / 20L);
            String collectedText = "+" + this.lastCollectedXp + " XP!";
            float scale = 0.7f;
            int scaledWidth = (int)((float)this.parent.method_64506().method_1727(collectedText) * scale);
            int collectedX = this.guiX + this.backgroundWidth / 2 - scaledWidth / 2;
            int collectedY = this.guiY + 50 - yOffset;
            int color = (int)(alpha * 255.0f) << 24 | 0x55FF55;
            this.parent.drawScaledText(context, collectedText, collectedX, collectedY, scale, color);
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0) {
            float textScale = 0.7f;
            String xpText = "XP: " + this.handler.getStoredExperience();
            int xpTextWidth = (int)((float)this.parent.method_64506().method_1727(xpText) * textScale);
            int xpX = this.guiX + this.backgroundWidth - 85;
            int btnX = xpX + xpTextWidth + 3;
            int btnY = this.guiY + 6;
            int btnWidth = 28;
            int btnHeight = 9;
            if (mouseX >= (double)btnX && mouseX <= (double)(btnX + btnWidth) && mouseY >= (double)btnY && mouseY <= (double)(btnY + btnHeight)) {
                this.collectXp();
                return true;
            }
        }
        if (this.probeSelector != null && this.probeSelector.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        return this.configPanel != null && this.configPanel.mouseClicked(mouseX, mouseY, button);
    }

    private void restoreSelection(Map<class_2338, ProcessProbeConfig> configs) {
        ArrayList<ProcessProbeConfig> configList = new ArrayList<ProcessProbeConfig>(configs.values());
        configList.sort((a, b) -> {
            if (a.position.method_10263() != b.position.method_10263()) {
                return Integer.compare(a.position.method_10263(), b.position.method_10263());
            }
            if (a.position.method_10264() != b.position.method_10264()) {
                return Integer.compare(a.position.method_10264(), b.position.method_10264());
            }
            return Integer.compare(a.position.method_10260(), b.position.method_10260());
        });
        for (int i = 0; i < configList.size(); ++i) {
            if (!((ProcessProbeConfig)configList.get((int)i)).position.equals((Object)this.lastSelectedProbePos)) continue;
            this.probeSelector.setSelectedIndex(i);
            break;
        }
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        return false;
    }

    @Override
    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        return false;
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (this.probeSelector != null) {
            if (this.probeSelector.isDropdownOpen()) {
                return this.probeSelector.mouseScrolled(mouseX, mouseY, horizontalAmount, verticalAmount);
            }
            if (this.probeSelector.mouseScrolled(mouseX, mouseY, horizontalAmount, verticalAmount)) {
                return true;
            }
        }
        return this.configPanel != null && this.configPanel.mouseScrolled(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        return this.probeSelector != null && this.probeSelector.keyPressed(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean charTyped(char chr, int modifiers) {
        return this.probeSelector != null && this.probeSelector.charTyped(chr, modifiers);
    }

    @Override
    public void markDirty() {
    }

    private void collectXp() {
        int xp = this.handler.getStoredExperience();
        if (xp > 0) {
            this.lastCollectedXp = xp;
            this.lastCollectionTime = System.currentTimeMillis();
            ClientPlayNetworking.send((class_8710)new CollectXpPayload());
        }
    }

    public void updateProbeStats(class_2338 position, int itemsProcessed) {
        Map<class_2338, ProcessProbeConfig> configs = this.handler.getProcessProbeConfigs();
        ProcessProbeConfig config = configs.get(position);
        if (config != null) {
            ProcessProbeConfig selected;
            config.itemsProcessed = itemsProcessed;
            if (this.probeSelector != null && this.configPanel != null && (selected = this.probeSelector.getSelectedProbe()) != null && selected.position.equals((Object)position)) {
                selected.itemsProcessed = itemsProcessed;
                this.configPanel.setConfig(selected);
            }
            if (this.probeSelector != null) {
                this.probeSelector.updateProbes(this.handler.getProcessProbeConfigs());
            }
            this.markDirty();
        }
    }
}

