/*
 * Decompiled with CFR 0.152.
 */
package net.shaddii.smartsorter.util;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_9129;
import net.shaddii.smartsorter.util.Category;
import net.shaddii.smartsorter.util.CategoryManager;
import net.shaddii.smartsorter.util.ChestSortMode;

public class ChestConfig {
    public final class_2338 position;
    public String customName;
    public Category filterCategory;
    public int priority = 1;
    public FilterMode filterMode;
    public boolean autoItemFrame;
    public boolean strictNBTMatch = false;
    public SimplePriority simplePrioritySelection = SimplePriority.MEDIUM;
    public int hiddenPriority;
    public int cachedFullness = -1;
    public transient List<class_1799> previewItems = new ArrayList<class_1799>();

    public static void write(class_9129 buf, ChestConfig config) {
        buf.method_10807(config.position);
        buf.method_10814(config.customName);
        buf.method_10814(config.filterCategory.asString());
        buf.method_53002(config.priority);
        buf.method_10817((Enum)config.filterMode);
        buf.method_52964(config.autoItemFrame);
        buf.method_52964(config.strictNBTMatch);
        buf.method_53002(config.cachedFullness);
        if (config.simplePrioritySelection != null) {
            buf.method_52964(true);
            buf.method_10817((Enum)config.simplePrioritySelection);
        } else {
            buf.method_52964(false);
        }
        buf.method_10804(config.previewItems.size());
        for (class_1799 stack : config.previewItems) {
            class_1799.field_48349.encode((Object)buf, (Object)stack);
        }
    }

    public static ChestConfig read(class_9129 buf) {
        class_2338 pos = buf.method_10811();
        String name = buf.method_19772();
        Category category = CategoryManager.getInstance().getCategory(buf.method_19772());
        int priority = buf.readInt();
        FilterMode mode = (FilterMode)buf.method_10818(FilterMode.class);
        boolean autoFrame = buf.readBoolean();
        boolean strictNBT = buf.readBoolean();
        ChestConfig config = new ChestConfig(pos, name, category, priority, mode, autoFrame);
        config.strictNBTMatch = strictNBT;
        config.cachedFullness = buf.readInt();
        boolean hasSimplePriority = buf.readBoolean();
        config.simplePrioritySelection = hasSimplePriority ? (SimplePriority)buf.method_10818(SimplePriority.class) : SimplePriority.MEDIUM;
        int itemCount = buf.method_10816();
        config.previewItems = new ArrayList<class_1799>();
        for (int i = 0; i < itemCount; ++i) {
            config.previewItems.add((class_1799)class_1799.field_48349.decode((Object)buf));
        }
        return config;
    }

    public ChestConfig(class_2338 position) {
        this.position = position;
        this.customName = "";
        this.filterCategory = Category.ALL;
        this.priority = 1;
        this.filterMode = FilterMode.NONE;
        this.autoItemFrame = false;
        this.hiddenPriority = 0;
        this.simplePrioritySelection = SimplePriority.MEDIUM;
    }

    public ChestConfig(class_2338 position, String customName, Category filterCategory, int priority, FilterMode filterMode, boolean autoItemFrame) {
        this.position = position;
        this.customName = customName;
        this.filterCategory = filterCategory;
        this.priority = priority;
        this.filterMode = filterMode;
        this.autoItemFrame = autoItemFrame;
        this.hiddenPriority = this.calculateHiddenPriority();
        this.simplePrioritySelection = filterMode == FilterMode.OVERFLOW ? SimplePriority.LOWEST : SimplePriority.MEDIUM;
    }

    private int calculateHiddenPriority() {
        int baseValue = this.filterMode.getBasePriority();
        return baseValue - this.priority;
    }

    public void updateHiddenPriority() {
        switch (this.filterMode.ordinal()) {
            case 3: {
                this.hiddenPriority = 10000 + this.priority * 100;
                break;
            }
            case 6: {
                this.hiddenPriority = 5000;
                break;
            }
            case 2: {
                this.hiddenPriority = this.priority * 1000;
                break;
            }
            case 1: {
                this.hiddenPriority = this.priority * 100;
                break;
            }
            case 5: {
                this.hiddenPriority = 50;
                break;
            }
            case 0: {
                this.hiddenPriority = -500;
                break;
            }
            case 4: {
                this.hiddenPriority = -1000;
            }
        }
    }

    public class_2487 toNbt() {
        class_2487 nbt = new class_2487();
        nbt.method_10544("pos", this.position.method_10063());
        nbt.method_10582("name", this.customName);
        nbt.method_10582("category", this.filterCategory.asString());
        nbt.method_10569("priority", this.priority);
        nbt.method_10582("filterMode", this.filterMode.name());
        nbt.method_10556("autoItemFrame", this.autoItemFrame);
        nbt.method_10556("strictNBT", this.strictNBTMatch);
        nbt.method_10569("cachedFullness", this.cachedFullness);
        nbt.method_10582("simplePrioritySelection", this.simplePrioritySelection.name());
        if (this.simplePrioritySelection != null) {
            nbt.method_10582("simplePrioritySelection", this.simplePrioritySelection.name());
        }
        return nbt;
    }

    public static ChestConfig fromNbt(class_2487 nbt) {
        int priority;
        class_2338 pos = class_2338.method_10092((long)nbt.method_10537("pos").orElse(0L));
        String name = nbt.method_68564("name", "");
        Category category = CategoryManager.getInstance().getCategory(nbt.method_68564("category", "smartsorter:all"));
        if (nbt.method_10545("priorityLevel")) {
            String oldPriority;
            priority = switch (oldPriority = nbt.method_68564("priorityLevel", "MEDIUM")) {
                case "HIGH" -> 1;
                case "LOW" -> 3;
                default -> 2;
            };
        } else {
            priority = nbt.method_68083("priority", 1);
        }
        FilterMode mode = FilterMode.valueOf(nbt.method_68564("filterMode", "NONE"));
        boolean autoFrame = nbt.method_68566("autoItemFrame", false);
        boolean strictNBT = nbt.method_68566("strictNBT", false);
        int cachedFull = nbt.method_68083("cachedFullness", -1);
        ChestConfig config = new ChestConfig(pos, name, category, priority, mode, autoFrame);
        config.strictNBTMatch = strictNBT;
        config.cachedFullness = cachedFull;
        if (nbt.method_10545("simplePrioritySelection")) {
            nbt.method_10558("simplePrioritySelection").ifPresent(str -> {
                try {
                    config.simplePrioritySelection = SimplePriority.valueOf(str);
                }
                catch (Exception e) {
                    config.simplePrioritySelection = SimplePriority.MEDIUM;
                }
            });
        }
        return config;
    }

    public ChestConfig copy() {
        ChestConfig copied = new ChestConfig(this.position, this.customName, this.filterCategory, this.priority, this.filterMode, this.autoItemFrame);
        copied.strictNBTMatch = this.strictNBTMatch;
        copied.hiddenPriority = this.hiddenPriority;
        copied.simplePrioritySelection = this.simplePrioritySelection;
        return copied;
    }

    public String getDisplayName() {
        if (!this.customName.isEmpty()) {
            return this.customName;
        }
        return String.format("Chest [%d, %d, %d]", this.position.method_10263(), this.position.method_10264(), this.position.method_10260());
    }

    public String getSortKey(ChestSortMode mode) {
        return switch (mode) {
            default -> throw new MatchException(null, null);
            case ChestSortMode.PRIORITY -> {
                String namePart = this.customName.isEmpty() ? this.position.method_23854() : this.customName;
                int sortPriority = this.filterMode == FilterMode.CUSTOM ? 0 : this.priority;
                yield String.format("%03d_%s", sortPriority, namePart);
            }
            case ChestSortMode.NAME -> {
                if (this.customName.isEmpty()) {
                    yield "zzz_" + this.position.method_23854();
                }
                yield this.customName.toLowerCase();
            }
            case ChestSortMode.FULLNESS -> {
                String namePart = this.customName.isEmpty() ? this.position.method_23854() : this.customName;
                yield String.format("%03d_%s", 100 - this.cachedFullness, namePart);
            }
            case ChestSortMode.COORDINATES -> this.position.method_23854();
        };
    }

    public static enum FilterMode {
        NONE("General Storage", "Accepts any items"),
        CATEGORY("Dedicated", "Only accepts items in selected category"),
        PRIORITY("Priority Storage", "Accepts any items (fills earlier)"),
        CATEGORY_AND_PRIORITY("Filtered Priority", "Category filter + high priority"),
        OVERFLOW("Overflow Storage", "Only category items (fills last)"),
        BLACKLIST("Blacklist", "Everything EXCEPT selected category"),
        CUSTOM("Custom", "Only items matching chest contents");

        private final String displayName;
        private final String description;

        private FilterMode(String displayName, String description) {
            this.displayName = displayName;
            this.description = description;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getDescription() {
            return this.description;
        }

        public FilterMode next() {
            FilterMode[] modes = FilterMode.values();
            return modes[(this.ordinal() + 1) % modes.length];
        }

        public int getBasePriority() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 3 -> 1000;
                case 6 -> 800;
                case 2 -> 500;
                case 1 -> 300;
                case 5 -> 100;
                case 4 -> -500;
                case 0 -> 0;
            };
        }

        public boolean needsCategoryFilter() {
            return this == CATEGORY || this == CATEGORY_AND_PRIORITY || this == OVERFLOW || this == BLACKLIST;
        }

        public boolean isBlacklistMode() {
            return this == BLACKLIST;
        }
    }

    public static enum SimplePriority {
        HIGHEST("Highest", "\u00a7a", "Gets items first"),
        HIGH("High", "\u00a72", "High priority"),
        MEDIUM("Medium", "\u00a7e", "Normal priority"),
        LOW("Low", "\u00a76", "Low priority"),
        LOWEST("Lowest", "\u00a7c", "Gets items last");

        private final String displayName;
        private final String colorCode;
        private final String description;

        private SimplePriority(String displayName, String colorCode, String description) {
            this.displayName = displayName;
            this.colorCode = colorCode;
            this.description = description;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getColorCode() {
            return this.colorCode;
        }

        public String getDescription() {
            return this.description;
        }

        public int getNumericValue(int maxPriority) {
            int effectiveMax = Math.max(5, maxPriority);
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> 1;
                case 1 -> Math.max(2, effectiveMax / 5);
                case 2 -> Math.max(3, effectiveMax / 2);
                case 3 -> Math.max(4, effectiveMax * 4 / 5);
                case 4 -> Math.max(5, effectiveMax);
            };
        }

        public static SimplePriority fromNumeric(int priority, int maxPriority) {
            if (maxPriority <= 0) {
                return MEDIUM;
            }
            if (priority <= 0) {
                return HIGHEST;
            }
            if (priority > maxPriority) {
                return LOWEST;
            }
            double percentage = (double)priority / (double)maxPriority;
            if (percentage <= 0.2) {
                return HIGHEST;
            }
            if (percentage <= 0.4) {
                return HIGH;
            }
            if (percentage <= 0.6) {
                return MEDIUM;
            }
            if (percentage <= 0.8) {
                return LOW;
            }
            return LOWEST;
        }
    }
}

