/*
 * Decompiled with CFR 0.152.
 */
package net.shaddii.smartsorter.util;

import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_7923;

public enum FuelFilterMode {
    ANY_FUEL("Any Fuel"),
    COAL_ONLY("Coal/Charcoal"),
    BLOCKS_ONLY("Fuel Blocks"),
    NO_WOOD("No Wood"),
    LAVA_ONLY("Lava Buckets"),
    CUSTOM("Custom");

    private final String displayName;

    private FuelFilterMode(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean allows(class_1799 fuel) {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> true;
            case 1 -> this.isCoal(fuel);
            case 2 -> this.isFuelBlock(fuel);
            case 3 -> {
                if (!this.isWood(fuel)) {
                    yield true;
                }
                yield false;
            }
            case 4 -> fuel.method_31574(class_1802.field_8187);
            case 5 -> false;
        };
    }

    private boolean isCoal(class_1799 stack) {
        class_1792 item = stack.method_7909();
        return item == class_1802.field_8713 || item == class_1802.field_8665;
    }

    private boolean isFuelBlock(class_1799 stack) {
        class_1792 item = stack.method_7909();
        return item == class_1802.field_8797 || item == class_1802.field_17533 || item == class_1802.field_8894;
    }

    private boolean isWood(class_1799 stack) {
        String id = class_7923.field_41178.method_10221((Object)stack.method_7909()).method_12832();
        return id.contains("log") || id.contains("wood") || id.contains("plank");
    }

    public String asString() {
        return this.name();
    }

    public static FuelFilterMode fromString(String name) {
        try {
            return FuelFilterMode.valueOf(name);
        }
        catch (IllegalArgumentException e) {
            return COAL_ONLY;
        }
    }
}

