/*
 * Decompiled with CFR 0.152.
 */
package net.shaddii.smartsorter.util;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class InventoryOrganizer {
    public static void organize(class_1263 inventory, Strategy strategy) {
        if (inventory == null || inventory.method_5442()) {
            return;
        }
        switch (strategy.ordinal()) {
            case 0: {
                InventoryOrganizer.inPlaceGroup(inventory);
                break;
            }
            case 1: {
                InventoryOrganizer.smartCompact(inventory);
                break;
            }
            case 2: {
                InventoryOrganizer.fullOrganize(inventory);
                break;
            }
            case 3: {
                InventoryOrganizer.organizeAdaptive(inventory);
            }
        }
    }

    public static void organize(class_1263 inventory) {
        InventoryOrganizer.organize(inventory, Strategy.IN_PLACE_GROUP);
    }

    public static boolean isOrganized(class_1263 inventory) {
        if (inventory == null) {
            return true;
        }
        boolean foundEmpty = false;
        class_2960 lastItemId = null;
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 stack = inventory.method_5438(i);
            if (stack.method_7960()) {
                foundEmpty = true;
                continue;
            }
            if (foundEmpty) {
                return false;
            }
            class_2960 itemId = class_7923.field_41178.method_10221((Object)stack.method_7909());
            if (lastItemId != null && !lastItemId.equals((Object)itemId)) {
                for (int j = 0; j < i; ++j) {
                    class_1799 prevStack = inventory.method_5438(j);
                    if (prevStack.method_7960() || !class_7923.field_41178.method_10221((Object)prevStack.method_7909()).equals((Object)itemId)) continue;
                    return false;
                }
            }
            lastItemId = itemId;
        }
        return true;
    }

    private static void inPlaceGroup(class_1263 inventory) {
        int size = inventory.method_5439();
        int writePos = 0;
        HashSet<class_2960> processedTypes = new HashSet<class_2960>();
        for (int readPos = 0; readPos < size; ++readPos) {
            class_2960 itemId;
            class_1799 stack = inventory.method_5438(readPos);
            if (stack.method_7960() || processedTypes.contains(itemId = class_7923.field_41178.method_10221((Object)stack.method_7909()))) continue;
            processedTypes.add(itemId);
            ArrayList<Integer> slotsWithThisItem = new ArrayList<Integer>();
            for (int i = readPos; i < size; ++i) {
                class_1799 s = inventory.method_5438(i);
                if (s.method_7960() || !class_7923.field_41178.method_10221((Object)s.method_7909()).equals((Object)itemId)) continue;
                slotsWithThisItem.add(i);
            }
            List<class_1799> consolidated = InventoryOrganizer.consolidateStacks(inventory, slotsWithThisItem);
            for (class_1799 consolidatedStack : consolidated) {
                if (writePos >= size) continue;
                inventory.method_5447(writePos, consolidatedStack);
                ++writePos;
            }
        }
        for (int i = writePos; i < size; ++i) {
            inventory.method_5447(i, class_1799.field_8037);
        }
        inventory.method_5431();
    }

    private static List<class_1799> consolidateStacks(class_1263 inventory, List<Integer> slots) {
        ArrayList<class_1799> result = new ArrayList<class_1799>();
        int totalCount = 0;
        class_1799 template = null;
        for (int slot : slots) {
            class_1799 stack = inventory.method_5438(slot);
            if (stack.method_7960()) continue;
            if (template == null) {
                template = stack.method_7972();
                template.method_7939(1);
            }
            totalCount += stack.method_7947();
            inventory.method_5447(slot, class_1799.field_8037);
        }
        if (template == null || totalCount == 0) {
            return result;
        }
        int maxStack = template.method_7914();
        while (totalCount > 0) {
            int stackSize = Math.min(totalCount, maxStack);
            class_1799 newStack = template.method_7972();
            newStack.method_7939(stackSize);
            result.add(newStack);
            totalCount -= stackSize;
        }
        return result;
    }

    private static void smartCompact(class_1263 inventory) {
        if (InventoryOrganizer.isOrganized(inventory)) {
            return;
        }
        int size = inventory.method_5439();
        LinkedHashMap<class_2960, List> itemGroups = new LinkedHashMap<class_2960, List>();
        for (int i = 0; i < size; ++i) {
            class_1799 stack = inventory.method_5438(i);
            if (stack.method_7960()) continue;
            class_2960 itemId = class_7923.field_41178.method_10221((Object)stack.method_7909());
            itemGroups.computeIfAbsent(itemId, k -> new ArrayList()).add(stack.method_7972());
            inventory.method_5447(i, class_1799.field_8037);
        }
        int writePos = 0;
        for (Map.Entry entry : itemGroups.entrySet()) {
            int stackSize;
            List stacks = (List)entry.getValue();
            class_1799 template = (class_1799)stacks.get(0);
            int maxStack = template.method_7914();
            for (int totalCount = stacks.stream().mapToInt(class_1799::method_7947).sum(); totalCount > 0 && writePos < size; totalCount -= stackSize) {
                stackSize = Math.min(totalCount, maxStack);
                class_1799 newStack = template.method_7972();
                newStack.method_7939(stackSize);
                inventory.method_5447(writePos++, newStack);
            }
        }
        inventory.method_5431();
    }

    private static void fullOrganize(class_1263 inventory) {
        int size = inventory.method_5439();
        ArrayList<class_1799> allItems = new ArrayList<class_1799>();
        for (int i = 0; i < size; ++i) {
            class_1799 stack2 = inventory.method_5438(i);
            if (stack2.method_7960()) continue;
            allItems.add(stack2.method_7972());
            inventory.method_5447(i, class_1799.field_8037);
        }
        if (allItems.isEmpty()) {
            return;
        }
        allItems.sort(Comparator.comparing(stack -> class_7923.field_41178.method_10221((Object)stack.method_7909()).toString()).thenComparing(stack -> stack.method_57353().toString()).thenComparingInt(class_1799::method_7947).reversed());
        ArrayList<class_1799> consolidated = new ArrayList<class_1799>();
        class_1799 current = null;
        for (class_1799 stack3 : allItems) {
            if (current == null) {
                current = stack3.method_7972();
                continue;
            }
            if (class_1799.method_31577((class_1799)current, (class_1799)stack3)) {
                int space = current.method_7914() - current.method_7947();
                if (space > 0) {
                    int toAdd = Math.min(space, stack3.method_7947());
                    current.method_7933(toAdd);
                    stack3.method_7934(toAdd);
                }
                if (stack3.method_7960()) continue;
                consolidated.add(current);
                current = stack3.method_7972();
                continue;
            }
            consolidated.add(current);
            current = stack3.method_7972();
        }
        if (current != null) {
            consolidated.add(current);
        }
        for (int i = 0; i < Math.min(consolidated.size(), size); ++i) {
            inventory.method_5447(i, (class_1799)consolidated.get(i));
        }
        inventory.method_5431();
    }

    private static void organizeAdaptive(class_1263 inventory) {
        if (InventoryOrganizer.isOrganized(inventory)) {
            return;
        }
        int messiness = InventoryOrganizer.calculateMessiness(inventory);
        if (messiness < 30) {
            InventoryOrganizer.inPlaceGroup(inventory);
        } else if (messiness < 60) {
            InventoryOrganizer.smartCompact(inventory);
        } else {
            InventoryOrganizer.fullOrganize(inventory);
        }
    }

    public static int getDistinctItemCount(class_1263 inventory) {
        if (inventory == null) {
            return 0;
        }
        HashSet<class_2960> types = new HashSet<class_2960>();
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 stack = inventory.method_5438(i);
            if (stack.method_7960()) continue;
            types.add(class_7923.field_41178.method_10221((Object)stack.method_7909()));
        }
        return types.size();
    }

    public static int calculateMessiness(class_1263 inventory) {
        if (inventory == null || inventory.method_5442()) {
            return 0;
        }
        int totalItems = 0;
        int gaps = 0;
        int scatteredGroups = 0;
        HashSet<class_2960> seenTypes = new HashSet<class_2960>();
        class_2960 lastType = null;
        boolean foundGap = false;
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 stack = inventory.method_5438(i);
            if (stack.method_7960()) {
                foundGap = true;
                continue;
            }
            ++totalItems;
            class_2960 type = class_7923.field_41178.method_10221((Object)stack.method_7909());
            if (foundGap) {
                ++gaps;
            }
            if (seenTypes.contains(type) && !type.equals(lastType)) {
                ++scatteredGroups;
            }
            seenTypes.add(type);
            lastType = type;
        }
        if (totalItems == 0) {
            return 0;
        }
        return Math.min(100, (gaps + scatteredGroups * 2) * 100 / totalItems);
    }

    public static enum Strategy {
        IN_PLACE_GROUP,
        SMART_COMPACT,
        FULL_ORGANIZE,
        ADAPTIVE;

    }
}

