/*
 * Decompiled with CFR 0.152.
 */
package net.shaddii.smartsorter.blockentity;

import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_7225;
import net.shaddii.smartsorter.SmartSorter;
import net.shaddii.smartsorter.StorageLogic;
import net.shaddii.smartsorter.blockentity.OutputProbeBlockEntity;

public class IntakeBlockEntity
extends class_2586 {
    private final List<class_2338> outputs = new ArrayList<class_2338>();
    private class_1799 buffer = class_1799.field_8037;
    private int cooldown = 0;

    public IntakeBlockEntity(class_2338 pos, class_2680 state) {
        super(SmartSorter.INTAKE_BE_TYPE, pos, state);
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, IntakeBlockEntity be) {
        if (world.method_8608()) {
            return;
        }
        if (world.method_8510() % 100L == 0L) {
            be.validateOutputs(world);
        }
        if (be.cooldown > 0) {
            --be.cooldown;
            return;
        }
        StorageLogic.pullFromFacingIntoBuffer(be);
        boolean moved = StorageLogic.routeBuffer(world, be);
        be.cooldown = moved ? 2 : 10;
        be.method_5431();
    }

    private void validateOutputs(class_1937 world) {
        this.outputs.removeIf(outputPos -> {
            class_2586 be = world.method_8321(outputPos);
            return !(be instanceof OutputProbeBlockEntity);
        });
    }

    public boolean addOutput(class_2338 probePos) {
        if (!this.outputs.contains(probePos)) {
            this.outputs.add(probePos);
            this.method_5431();
            return true;
        }
        return false;
    }

    public List<class_2338> getOutputs() {
        return this.outputs;
    }

    public class_1799 getBuffer() {
        return this.buffer;
    }

    public boolean removeOutput(class_2338 probePos) {
        boolean removed = this.outputs.remove(probePos);
        if (removed) {
            this.method_5431();
        }
        return removed;
    }

    public void setBuffer(class_1799 stack) {
        this.buffer = stack;
        this.method_5431();
    }

    protected void writeNbt(class_2487 nbt, class_7225.class_7874 lookup) {
        nbt.method_10569("out_count", this.outputs.size());
        for (int i = 0; i < this.outputs.size(); ++i) {
            nbt.method_10544("o" + i, this.outputs.get(i).method_10063());
        }
        if (!this.buffer.method_7960()) {
            class_2520 encoded = (class_2520)class_1799.field_49266.encodeStart((DynamicOps)lookup.method_57093((DynamicOps)class_2509.field_11560), (Object)this.buffer).getOrThrow();
            nbt.method_10566("buffer", encoded);
        }
    }

    protected void readNbt(class_2487 nbt, class_7225.class_7874 lookup) {
        this.outputs.clear();
        int c = nbt.method_10550("out_count").orElse(0);
        for (int i = 0; i < c; ++i) {
            nbt.method_10537("o" + i).ifPresent(pos -> this.outputs.add(class_2338.method_10092((long)pos)));
        }
        this.buffer = nbt.method_10545("buffer") ? class_1799.field_49266.parse((DynamicOps)lookup.method_57093((DynamicOps)class_2509.field_11560), (Object)nbt.method_10580("buffer")).result().orElse(class_1799.field_8037) : class_1799.field_8037;
    }
}

