/*
 * Decompiled with CFR 0.152.
 */
package net.shaddii.smartsorter.blockentity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_7225;
import net.minecraft.class_8710;
import net.shaddii.smartsorter.SmartSorter;
import net.shaddii.smartsorter.blockentity.OutputProbeBlockEntity;
import net.shaddii.smartsorter.blockentity.ProcessProbeBlockEntity;
import net.shaddii.smartsorter.network.ProbeStatsSyncPayload;
import net.shaddii.smartsorter.screen.StorageControllerScreenHandler;
import net.shaddii.smartsorter.util.FuelFilterMode;
import net.shaddii.smartsorter.util.ProcessProbeConfig;
import net.shaddii.smartsorter.util.RecipeFilterMode;
import org.jetbrains.annotations.Nullable;

public class StorageControllerBlockEntity
extends class_2586
implements class_3908,
class_1263 {
    private final List<class_2338> linkedProbes = new ArrayList<class_2338>();
    private final Map<ItemVariant, Long> networkItems = new LinkedHashMap<ItemVariant, Long>();
    private long lastCacheUpdate = 0L;
    private static final long CACHE_DURATION = 20L;
    private final Map<class_2338, ProcessProbeConfig> linkedProcessProbes = new LinkedHashMap<class_2338, ProcessProbeConfig>();
    private int storedExperience = 0;
    private int nextProbeNumber = 1;
    private boolean networkDirty = true;

    public StorageControllerBlockEntity(class_2338 pos, class_2680 state) {
        super(SmartSorter.STORAGE_CONTROLLER_BE_TYPE, pos, state);
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, StorageControllerBlockEntity be) {
        if (world.method_8608()) {
            return;
        }
        if (world.method_8510() % 100L == 0L) {
            be.validateLinks();
        }
        if (be.networkDirty && world.method_8510() - be.lastCacheUpdate >= 20L) {
            be.updateNetworkCache();
            be.lastCacheUpdate = world.method_8510();
            be.syncToViewers();
            be.networkDirty = false;
        }
    }

    private void validateLinks() {
        this.linkedProbes.removeIf(probePos -> {
            class_2586 be = this.field_11863.method_8321(probePos);
            return !(be instanceof OutputProbeBlockEntity);
        });
    }

    public void updateNetworkCache() {
        this.networkItems.clear();
        if (this.field_11863 == null) {
            return;
        }
        for (class_2338 probePos : this.linkedProbes) {
            OutputProbeBlockEntity probe;
            Storage<ItemVariant> storage;
            class_2586 be = this.field_11863.method_8321(probePos);
            if (!(be instanceof OutputProbeBlockEntity) || (storage = (probe = (OutputProbeBlockEntity)be).getTargetStorage()) == null) continue;
            for (StorageView view : storage) {
                ItemVariant variant;
                if (view.getAmount() == 0L || (variant = (ItemVariant)view.getResource()).isBlank()) continue;
                this.networkItems.merge(variant, view.getAmount(), Long::sum);
            }
        }
    }

    private void syncToViewers() {
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            for (class_3222 player : serverWorld.method_18456()) {
                class_1703 class_17032 = player.field_7512;
                if (!(class_17032 instanceof StorageControllerScreenHandler)) continue;
                StorageControllerScreenHandler handler = (StorageControllerScreenHandler)class_17032;
                if (handler.controller != this) continue;
                handler.sendNetworkUpdate(player);
            }
        }
    }

    public void syncProbeStatsToClients(class_2338 probePos, int itemsProcessed) {
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            int playerCount = 0;
            for (class_3222 player : serverWorld.method_18456()) {
                class_1703 class_17032 = player.field_7512;
                if (!(class_17032 instanceof StorageControllerScreenHandler)) continue;
                StorageControllerScreenHandler handler = (StorageControllerScreenHandler)class_17032;
                if (handler.controller != this) continue;
                ServerPlayNetworking.send((class_3222)player, (class_8710)new ProbeStatsSyncPayload(probePos, itemsProcessed));
                ++playerCount;
            }
            if (playerCount == 0) {
                // empty if block
            }
        }
    }

    public void syncProbeConfigToClients(class_2338 probePos, ProcessProbeConfig config) {
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            if (this.linkedProcessProbes.containsKey(probePos)) {
                this.linkedProcessProbes.put(probePos, config.copy());
            }
            for (class_3222 player : serverWorld.method_18456()) {
                class_1703 class_17032 = player.field_7512;
                if (!(class_17032 instanceof StorageControllerScreenHandler)) continue;
                StorageControllerScreenHandler handler = (StorageControllerScreenHandler)class_17032;
                if (handler.controller != this) continue;
                ServerPlayNetworking.send((class_3222)player, (class_8710)new ProbeStatsSyncPayload(probePos, config.itemsProcessed));
                handler.sendNetworkUpdate(player);
            }
        }
    }

    public boolean addProbe(class_2338 probePos) {
        if (!this.linkedProbes.contains(probePos)) {
            this.linkedProbes.add(probePos);
            this.method_5431();
            if (this.field_11863 != null) {
                class_2680 state = this.field_11863.method_8320(this.field_11867);
                this.field_11863.method_8413(this.field_11867, state, state, 3);
            }
            this.networkDirty = true;
            this.updateNetworkCache();
            return true;
        }
        return false;
    }

    public List<class_2338> getLinkedProbes() {
        return this.linkedProbes;
    }

    public Map<ItemVariant, Long> getNetworkItems() {
        return new HashMap<ItemVariant, Long>(this.networkItems);
    }

    public int calculateTotalFreeSlots() {
        if (this.field_11863 == null) {
            return 0;
        }
        int totalFree = 0;
        for (class_2338 probePos : this.linkedProbes) {
            OutputProbeBlockEntity probe;
            class_1263 inv;
            class_2586 be = this.field_11863.method_8321(probePos);
            if (!(be instanceof OutputProbeBlockEntity) || (inv = (probe = (OutputProbeBlockEntity)be).getTargetInventory()) == null) continue;
            for (int i = 0; i < inv.method_5439(); ++i) {
                if (!inv.method_5438(i).method_7960()) continue;
                ++totalFree;
            }
        }
        return totalFree;
    }

    public int calculateTotalCapacity() {
        if (this.field_11863 == null) {
            return 0;
        }
        int totalSlots = 0;
        for (class_2338 probePos : this.linkedProbes) {
            OutputProbeBlockEntity probe;
            class_1263 inv;
            class_2586 be = this.field_11863.method_8321(probePos);
            if (!(be instanceof OutputProbeBlockEntity) || (inv = (probe = (OutputProbeBlockEntity)be).getTargetInventory()) == null) continue;
            totalSlots += inv.method_5439();
        }
        return totalSlots;
    }

    public int getLinkedInventoryCount() {
        return this.linkedProbes.size();
    }

    public class_1799 extractItem(ItemVariant variant, int amount) {
        int totalExtracted;
        if (this.field_11863 == null) {
            return class_1799.field_8037;
        }
        int remaining = amount;
        for (class_2338 probePos : this.linkedProbes) {
            Storage<ItemVariant> storage;
            OutputProbeBlockEntity probe;
            if (remaining <= 0) break;
            class_2586 be = this.field_11863.method_8321(probePos);
            if (!(be instanceof OutputProbeBlockEntity) || !(probe = (OutputProbeBlockEntity)be).accepts(variant) || (storage = probe.getTargetStorage()) == null) continue;
            int extracted = this.extractFromInventory(this.field_11863, probe, variant, remaining);
            remaining -= extracted;
        }
        if ((totalExtracted = amount - remaining) > 0) {
            this.networkDirty = true;
            this.updateNetworkCache();
            return variant.toStack(totalExtracted);
        }
        return class_1799.field_8037;
    }

    private int extractFromInventory(class_1937 world, OutputProbeBlockEntity probe, ItemVariant variant, int amount) {
        class_1263 inv = probe.getTargetInventory();
        if (inv == null) {
            return 0;
        }
        int extracted = 0;
        for (int i = 0; i < inv.method_5439() && extracted < amount; ++i) {
            ItemVariant stackVariant;
            class_1799 stack = inv.method_5438(i);
            if (stack.method_7960() || !(stackVariant = ItemVariant.of((class_1799)stack)).equals((Object)variant)) continue;
            int toExtract = Math.min(amount - extracted, stack.method_7947());
            stack.method_7934(toExtract);
            inv.method_5431();
            extracted += toExtract;
        }
        return extracted;
    }

    public class_1799 insertItemStack(class_1799 stack) {
        if (stack.method_7960()) {
            return class_1799.field_8037;
        }
        class_1799 remaining = stack.method_7972();
        this.insertItem(remaining);
        return class_1799.field_8037;
    }

    public class_1799 insertItem(class_1799 stack) {
        if (this.field_11863 == null || stack.method_7960()) {
            return stack;
        }
        ItemVariant variant = ItemVariant.of((class_1799)stack);
        int remaining = stack.method_7947();
        List<class_2338> sortedProbes = this.getSortedProbesByPriority();
        for (int i = 0; i < sortedProbes.size() && remaining > 0; ++i) {
            OutputProbeBlockEntity probe;
            boolean accepts;
            class_2338 probePos = sortedProbes.get(i);
            class_2586 be = this.field_11863.method_8321(probePos);
            if (!(be instanceof OutputProbeBlockEntity) || !(accepts = (probe = (OutputProbeBlockEntity)be).accepts(variant))) continue;
            class_1799 toInsert = variant.toStack(remaining);
            int inserted = this.insertIntoInventory(this.field_11863, probe, toInsert);
            remaining -= inserted;
        }
        if (remaining != stack.method_7947()) {
            this.networkDirty = true;
            this.updateNetworkCache();
            this.method_5431();
        }
        return remaining > 0 ? variant.toStack(remaining) : class_1799.field_8037;
    }

    private List<class_2338> getSortedProbesByPriority() {
        ArrayList<class_2338> filterProbes = new ArrayList<class_2338>();
        ArrayList<class_2338> priorityProbes = new ArrayList<class_2338>();
        ArrayList<class_2338> acceptAllProbes = new ArrayList<class_2338>();
        for (class_2338 probePos : this.linkedProbes) {
            class_2586 be = this.field_11863.method_8321(probePos);
            if (!(be instanceof OutputProbeBlockEntity)) continue;
            OutputProbeBlockEntity probe = (OutputProbeBlockEntity)be;
            switch (probe.mode) {
                case FILTER: {
                    filterProbes.add(probePos);
                    break;
                }
                case PRIORITY: {
                    priorityProbes.add(probePos);
                    break;
                }
                case ACCEPT_ALL: {
                    acceptAllProbes.add(probePos);
                }
            }
        }
        ArrayList<class_2338> sorted = new ArrayList<class_2338>();
        sorted.addAll(filterProbes);
        sorted.addAll(priorityProbes);
        sorted.addAll(acceptAllProbes);
        return sorted;
    }

    private int insertIntoInventory(class_1937 world, OutputProbeBlockEntity probe, class_1799 stack) {
        int maxStack;
        class_1799 slotStack;
        int i;
        class_1263 inv = probe.getTargetInventory();
        if (inv == null) {
            return 0;
        }
        int originalCount = stack.method_7947();
        for (i = 0; i < inv.method_5439() && !stack.method_7960(); ++i) {
            int canAdd;
            slotStack = inv.method_5438(i);
            if (slotStack.method_7960() || !class_1799.method_31577((class_1799)slotStack, (class_1799)stack) || (canAdd = (maxStack = Math.min(slotStack.method_7914(), inv.method_5444())) - slotStack.method_7947()) <= 0) continue;
            int toAdd = Math.min(canAdd, stack.method_7947());
            slotStack.method_7939(slotStack.method_7947() + toAdd);
            stack.method_7934(toAdd);
            inv.method_5431();
        }
        for (i = 0; i < inv.method_5439() && !stack.method_7960(); ++i) {
            slotStack = inv.method_5438(i);
            if (!slotStack.method_7960()) continue;
            maxStack = Math.min(stack.method_7914(), inv.method_5444());
            int toAdd = Math.min(maxStack, stack.method_7947());
            class_1799 newStack = stack.method_7972();
            newStack.method_7939(toAdd);
            inv.method_5447(i, newStack);
            stack.method_7934(toAdd);
            inv.method_5431();
        }
        return originalCount - stack.method_7947();
    }

    public int method_5439() {
        return 0;
    }

    public boolean method_5442() {
        return true;
    }

    public class_1799 method_5438(int slot) {
        return class_1799.field_8037;
    }

    public class_1799 method_5434(int slot, int amount) {
        return class_1799.field_8037;
    }

    public class_1799 method_5441(int slot) {
        return class_1799.field_8037;
    }

    public void method_5447(int slot, class_1799 stack) {
    }

    public boolean method_5443(class_1657 player) {
        return this.field_11867.method_19771((class_2382)player.method_24515(), 8.0);
    }

    public void method_5448() {
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)"container.smartsorter.storage_controller");
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new StorageControllerScreenHandler(syncId, playerInventory, this);
    }

    private void writeProbesToView(class_11372 view) {
        view.method_71465("probe_count", this.linkedProbes.size());
        for (int i = 0; i < this.linkedProbes.size(); ++i) {
            view.method_71466("probe_" + i, this.linkedProbes.get(i).method_10063());
        }
    }

    private void readProbesFromView(class_11368 view) {
        this.linkedProbes.clear();
        int count = view.method_71424("probe_count", 0);
        for (int i = 0; i < count; ++i) {
            Optional maybe = view.method_71440("probe_" + i);
            maybe.ifPresent(posLong -> this.linkedProbes.add(class_2338.method_10092((long)posLong)));
        }
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 registryLookup) {
        return this.method_38244(registryLookup);
    }

    public void onProbeInventoryChanged(OutputProbeBlockEntity probe) {
        this.networkDirty = true;
    }

    public boolean removeProbe(class_2338 probePos) {
        boolean removed = this.linkedProbes.remove(probePos);
        if (removed) {
            this.networkDirty = true;
            this.method_5431();
            if (this.field_11863 != null) {
                class_2680 state = this.field_11863.method_8320(this.field_11867);
                this.field_11863.method_8413(this.field_11867, state, state, 3);
            }
        }
        return removed;
    }

    public boolean registerProcessProbe(class_2338 pos, String machineType) {
        if (this.field_11863 == null) {
            return false;
        }
        class_2586 be = this.field_11863.method_8321(pos);
        if (!(be instanceof ProcessProbeBlockEntity)) {
            return false;
        }
        ProcessProbeBlockEntity probe = (ProcessProbeBlockEntity)be;
        ProcessProbeConfig config = probe.getConfig().copy();
        config.machineType = machineType;
        config.position = pos;
        if (!this.linkedProcessProbes.containsKey(pos)) {
            int index = this.getNextIndexForMachineType(machineType);
            config.setIndex(index);
        } else {
            ProcessProbeConfig existingConfig = this.linkedProcessProbes.get(pos);
            if (existingConfig != null) {
                config.setIndex(existingConfig.index);
            }
        }
        this.linkedProcessProbes.put(pos, config);
        probe.setConfig(config);
        this.method_5431();
        this.networkDirty = true;
        return true;
    }

    private int getNextIndexForMachineType(String machineType) {
        HashSet<Integer> usedIndices = new HashSet<Integer>();
        for (ProcessProbeConfig config : this.linkedProcessProbes.values()) {
            String displayName;
            if (!config.machineType.equals(machineType) || !(displayName = config.getDisplayName()).contains("#")) continue;
            try {
                String numStr = displayName.substring(displayName.indexOf("#") + 1).trim();
                usedIndices.add(Integer.parseInt(numStr) - 1);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        int index = 0;
        while (usedIndices.contains(index)) {
            ++index;
        }
        return index;
    }

    public void unregisterProcessProbe(class_2338 pos) {
        ProcessProbeConfig config = this.linkedProcessProbes.get(pos);
        if (config != null) {
            class_2586 be;
            if (this.field_11863 != null && (be = this.field_11863.method_8321(pos)) instanceof ProcessProbeBlockEntity) {
                ProcessProbeBlockEntity probe = (ProcessProbeBlockEntity)be;
                probe.setConfig(config.copy());
            }
            this.linkedProcessProbes.remove(pos);
            this.method_5431();
            this.networkDirty = true;
        }
    }

    public void updateProbeConfig(ProcessProbeConfig config) {
        if (this.linkedProcessProbes.containsKey(config.position)) {
            class_2586 be;
            this.linkedProcessProbes.put(config.position, config.copy());
            if (this.field_11863 != null && (be = this.field_11863.method_8321(config.position)) instanceof ProcessProbeBlockEntity) {
                ProcessProbeBlockEntity probe = (ProcessProbeBlockEntity)be;
                probe.setConfig(config.copy());
                this.syncProbeStatsToClients(config.position, config.itemsProcessed);
            }
            this.method_5431();
            this.networkDirty = true;
            this.syncToViewers();
        }
    }

    public Map<class_2338, ProcessProbeConfig> getProcessProbeConfigs() {
        return new LinkedHashMap<class_2338, ProcessProbeConfig>(this.linkedProcessProbes);
    }

    public ProcessProbeConfig getProbeConfig(class_2338 pos) {
        return this.linkedProcessProbes.get(pos);
    }

    public void addExperience(int amount) {
        this.storedExperience += amount;
        this.method_5431();
    }

    public int getStoredExperience() {
        return this.storedExperience;
    }

    public int collectExperience() {
        int xp = this.storedExperience;
        this.storedExperience = 0;
        this.method_5431();
        return xp;
    }

    public class_2487 exportConfigs() {
        class_2487 export = new class_2487();
        class_2499 probeList = new class_2499();
        for (ProcessProbeConfig config : this.linkedProcessProbes.values()) {
            probeList.add((Object)config.toNbt());
        }
        export.method_10566("probes", (class_2520)probeList);
        export.method_10569("storedXp", this.storedExperience);
        return export;
    }

    public void importConfigs(class_2487 imported) {
    }

    public void method_11007(class_11372 view) {
        super.method_11007(view);
        this.writeProbesToView(view);
        class_2487 probeData = new class_2487();
        class_2499 probeConfigList = new class_2499();
        for (ProcessProbeConfig config : this.linkedProcessProbes.values()) {
            probeConfigList.add((Object)config.toNbt());
        }
        probeData.method_10566("configs", (class_2520)probeConfigList);
        probeData.method_10569("storedXp", this.storedExperience);
        view.method_71465("processProbeCount", this.linkedProcessProbes.size());
        int idx = 0;
        for (ProcessProbeConfig config : this.linkedProcessProbes.values()) {
            class_2487 configNbt = config.toNbt();
            view.method_71466("pp_pos_" + idx, config.position.method_10063());
            if (config.customName != null) {
                view.method_71469("pp_name_" + idx, config.customName);
            }
            view.method_71469("pp_type_" + idx, config.machineType);
            view.method_71472("pp_enabled_" + idx, config.enabled);
            view.method_71469("pp_recipe_" + idx, config.recipeFilter.asString());
            view.method_71469("pp_fuel_" + idx, config.fuelFilter.asString());
            view.method_71465("pp_processed_" + idx, config.itemsProcessed);
            view.method_71465("pp_index_" + idx, config.index);
            ++idx;
        }
        view.method_71465("storedXp", this.storedExperience);
    }

    public void method_11014(class_11368 view) {
        super.method_11014(view);
        this.readProbesFromView(view);
        this.linkedProcessProbes.clear();
        int probeCount = view.method_71424("processProbeCount", 0);
        for (int i = 0; i < probeCount; ++i) {
            ProcessProbeConfig config = new ProcessProbeConfig();
            view.method_71440("pp_pos_" + i).ifPresent(posLong -> {
                config.position = class_2338.method_10092((long)posLong);
            });
            config.customName = view.method_71428("pp_name_" + i, null);
            config.machineType = view.method_71428("pp_type_" + i, "Unknown");
            config.enabled = view.method_71433("pp_enabled_" + i, true);
            config.recipeFilter = RecipeFilterMode.fromString(view.method_71428("pp_recipe_" + i, "ORES_ONLY"));
            config.fuelFilter = FuelFilterMode.fromString(view.method_71428("pp_fuel_" + i, "COAL_ONLY"));
            config.itemsProcessed = view.method_71424("pp_processed_" + i, 0);
            config.index = view.method_71424("pp_index_" + i, 0);
            if (config.position == null) continue;
            this.linkedProcessProbes.put(config.position, config);
        }
        this.storedExperience = view.method_71424("storedXp", 0);
    }

    public void onRemoved() {
        this.linkedProbes.clear();
        this.networkItems.clear();
        this.linkedProcessProbes.clear();
    }
}

