/*
 * Decompiled with CFR 0.152.
 */
package net.shaddii.smartsorter.screen;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.screen.v1.ScreenMouseEvents;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.minecraft.class_10799;
import net.minecraft.class_11905;
import net.minecraft.class_11908;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_8710;
import net.shaddii.smartsorter.network.CollectXpPayload;
import net.shaddii.smartsorter.network.FilterCategoryChangePayload;
import net.shaddii.smartsorter.network.SortModeChangePayload;
import net.shaddii.smartsorter.screen.StorageControllerScreenHandler;
import net.shaddii.smartsorter.util.Category;
import net.shaddii.smartsorter.util.CategoryManager;
import net.shaddii.smartsorter.util.ProcessProbeConfig;
import net.shaddii.smartsorter.util.SortMode;
import net.shaddii.smartsorter.widget.DropdownWidget;
import net.shaddii.smartsorter.widget.ProbeConfigPanel;
import net.shaddii.smartsorter.widget.ProbeSelectorWidget;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fc;
import org.lwjgl.glfw.GLFW;

public class StorageControllerScreen
extends class_465<StorageControllerScreenHandler> {
    private static final class_2960 TEXTURE = class_2960.method_60655((String)"smartsorter", (String)"textures/gui/storage_controller.png");
    private class_2338 lastSelectedProbePos = null;
    private List<Map.Entry<ItemVariant, Long>> cachedFilteredList = null;
    private String lastSearchTerm = "";
    private SortMode lastSortMode = SortMode.NAME;
    private Category lastFilterCategory = Category.ALL;
    private int lastNetworkItemsHash = 0;
    private List<class_2561> cachedTooltip = null;
    private ItemVariant cachedTooltipItem = null;
    private long cachedTooltipAmount = 0L;
    private static final String[] AMOUNT_CACHE = new String[1000];
    private Tab currentTab = Tab.STORAGE;
    private List<class_4185> tabButtons = new ArrayList<class_4185>();
    private ProbeSelectorWidget probeSelector;
    private ProbeConfigPanel configPanel;
    private int lastCollectedXp = 0;
    private long lastCollectionTime = 0L;
    private float scrollProgress = 0.0f;
    private boolean isScrolling = false;
    private static final int ITEMS_PER_ROW = 9;
    private static final int VISIBLE_ROWS = 5;
    private static final int ITEMS_PER_PAGE = 45;
    private static final int GRID_START_X = 8;
    private static final int GRID_START_Y = 18;
    private static final int SLOT_SIZE = 18;
    private static final int SCROLLBAR_X = 174;
    private static final int SCROLLBAR_Y = 18;
    private static final int SCROLLBAR_WIDTH = 14;
    private static final int SCROLLBAR_HEIGHT = 90;
    private List<Map.Entry<ItemVariant, Long>> networkItemsList = new ArrayList<Map.Entry<ItemVariant, Long>>();
    private int maxScrollRows = 0;
    private boolean needsRefresh = true;
    private class_342 searchBox;
    private String currentSearch = "";
    private class_4185 sortButton;
    private DropdownWidget filterDropdown;

    public StorageControllerScreen(StorageControllerScreenHandler handler, class_1661 inventory, class_2561 title) {
        super((class_1703)handler, inventory, title);
        this.field_2792 = 194;
        this.field_2779 = 202;
        this.field_25267 = 7;
        this.field_25268 = 6;
        this.field_25269 = 8;
        this.field_25270 = 109;
    }

    protected void method_25426() {
        super.method_25426();
        this.initTabButtons();
        if (this.currentTab == Tab.STORAGE) {
            this.initStorageWidgets();
        } else {
            this.initAutoProcessingWidgets();
        }
        this.registerMouseEvents();
        ((StorageControllerScreenHandler)this.field_2797).requestSync();
        this.updateNetworkItems();
    }

    public boolean method_25404(class_11908 input) {
        if (this.currentTab == Tab.AUTO_PROCESSING && this.probeSelector != null && this.probeSelector.keyPressed(input.comp_4795(), 0, input.comp_4797())) {
            return true;
        }
        if (this.currentTab == Tab.STORAGE && this.searchBox != null && this.searchBox.method_25370()) {
            if (input.comp_4795() == 256) {
                this.searchBox.method_25365(false);
                return true;
            }
            if (input.comp_4795() == 257 || input.comp_4795() == 335) {
                this.searchBox.method_25365(false);
                return true;
            }
            if (this.searchBox.method_25404(input)) {
                return true;
            }
            return true;
        }
        if (this.currentTab == Tab.STORAGE && this.searchBox != null && !this.searchBox.method_25370()) {
            if (input.comp_4795() == 70 && (input.comp_4797() & 2) != 0) {
                this.searchBox.method_25365(true);
                this.method_25395((class_364)this.searchBox);
                return true;
            }
            if (input.comp_4795() == 47) {
                this.searchBox.method_25365(true);
                this.method_25395((class_364)this.searchBox);
                return true;
            }
        }
        return super.method_25404(input);
    }

    public boolean method_25400(class_11905 input) {
        if (this.currentTab == Tab.AUTO_PROCESSING && this.probeSelector != null && this.probeSelector.charTyped((char)input.comp_4793(), input.comp_4794())) {
            return true;
        }
        if (this.searchBox != null && this.searchBox.method_25370()) {
            return this.searchBox.method_25400(input);
        }
        return super.method_25400(input);
    }

    public boolean method_16803(class_11908 input) {
        if (this.searchBox != null && this.searchBox.method_25370()) {
            return this.searchBox.method_16803(input);
        }
        return super.method_16803(input);
    }

    private void initTabButtons() {
        int guiX = (this.field_22789 - this.field_2792) / 2;
        int guiY = (this.field_22790 - this.field_2779) / 2;
        int tabX = guiX - 60;
        int tabY = guiY + 10;
        int tabWidth = 58;
        int tabHeight = 22;
        int tabSpacing = 4;
        this.tabButtons.clear();
        class_4185 storageTab = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Items"), btn -> this.switchTab(Tab.STORAGE)).method_46434(tabX, tabY, tabWidth, tabHeight).method_46431();
        class_4185 processingTab = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Config"), btn -> this.switchTab(Tab.AUTO_PROCESSING)).method_46434(tabX, tabY + tabHeight + tabSpacing, tabWidth, tabHeight).method_46431();
        this.tabButtons.add(storageTab);
        this.tabButtons.add(processingTab);
        this.method_37063((class_364)storageTab);
        this.method_37063((class_364)processingTab);
    }

    private void switchTab(Tab newTab) {
        if (this.currentTab == newTab) {
            return;
        }
        this.currentTab = newTab;
        this.method_37067();
        this.searchBox = null;
        this.sortButton = null;
        this.filterDropdown = null;
        this.probeSelector = null;
        this.configPanel = null;
        for (class_4185 btn : this.tabButtons) {
            this.method_37063((class_364)btn);
        }
        if (this.currentTab == Tab.STORAGE) {
            this.initStorageWidgets();
        } else {
            this.initAutoProcessingWidgets();
        }
        this.registerMouseEvents();
    }

    private void initStorageWidgets() {
        int searchBoxWidth = 90;
        int searchBoxHeight = 13;
        int searchBoxX = (this.field_22789 - this.field_2792) / 2 + 82;
        int searchBoxY = (this.field_22790 - this.field_2779) / 2 + 6;
        this.searchBox = new class_342(this.field_22793, searchBoxX, searchBoxY, searchBoxWidth, searchBoxHeight, (class_2561)class_2561.method_43470((String)""));
        this.searchBox.method_1858(false);
        this.searchBox.method_1863(this::onSearchChanged);
        this.method_37063((class_364)this.searchBox);
        int sortButtonX = searchBoxX;
        int sortButtonY = searchBoxY + searchBoxHeight - 34;
        int sortButtonWidth = 30;
        int sortButtonHeight = 12;
        this.sortButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)((StorageControllerScreenHandler)this.field_2797).getSortMode().getDisplayName()), button -> this.cycleSortMode()).method_46434(sortButtonX, sortButtonY, sortButtonWidth, sortButtonHeight).method_46431();
        this.method_37063((class_364)this.sortButton);
        int filterDropdownX = sortButtonX + sortButtonWidth + 2;
        int filterDropdownY = sortButtonY;
        int filterDropdownWidth = 60;
        int filterDropdownHeight = 12;
        this.filterDropdown = new DropdownWidget(filterDropdownX, filterDropdownY, filterDropdownWidth, filterDropdownHeight, (class_2561)class_2561.method_43470((String)""));
        List<Category> allCategories = CategoryManager.getInstance().getAllCategories();
        ArrayList<Category> categoryList = new ArrayList<Category>();
        for (Category category : allCategories) {
            categoryList.add(category);
            this.filterDropdown.addEntry(category.getShortName(), category.getDisplayName());
        }
        Category currentCategory = ((StorageControllerScreenHandler)this.field_2797).getFilterCategory();
        int selectedIndex = 0;
        for (int i = 0; i < categoryList.size(); ++i) {
            if (!((Category)categoryList.get(i)).getId().equals((Object)currentCategory.getId())) continue;
            selectedIndex = i;
            break;
        }
        this.filterDropdown.setSelectedIndex(selectedIndex);
        this.filterDropdown.setOnSelect(index -> {
            if (index >= 0 && index < categoryList.size()) {
                Category selected = (Category)categoryList.get((int)index);
                ((StorageControllerScreenHandler)this.field_2797).setFilterCategory(selected);
                this.needsRefresh = true;
                ClientPlayNetworking.send((class_8710)new FilterCategoryChangePayload(selected.asString()));
            }
        });
        this.method_37063((class_364)this.filterDropdown);
        this.filterDropdown.field_22763 = true;
        this.filterDropdown.field_22764 = true;
    }

    private void initAutoProcessingWidgets() {
        int guiX = (this.field_22789 - this.field_2792) / 2;
        int guiY = (this.field_22790 - this.field_2779) / 2;
        this.probeSelector = new ProbeSelectorWidget(guiX + 8, guiY + 18, this.field_2792 - 16, 10, this.field_22793);
        Map<class_2338, ProcessProbeConfig> configs = ((StorageControllerScreenHandler)this.field_2797).getProcessProbeConfigs();
        this.probeSelector.updateProbes(configs);
        if (this.lastSelectedProbePos != null && configs.containsKey(this.lastSelectedProbePos)) {
            ArrayList<ProcessProbeConfig> configList = new ArrayList<ProcessProbeConfig>(configs.values());
            configList.sort((a, b) -> {
                if (a.position.method_10263() != b.position.method_10263()) {
                    return Integer.compare(a.position.method_10263(), b.position.method_10263());
                }
                if (a.position.method_10264() != b.position.method_10264()) {
                    return Integer.compare(a.position.method_10264(), b.position.method_10264());
                }
                return Integer.compare(a.position.method_10260(), b.position.method_10260());
            });
            for (int i = 0; i < configList.size(); ++i) {
                if (!((ProcessProbeConfig)configList.get((int)i)).position.equals((Object)this.lastSelectedProbePos)) continue;
                this.probeSelector.setSelectedIndex(i);
                break;
            }
        }
        this.probeSelector.setOnSelectionChange(config -> {
            if (this.configPanel != null) {
                this.configPanel.setConfig((ProcessProbeConfig)config);
                this.lastSelectedProbePos = config != null ? config.position : null;
            }
        });
        this.probeSelector.setOnConfigUpdate(config -> {
            this.needsRefresh = true;
        });
        this.configPanel = new ProbeConfigPanel(guiX + 8, guiY + 30, this.field_2792 - 16, 75, this.field_22793);
        ProcessProbeConfig selected = this.probeSelector.getSelectedProbe();
        this.configPanel.setConfig(selected);
        if (selected != null) {
            this.lastSelectedProbePos = selected.position;
        }
        this.configPanel.setOnConfigUpdate(config -> {
            this.needsRefresh = true;
        });
    }

    private void registerMouseEvents() {
        ScreenMouseEvents.allowMouseClick((class_437)this).register((screen, click) -> {
            boolean consumed;
            if (!(screen instanceof StorageControllerScreen)) {
                return true;
            }
            StorageControllerScreen gui = (StorageControllerScreen)screen;
            if (gui.filterDropdown != null && gui.filterDropdown.isOpen()) {
                if (gui.filterDropdown.method_25405(click.comp_4798(), click.comp_4799())) {
                    boolean handled = gui.filterDropdown.mouseClicked(click.comp_4798(), click.comp_4799(), click.method_74245());
                    return !handled;
                }
                gui.filterDropdown.close();
                return true;
            }
            if (gui.currentTab == Tab.STORAGE && gui.searchBox != null) {
                int sx = gui.searchBox.method_46426();
                int sy = gui.searchBox.method_46427();
                int sw = gui.searchBox.method_25368();
                int sh = gui.searchBox.method_25364();
                if (click.comp_4798() >= (double)sx && click.comp_4798() < (double)(sx + sw) && click.comp_4799() >= (double)sy && click.comp_4799() < (double)(sy + sh)) {
                    gui.method_25395((class_364)gui.searchBox);
                    gui.searchBox.method_25365(true);
                    return true;
                }
            }
            return !(consumed = gui.onMouseClickIntercept(click.comp_4798(), click.comp_4799(), click.method_74245()));
        });
        ScreenMouseEvents.allowMouseRelease((class_437)this).register((screen, click) -> {
            if (!(screen instanceof StorageControllerScreen)) {
                return true;
            }
            StorageControllerScreen gui = (StorageControllerScreen)screen;
            boolean consumed = gui.onMouseReleaseIntercept(click.comp_4798(), click.comp_4799(), click.method_74245());
            return !consumed;
        });
        ScreenMouseEvents.allowMouseDrag((class_437)this).register((screen, click, deltaX, deltaY) -> {
            if (!(screen instanceof StorageControllerScreen)) {
                return true;
            }
            StorageControllerScreen gui = (StorageControllerScreen)screen;
            boolean consumed = gui.onMouseDragIntercept(click.comp_4798(), click.comp_4799(), click.method_74245(), deltaX, deltaY);
            return !consumed;
        });
        ScreenMouseEvents.allowMouseScroll((class_437)this).register((screen, mouseX, mouseY, horizontal, vertical) -> {
            boolean handled;
            if (!(screen instanceof StorageControllerScreen)) {
                return true;
            }
            StorageControllerScreen gui = (StorageControllerScreen)screen;
            if (gui.filterDropdown != null && gui.filterDropdown.isOpen() && (handled = gui.filterDropdown.method_25401(mouseX, mouseY, horizontal, vertical))) {
                return false;
            }
            boolean consumed = gui.onMouseScrollIntercept(mouseX, mouseY, horizontal, vertical);
            return !consumed;
        });
    }

    private void onSearchChanged(String searchText) {
        this.currentSearch = searchText.toLowerCase();
        this.needsRefresh = true;
        this.scrollProgress = 0.0f;
        this.cachedFilteredList = null;
    }

    private void cycleSortMode() {
        SortMode currentMode = ((StorageControllerScreenHandler)this.field_2797).getSortMode();
        SortMode newMode = currentMode.next();
        this.sortButton.method_25355((class_2561)class_2561.method_43470((String)newMode.getDisplayName()));
        ((StorageControllerScreenHandler)this.field_2797).setSortMode(newMode);
        this.needsRefresh = true;
        this.cachedFilteredList = null;
        ClientPlayNetworking.send((class_8710)new SortModeChangePayload(newMode.method_15434()));
    }

    public void updateNetworkItems() {
        Map<ItemVariant, Long> items = ((StorageControllerScreenHandler)this.field_2797).getNetworkItems();
        SortMode currentSortMode = ((StorageControllerScreenHandler)this.field_2797).getSortMode();
        Category currentCategory = ((StorageControllerScreenHandler)this.field_2797).getFilterCategory();
        int newHash = items.hashCode() ^ this.currentSearch.hashCode() ^ currentSortMode.hashCode() ^ currentCategory.hashCode();
        if (this.cachedFilteredList != null && newHash == this.lastNetworkItemsHash && this.currentSearch.equals(this.lastSearchTerm) && currentSortMode == this.lastSortMode && currentCategory.equals(this.lastFilterCategory)) {
            this.networkItemsList = this.cachedFilteredList;
            return;
        }
        this.networkItemsList = new ArrayList<Map.Entry<ItemVariant, Long>>(items.entrySet());
        if (currentCategory != Category.ALL) {
            CategoryManager categoryManager = CategoryManager.getInstance();
            this.networkItemsList.removeIf(entry -> {
                Category itemCategory = categoryManager.categorize(((ItemVariant)entry.getKey()).getItem());
                return !itemCategory.equals(currentCategory);
            });
        }
        if (!this.currentSearch.isEmpty()) {
            String lowerSearch = this.currentSearch.toLowerCase();
            this.networkItemsList.removeIf(entry -> {
                String itemName = ((ItemVariant)entry.getKey()).getItem().method_63680().getString().toLowerCase();
                return !itemName.contains(lowerSearch);
            });
        }
        switch (currentSortMode) {
            case NAME: {
                this.networkItemsList.sort((a, b) -> {
                    String nameA = ((ItemVariant)a.getKey()).getItem().method_63680().getString();
                    String nameB = ((ItemVariant)b.getKey()).getItem().method_63680().getString();
                    return nameA.compareTo(nameB);
                });
                break;
            }
            case COUNT: {
                this.networkItemsList.sort((a, b) -> Long.compare((Long)b.getValue(), (Long)a.getValue()));
            }
        }
        this.cachedFilteredList = this.networkItemsList;
        this.lastNetworkItemsHash = newHash;
        this.lastSearchTerm = this.currentSearch;
        this.lastSortMode = currentSortMode;
        this.lastFilterCategory = currentCategory;
        int totalRows = (int)Math.ceil((double)this.networkItemsList.size() / 9.0);
        this.maxScrollRows = Math.max(0, totalRows - 5);
    }

    public void markDirty() {
        this.needsRefresh = true;
        this.cachedFilteredList = null;
    }

    private void collectXp() {
        int xp = ((StorageControllerScreenHandler)this.field_2797).getStoredExperience();
        if (xp > 0) {
            this.lastCollectedXp = xp;
            this.lastCollectionTime = System.currentTimeMillis();
            ClientPlayNetworking.send((class_8710)new CollectXpPayload());
        }
    }

    protected void method_2389(class_332 context, float delta, int mouseX, int mouseY) {
        int x = (this.field_22789 - this.field_2792) / 2;
        int y = (this.field_22790 - this.field_2779) / 2;
        context.method_25290(class_10799.field_56883, TEXTURE, x, y, 0.0f, 0.0f, this.field_2792, this.field_2779, 256, 256);
        if (this.currentTab == Tab.STORAGE) {
            this.drawScrollbar(context, x, y);
        }
    }

    private void drawScrollbar(class_332 context, int guiX, int guiY) {
        int scrollbarX = guiX + 174;
        int scrollbarY = guiY + 18;
        context.method_25294(scrollbarX, scrollbarY, scrollbarX + 14, scrollbarY + 90, -3750202);
        context.method_25294(scrollbarX, scrollbarY, scrollbarX + 1, scrollbarY + 90, -13158601);
        context.method_25294(scrollbarX + 14 - 1, scrollbarY, scrollbarX + 14, scrollbarY + 90, -1);
        if (this.maxScrollRows > 0) {
            int handleHeight = 15;
            int maxHandleOffset = 90 - handleHeight;
            int handleY = scrollbarY + (int)(this.scrollProgress * (float)maxHandleOffset);
            context.method_25294(scrollbarX + 1, handleY, scrollbarX + 14 - 1, handleY + handleHeight, -7631989);
            context.method_25294(scrollbarX + 1, handleY, scrollbarX + 14 - 1, handleY + 1, -1);
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        if (this.needsRefresh) {
            this.updateNetworkItems();
            this.needsRefresh = false;
        }
        this.method_25420(context, mouseX, mouseY, delta);
        super.method_25394(context, mouseX, mouseY, delta);
        if (this.currentTab == Tab.STORAGE) {
            this.renderNetworkItems(context, mouseX, mouseY);
            if (this.filterDropdown != null && this.filterDropdown.isOpen()) {
                this.filterDropdown.renderDropdown(context, mouseX, mouseY);
            }
        } else {
            this.renderXpDisplay(context, mouseX, mouseY);
            this.renderAutoProcessingTab(context, mouseX, mouseY, delta);
            if (this.probeSelector != null) {
                this.probeSelector.renderDropdownIfOpen(context, mouseX, mouseY);
            }
        }
        this.method_2380(context, mouseX, mouseY);
    }

    private void renderAutoProcessingTab(class_332 context, int mouseX, int mouseY, float delta) {
        int x = (this.field_22789 - this.field_2792) / 2;
        int y = (this.field_22790 - this.field_2779) / 2;
        context.method_51433(this.field_22793, "Config", x + 8, y + 6, -12566464, false);
        if (this.probeSelector != null) {
            this.probeSelector.render(context, mouseX, mouseY, delta);
        }
        if (this.configPanel != null) {
            this.configPanel.render(context, mouseX, mouseY, delta);
        }
    }

    private void renderNetworkItems(class_332 context, int mouseX, int mouseY) {
        int x = (this.field_22789 - this.field_2792) / 2;
        int y = (this.field_22790 - this.field_2779) / 2;
        int scrollOffset = (int)(this.scrollProgress * (float)this.maxScrollRows);
        int startIndex = scrollOffset * 9;
        int endIndex = Math.min(startIndex + 45, this.networkItemsList.size());
        for (int i = startIndex; i < endIndex; ++i) {
            int relativeIndex = i - startIndex;
            int row = relativeIndex / 9;
            int col = relativeIndex % 9;
            int slotX = x + 8 + col * 18;
            int slotY = y + 18 + row * 18;
            Map.Entry<ItemVariant, Long> entry = this.networkItemsList.get(i);
            ItemVariant variant = entry.getKey();
            long amount = entry.getValue();
            context.method_25294(slotX, slotY, slotX + 16, slotY + 16, -1953789045);
            context.method_51427(variant.toStack(), slotX, slotY);
            if (amount > 1L) {
                String amountText = this.formatAmount(amount);
                float scale = 0.75f;
                int rawWidth = this.field_22793.method_1727(amountText);
                float scaledWidth = (float)rawWidth * scale;
                float textX = (float)(slotX + 16) - scaledWidth;
                float textY = slotY + 9;
                context.method_51448().pushMatrix();
                context.method_51448().translate(textX, textY);
                context.method_51448().scale(scale, scale);
                context.method_51433(this.field_22793, amountText, 0, 0, -1, true);
                context.method_51448().popMatrix();
            }
            if (!this.isMouseOverSlot(slotX, slotY, mouseX, mouseY)) continue;
            context.method_25294(slotX, slotY, slotX + 16, slotY + 16, -2130706433);
        }
    }

    private void renderXpDisplay(class_332 context, int mouseX, int mouseY) {
        boolean justClicked;
        int x = (this.field_22789 - this.field_2792) / 2;
        int y = (this.field_22790 - this.field_2779) / 2;
        int xp = ((StorageControllerScreenHandler)this.field_2797).getStoredExperience();
        long timeSinceCollection = System.currentTimeMillis() - this.lastCollectionTime;
        if (timeSinceCollection < 2000L && this.lastCollectedXp > 0) {
            float alpha = 1.0f - (float)timeSinceCollection / 2000.0f;
            int yOffset = (int)(timeSinceCollection / 20L);
            String collectedText = "+" + this.lastCollectedXp + " XP!";
            float scale = 0.7f;
            int scaledWidth = (int)((float)this.field_22793.method_1727(collectedText) * scale);
            int collectedX = x + this.field_2792 / 2 - scaledWidth / 2;
            int collectedY = y + 50 - yOffset;
            int color = (int)(alpha * 255.0f) << 24 | 0x55FF55;
            Matrix3x2f oldMatrix = new Matrix3x2f((Matrix3x2fc)context.method_51448());
            Matrix3x2f scaleMatrix = new Matrix3x2f().scaling(scale, scale);
            context.method_51448().mul((Matrix3x2fc)scaleMatrix);
            Matrix3x2f translateMatrix = new Matrix3x2f().translation((float)collectedX / scale, (float)collectedY / scale);
            context.method_51448().mul((Matrix3x2fc)translateMatrix);
            context.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)collectedText), 0, 0, color, true);
            context.method_51448().set((Matrix3x2fc)oldMatrix);
        }
        float textScale = 0.7f;
        String xpText = "XP: " + xp;
        int xpTextWidth = (int)((float)this.field_22793.method_1727(xpText) * textScale);
        int xpX = x + this.field_2792 - 85;
        int xpY = y + 6;
        context.method_25294(xpX - 2, xpY - 1, xpX + xpTextWidth + 32, xpY + 10, -1442840576);
        context.method_25294(xpX - 3, xpY - 2, xpX + xpTextWidth + 33, xpY - 1, -1);
        context.method_25294(xpX - 3, xpY + 10, xpX + xpTextWidth + 33, xpY + 11, -7829368);
        Matrix3x2f oldMatrix = new Matrix3x2f((Matrix3x2fc)context.method_51448());
        Matrix3x2f scaleMatrix = new Matrix3x2f().scaling(textScale, textScale);
        context.method_51448().mul((Matrix3x2fc)scaleMatrix);
        Matrix3x2f translateMatrix = new Matrix3x2f().translation((float)xpX / textScale, (float)(xpY + 1) / textScale);
        context.method_51448().mul((Matrix3x2fc)translateMatrix);
        context.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)xpText), 0, 0, -256, true);
        context.method_51448().set((Matrix3x2fc)oldMatrix);
        int btnX = xpX + xpTextWidth + 3;
        int btnY = xpY;
        int btnWidth = 28;
        int btnHeight = 9;
        boolean hovered = mouseX >= btnX && mouseX < btnX + btnWidth && mouseY >= btnY && mouseY < btnY + btnHeight;
        boolean bl = justClicked = timeSinceCollection < 200L;
        int btnBg = xp > 0 ? (justClicked ? -171 : (hovered ? -11141291 : -16733696)) : -12303292;
        int textColor = xp > 0 ? -1 : -7829368;
        context.method_25294(btnX, btnY, btnX + btnWidth, btnY + btnHeight, btnBg);
        context.method_25294(btnX, btnY, btnX + btnWidth, btnY + 1, -1);
        context.method_25294(btnX, btnY + btnHeight - 1, btnX + btnWidth, btnY + btnHeight, -7829368);
        context.method_25294(btnX, btnY, btnX + 1, btnY + btnHeight, -1);
        context.method_25294(btnX + btnWidth - 1, btnY, btnX + btnWidth, btnY + btnHeight, -7829368);
        float btnTextScale = 0.65f;
        Matrix3x2f oldMatrix2 = new Matrix3x2f((Matrix3x2fc)context.method_51448());
        Matrix3x2f scaleMatrix2 = new Matrix3x2f().scaling(btnTextScale, btnTextScale);
        context.method_51448().mul((Matrix3x2fc)scaleMatrix2);
        Matrix3x2f translateMatrix2 = new Matrix3x2f().translation((float)(btnX + 3) / btnTextScale, (float)(btnY + 2) / btnTextScale);
        context.method_51448().mul((Matrix3x2fc)translateMatrix2);
        context.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)"Collect"), 0, 0, textColor, true);
        context.method_51448().set((Matrix3x2fc)oldMatrix2);
    }

    public void updateProbeStats(class_2338 position, int itemsProcessed) {
        Map<class_2338, ProcessProbeConfig> configs;
        ProcessProbeConfig config;
        if (this.currentTab == Tab.AUTO_PROCESSING && (config = (configs = ((StorageControllerScreenHandler)this.field_2797).getProcessProbeConfigs()).get(position)) != null) {
            ProcessProbeConfig selected;
            config.itemsProcessed = itemsProcessed;
            if (this.probeSelector != null && this.configPanel != null && (selected = this.probeSelector.getSelectedProbe()) != null && selected.position.equals((Object)position)) {
                selected.itemsProcessed = itemsProcessed;
                this.configPanel.setConfig(selected);
            }
            if (this.probeSelector != null) {
                this.probeSelector.updateProbes(((StorageControllerScreenHandler)this.field_2797).getProcessProbeConfigs());
            }
            this.needsRefresh = true;
        }
    }

    private boolean onMouseClickIntercept(double mouseX, double mouseY, int button) {
        boolean clickInGrid;
        boolean result;
        if (this.currentTab == Tab.AUTO_PROCESSING && button == 0) {
            int x = (this.field_22789 - this.field_2792) / 2;
            int y = (this.field_22790 - this.field_2779) / 2;
            float textScale = 0.7f;
            String xpText = "XP: " + ((StorageControllerScreenHandler)this.field_2797).getStoredExperience();
            int xpTextWidth = (int)((float)this.field_22793.method_1727(xpText) * textScale);
            int xpX = x + this.field_2792 - 85;
            int btnX = xpX + xpTextWidth + 3;
            int btnY = y + 6;
            int btnWidth = 28;
            int btnHeight = 9;
            if (mouseX >= (double)btnX && mouseX <= (double)(btnX + btnWidth) && mouseY >= (double)btnY && mouseY <= (double)(btnY + btnHeight)) {
                this.collectXp();
                return true;
            }
        }
        if (this.currentTab == Tab.AUTO_PROCESSING) {
            if (this.probeSelector != null && this.probeSelector.mouseClicked(mouseX, mouseY, button)) {
                return true;
            }
            return this.configPanel != null && this.configPanel.mouseClicked(mouseX, mouseY, button);
        }
        if (this.currentTab != Tab.STORAGE) {
            return false;
        }
        if (this.needsScrollbar() && this.isMouseOverScrollbar(mouseX, mouseY)) {
            this.isScrolling = true;
            this.updateScrollFromMouse(mouseY);
            return true;
        }
        if (this.filterDropdown != null && (result = this.filterDropdown.mouseClicked(mouseX, mouseY, button))) {
            return true;
        }
        int guiX = (this.field_22789 - this.field_2792) / 2;
        int guiY = (this.field_22790 - this.field_2779) / 2;
        int gridStartX = guiX + 8;
        int gridStartY = guiY + 18;
        int gridEndX = gridStartX + 162;
        int gridEndY = gridStartY + 90;
        boolean bl = clickInGrid = mouseX >= (double)gridStartX && mouseX < (double)gridEndX && mouseY >= (double)gridStartY && mouseY < (double)gridEndY;
        if (clickInGrid) {
            int scrollOffset = (int)(this.scrollProgress * (float)this.maxScrollRows);
            int startIndex = scrollOffset * 9;
            int endIndex = Math.min(startIndex + 45, this.networkItemsList.size());
            for (int i = startIndex; i < endIndex; ++i) {
                int relativeIndex = i - startIndex;
                int col = relativeIndex % 9;
                int slotX = guiX + 8 + col * 18;
                int row = relativeIndex / 9;
                int slotY = guiY + 18 + row * 18;
                if (!this.isMouseOverSlot(slotX, slotY, mouseX, mouseY)) continue;
                boolean isShiftDown = this.isShiftDown();
                boolean isCtrlDown = this.isControlDown();
                this.handleNetworkSlotClick(i, button, isShiftDown, isCtrlDown);
                return true;
            }
            if (!((StorageControllerScreenHandler)this.field_2797).method_34255().method_7960()) {
                this.handleEmptyAreaClick(button);
                return true;
            }
        }
        return false;
    }

    private boolean onMouseReleaseIntercept(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.isScrolling = false;
        }
        return false;
    }

    private boolean onMouseDragIntercept(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.isScrolling && this.needsScrollbar()) {
            this.updateScrollFromMouse(mouseY);
            return true;
        }
        return false;
    }

    private boolean onMouseScrollIntercept(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (this.currentTab == Tab.AUTO_PROCESSING && this.probeSelector != null) {
            if (this.probeSelector.isDropdownOpen()) {
                return this.probeSelector.mouseScrolled(mouseX, mouseY, horizontalAmount, verticalAmount);
            }
            if (this.probeSelector.mouseScrolled(mouseX, mouseY, horizontalAmount, verticalAmount)) {
                return true;
            }
            if (this.configPanel != null && this.configPanel.mouseScrolled(mouseX, mouseY, horizontalAmount, verticalAmount)) {
                return true;
            }
        }
        if (this.currentTab == Tab.STORAGE && this.filterDropdown != null && this.filterDropdown.isOpen() && this.filterDropdown.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount)) {
            return true;
        }
        if (this.currentTab == Tab.AUTO_PROCESSING && this.configPanel != null && this.configPanel.mouseScrolled(mouseX, mouseY, horizontalAmount, verticalAmount)) {
            return true;
        }
        if (this.currentTab == Tab.STORAGE && this.needsScrollbar()) {
            float scrollAmount = (float)(-verticalAmount / (double)(this.maxScrollRows + 1));
            this.scrollProgress = Math.max(0.0f, Math.min(1.0f, this.scrollProgress + scrollAmount));
            return true;
        }
        return false;
    }

    private void handleNetworkSlotClick(int slotIndex, int button, boolean isShift, boolean isCtrl) {
        Map.Entry<ItemVariant, Long> entry = this.networkItemsList.get(slotIndex);
        ItemVariant variant = entry.getKey();
        long itemCount = entry.getValue();
        class_1799 cursorStack = ((StorageControllerScreenHandler)this.field_2797).method_34255();
        if (!cursorStack.method_7960()) {
            ItemVariant cursorVariant = ItemVariant.of((class_1799)cursorStack);
            if (cursorVariant.equals((Object)variant)) {
                if (button == 0) {
                    ((StorageControllerScreenHandler)this.field_2797).requestDeposit(cursorStack, cursorStack.method_7947());
                    ((StorageControllerScreenHandler)this.field_2797).method_34254(class_1799.field_8037);
                } else if (button == 1) {
                    ((StorageControllerScreenHandler)this.field_2797).requestDeposit(cursorStack, 1);
                    cursorStack.method_7934(1);
                    if (cursorStack.method_7960()) {
                        ((StorageControllerScreenHandler)this.field_2797).method_34254(class_1799.field_8037);
                    } else {
                        ((StorageControllerScreenHandler)this.field_2797).method_34254(cursorStack);
                    }
                }
            } else {
                ((StorageControllerScreenHandler)this.field_2797).requestDeposit(cursorStack, cursorStack.method_7947());
                ((StorageControllerScreenHandler)this.field_2797).method_34254(class_1799.field_8037);
            }
            return;
        }
        int amount = isShift ? (int)Math.min(64L, itemCount) : (isCtrl && button == 0 ? (int)Math.min(16L, Math.max(1L, itemCount / 4L)) : (button == 0 ? (int)Math.min(64L, itemCount) : (button == 1 ? (int)Math.min(32L, Math.max(1L, itemCount / 2L)) : (int)Math.min((long)variant.getItem().method_7882(), itemCount))));
        if (!isShift) {
            class_1799 extracted = variant.toStack(amount);
            ((StorageControllerScreenHandler)this.field_2797).method_34254(extracted);
        }
        ((StorageControllerScreenHandler)this.field_2797).requestExtraction(variant, amount, isShift);
    }

    private void handleEmptyAreaClick(int button) {
        class_1799 cursorStack = ((StorageControllerScreenHandler)this.field_2797).method_34255();
        if (cursorStack.method_7960()) {
            return;
        }
        if (button == 0) {
            ((StorageControllerScreenHandler)this.field_2797).requestDeposit(cursorStack, cursorStack.method_7947());
            ((StorageControllerScreenHandler)this.field_2797).method_34254(class_1799.field_8037);
        } else if (button == 1) {
            ((StorageControllerScreenHandler)this.field_2797).requestDeposit(cursorStack, 1);
            cursorStack.method_7934(1);
            if (cursorStack.method_7960()) {
                ((StorageControllerScreenHandler)this.field_2797).method_34254(class_1799.field_8037);
            } else {
                ((StorageControllerScreenHandler)this.field_2797).method_34254(cursorStack);
            }
        }
    }

    private void updateScrollFromMouse(double mouseY) {
        int y = (this.field_22790 - this.field_2779) / 2;
        int barY = y + 18;
        int handleHeight = 15;
        int maxHandleOffset = 90 - handleHeight;
        float relativeY = (float)(mouseY - (double)barY - (double)handleHeight / 2.0);
        this.scrollProgress = Math.max(0.0f, Math.min(1.0f, relativeY / (float)maxHandleOffset));
    }

    private String formatAmount(long amount) {
        if (amount < 1000L && amount >= 0L) {
            return AMOUNT_CACHE[(int)amount];
        }
        if (amount >= 1000000000L) {
            return amount / 1000000000L + "B";
        }
        if (amount >= 1000000L) {
            return amount / 1000000L + "M";
        }
        if (amount >= 10000L) {
            return amount / 1000L + "K";
        }
        return String.valueOf(amount);
    }

    private boolean isMouseOverSlot(int slotX, int slotY, double mouseX, double mouseY) {
        return mouseX >= (double)slotX && mouseX < (double)(slotX + 16) && mouseY >= (double)slotY && mouseY < (double)(slotY + 16);
    }

    private boolean needsScrollbar() {
        return this.maxScrollRows > 0;
    }

    private boolean isMouseOverScrollbar(double mouseX, double mouseY) {
        int x = (this.field_22789 - this.field_2792) / 2;
        int y = (this.field_22790 - this.field_2779) / 2;
        int barX = x + 174;
        int barY = y + 18;
        return mouseX >= (double)barX && mouseX < (double)(barX + 14) && mouseY >= (double)barY && mouseY < (double)(barY + 90);
    }

    private boolean isControlDown() {
        long handle = class_310.method_1551().method_22683().method_4490();
        return GLFW.glfwGetKey((long)handle, (int)341) == 1 || GLFW.glfwGetKey((long)handle, (int)345) == 1;
    }

    private boolean isShiftDown() {
        long handle = class_310.method_1551().method_22683().method_4490();
        return GLFW.glfwGetKey((long)handle, (int)340) == 1 || GLFW.glfwGetKey((long)handle, (int)344) == 1;
    }

    protected void method_2388(class_332 context, int mouseX, int mouseY) {
        if (this.currentTab == Tab.STORAGE) {
            context.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)"Controller"), this.field_25267, this.field_25268, -12566464, false);
            context.method_51439(this.field_22793, this.field_29347, this.field_25269, this.field_25270, -12566464, false);
            if (((StorageControllerScreenHandler)this.field_2797).controller != null) {
                int free = ((StorageControllerScreenHandler)this.field_2797).controller.calculateTotalFreeSlots();
                int total = ((StorageControllerScreenHandler)this.field_2797).controller.calculateTotalCapacity();
                if (total > 0) {
                    float percentFree = (float)free / (float)total * 100.0f;
                    int color = percentFree > 50.0f ? 0x55FF55 : (percentFree > 25.0f ? 0xFFFF55 : (percentFree > 10.0f ? 0xFFAA00 : 0xFF5555));
                    String capacityText = free + "/" + total;
                    int textWidth = this.field_22793.method_1727(capacityText);
                    int textX = this.field_2792 - textWidth - 26;
                    int textY = 6;
                    context.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)capacityText), textX, textY, 0xFF000000 | color, false);
                }
            }
        } else {
            context.method_51439(this.field_22793, this.field_29347, this.field_25269, this.field_25270, -12566464, false);
        }
    }

    protected void method_2380(class_332 context, int mouseX, int mouseY) {
        super.method_2380(context, mouseX, mouseY);
        if (this.currentTab != Tab.STORAGE) {
            return;
        }
        if (this.field_2787 != null && this.field_2787.method_7681()) {
            return;
        }
        int guiX = (this.field_22789 - this.field_2792) / 2;
        int guiY = (this.field_22790 - this.field_2779) / 2;
        int scrollOffset = (int)(this.scrollProgress * (float)this.maxScrollRows);
        int startIndex = scrollOffset * 9;
        int endIndex = Math.min(startIndex + 45, this.networkItemsList.size());
        for (int i = startIndex; i < endIndex; ++i) {
            int relativeIndex = i - startIndex;
            int col = relativeIndex % 9;
            int slotX = guiX + 8 + col * 18;
            int row = relativeIndex / 9;
            int slotY = guiY + 18 + row * 18;
            if (!this.isMouseOverSlot(slotX, slotY, mouseX, mouseY)) continue;
            Map.Entry<ItemVariant, Long> entry = this.networkItemsList.get(i);
            ItemVariant variant = entry.getKey();
            long amount = entry.getValue();
            if (this.cachedTooltip == null || !variant.equals((Object)this.cachedTooltipItem) || amount != this.cachedTooltipAmount) {
                this.cachedTooltip = new ArrayList<class_2561>(7);
                this.cachedTooltip.add(variant.getItem().method_63680());
                this.cachedTooltip.add((class_2561)class_2561.method_43470((String)("\u00a77Stored: \u00a7f" + String.format("%,d", amount))));
                this.cachedTooltip.add((class_2561)class_2561.method_43470((String)""));
                this.cachedTooltip.add((class_2561)class_2561.method_43470((String)"\u00a78Left-Click: \u00a77Take stack (64)"));
                this.cachedTooltip.add((class_2561)class_2561.method_43470((String)"\u00a78Right-Click: \u00a77Take half (32)"));
                this.cachedTooltip.add((class_2561)class_2561.method_43470((String)"\u00a78Ctrl+Left: \u00a77Take quarter (16)"));
                this.cachedTooltip.add((class_2561)class_2561.method_43470((String)"\u00a78Shift-Click: \u00a77To inventory"));
                this.cachedTooltipItem = variant;
                this.cachedTooltipAmount = amount;
            }
            context.method_51434(this.field_22793, this.cachedTooltip, mouseX, mouseY);
            break;
        }
    }

    static {
        for (int i = 0; i < 1000; ++i) {
            StorageControllerScreen.AMOUNT_CACHE[i] = String.valueOf(i);
        }
    }

    private static enum Tab {
        STORAGE("Storage"),
        AUTO_PROCESSING("Auto-Processing");

        private final String name;

        private Tab(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

