/*
 * Decompiled with CFR 0.152.
 */
package net.shaddii.smartsorter.screen;

import java.util.HashMap;
import java.util.Map;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.shaddii.smartsorter.SmartSorter;
import net.shaddii.smartsorter.blockentity.StorageControllerBlockEntity;
import net.shaddii.smartsorter.network.ProbeConfigBatchPayload;
import net.shaddii.smartsorter.network.StorageControllerSyncPacket;
import net.shaddii.smartsorter.util.Category;
import net.shaddii.smartsorter.util.ProcessProbeConfig;
import net.shaddii.smartsorter.util.SortMode;

public class StorageControllerScreenHandler
extends class_1703 {
    public final StorageControllerBlockEntity controller;
    private Map<ItemVariant, Long> clientNetworkItems = new HashMap<ItemVariant, Long>();
    private Map<class_2338, ProcessProbeConfig> clientProbeConfigs = new HashMap<class_2338, ProcessProbeConfig>();
    private SortMode sortMode = SortMode.NAME;
    private Category filterCategory = Category.ALL;
    private static final int PLAYER_INV_Y = 120;
    private static final int HOTBAR_Y = 178;
    private static final int PLAYER_INVENTORY_SIZE = 27;
    private static final int HOTBAR_SIZE = 9;
    private static final int TOTAL_SLOTS = 36;
    private boolean pendingSync = false;
    private long lastSyncTime = 0L;
    private static final long SYNC_BATCH_DELAY_MS = 50L;
    private int clientStoredXp = 0;

    public StorageControllerScreenHandler(int syncId, class_1661 inv, StorageControllerBlockEntity controller) {
        super(SmartSorter.STORAGE_CONTROLLER_SCREEN_HANDLER, syncId);
        this.controller = controller;
        this.addPlayerInventory(inv);
        this.addPlayerHotbar(inv);
        class_1657 class_16572 = inv.field_7546;
        if (class_16572 instanceof class_3222) {
            class_3222 sp = (class_3222)class_16572;
            this.sendNetworkUpdate(sp);
        }
    }

    public StorageControllerScreenHandler(int syncId, class_1661 inv) {
        super(SmartSorter.STORAGE_CONTROLLER_SCREEN_HANDLER, syncId);
        this.controller = null;
        this.addPlayerInventory(inv);
        this.addPlayerHotbar(inv);
    }

    public void updateStoredXp(int xp) {
        this.clientStoredXp = xp;
    }

    public int getStoredExperience() {
        if (this.controller != null) {
            return this.controller.getStoredExperience();
        }
        return this.clientStoredXp;
    }

    private void sendProbeConfigsInBatches(class_3222 player, Map<class_2338, ProcessProbeConfig> configs) {
        HashMap<class_2338, ProcessProbeConfig> batch = new HashMap<class_2338, ProcessProbeConfig>();
        int count = 0;
        for (Map.Entry<class_2338, ProcessProbeConfig> entry : configs.entrySet()) {
            batch.put(entry.getKey(), entry.getValue());
            if (++count < 5) continue;
            ServerPlayNetworking.send((class_3222)player, (class_8710)new ProbeConfigBatchPayload(new HashMap<class_2338, ProcessProbeConfig>(batch)));
            batch.clear();
            count = 0;
        }
        if (!batch.isEmpty()) {
            ServerPlayNetworking.send((class_3222)player, (class_8710)new ProbeConfigBatchPayload(new HashMap<class_2338, ProcessProbeConfig>(batch)));
        }
    }

    public void sendNetworkUpdate(class_3222 player) {
        if (this.controller != null) {
            this.controller.updateNetworkCache();
            Map<ItemVariant, Long> items = this.controller.getNetworkItems();
            int xp = this.controller.getStoredExperience();
            Map<class_2338, ProcessProbeConfig> configs = this.controller.getProcessProbeConfigs();
            StorageControllerSyncPacket.send(player, items, xp, new HashMap<class_2338, ProcessProbeConfig>());
            if (!configs.isEmpty()) {
                this.sendProbeConfigsInBatches(player, configs);
            }
        }
    }

    public void updateNetworkItems(Map<ItemVariant, Long> items) {
        this.clientNetworkItems = items;
    }

    public Map<ItemVariant, Long> getNetworkItems() {
        if (this.controller != null) {
            return this.controller.getNetworkItems();
        }
        return new HashMap<ItemVariant, Long>(this.clientNetworkItems);
    }

    public void requestSync() {
        if (this.controller == null) {
            ClientPlayNetworking.send((class_8710)new SyncRequestPayload());
        }
    }

    public void setSortMode(SortMode mode) {
        this.sortMode = mode;
        class_1657 player = this.getPlayerFromSlots();
        if (player instanceof class_3222) {
            class_3222 sp = (class_3222)player;
            this.sendNetworkUpdate(sp);
        }
    }

    public SortMode getSortMode() {
        return this.sortMode;
    }

    public void setFilterCategory(Category category) {
        this.filterCategory = category;
        class_1657 player = this.getPlayerFromSlots();
        if (player instanceof class_3222) {
            class_3222 sp = (class_3222)player;
            this.sendNetworkUpdate(sp);
        }
    }

    public Category getFilterCategory() {
        return this.filterCategory;
    }

    public void requestExtraction(ItemVariant variant, int amount, boolean toInventory) {
        if (this.controller != null) {
            class_1657 player = this.getPlayerFromSlots();
            if (player != null) {
                this.extractItem(variant, amount, toInventory, player);
            }
            if (player instanceof class_3222) {
                class_3222 sp = (class_3222)player;
                this.sendNetworkUpdate(sp);
            }
        } else {
            ClientPlayNetworking.send((class_8710)new ExtractionRequestPayload(variant, amount, toInventory));
        }
    }

    public void requestDeposit(class_1799 stack, int amount) {
        if (this.controller != null) {
            class_1657 player = this.getPlayerFromSlots();
            if (player != null) {
                this.depositItem(stack, amount, player);
            }
            if (player instanceof class_3222) {
                class_3222 sp = (class_3222)player;
                this.sendNetworkUpdate(sp);
            }
        } else {
            ClientPlayNetworking.send((class_8710)new DepositRequestPayload(ItemVariant.of((class_1799)stack), amount));
        }
    }

    public void depositItem(class_1799 stack, int amount, class_1657 player) {
        if (this.controller == null || player == null || stack.method_7960()) {
            return;
        }
        class_1799 cursor = this.method_34255();
        if (cursor.method_7960()) {
            return;
        }
        class_1799 toDeposit = cursor.method_7972();
        toDeposit.method_7939(Math.min(amount, cursor.method_7947()));
        class_1799 remaining = this.controller.insertItem(toDeposit);
        int deposited = toDeposit.method_7947() - (remaining.method_7960() ? 0 : remaining.method_7947());
        if (deposited > 0) {
            cursor.method_7934(deposited);
            if (cursor.method_7960()) {
                this.method_34254(class_1799.field_8037);
            } else {
                this.method_34254(cursor);
            }
            if (player instanceof class_3222) {
                class_3222 sp = (class_3222)player;
                this.requestBatchedSync();
                player.field_7498.method_34254(this.method_34255());
            }
        }
    }

    private void requestBatchedSync() {
        this.pendingSync = true;
        this.lastSyncTime = System.currentTimeMillis();
    }

    public void processPendingSync(class_3222 player) {
        if (this.pendingSync && System.currentTimeMillis() - this.lastSyncTime >= 50L) {
            this.sendNetworkUpdate(player);
            this.pendingSync = false;
        }
    }

    public void extractItem(ItemVariant variant, int amount, boolean toInventory, class_1657 player) {
        if (this.controller == null || player == null) {
            return;
        }
        class_1799 extracted = this.controller.extractItem(variant, amount);
        if (extracted.method_7960()) {
            return;
        }
        if (toInventory) {
            int beforeCount = extracted.method_7947();
            player.method_31548().method_7394(extracted);
            int afterCount = extracted.method_7947();
            if (afterCount > 0) {
                player.method_7328(extracted, false);
            }
        } else {
            class_1799 cursor = this.method_34255();
            if (cursor.method_7960()) {
                this.method_34254(extracted);
            } else if (class_1799.method_31577((class_1799)cursor, (class_1799)extracted)) {
                class_1799 remaining;
                int maxStack = Math.min(cursor.method_7914(), 64);
                int canAdd = maxStack - cursor.method_7947();
                if (canAdd > 0) {
                    int toAdd = Math.min(canAdd, extracted.method_7947());
                    cursor.method_7933(toAdd);
                    extracted.method_7934(toAdd);
                    this.method_34254(cursor);
                }
                if (!extracted.method_7960() && !(remaining = this.controller.insertItem(extracted)).method_7960()) {
                    player.method_7328(remaining, false);
                }
            } else if (!player.method_31548().method_7394(extracted)) {
                player.method_7328(extracted, false);
            }
        }
        if (player instanceof class_3222) {
            class_3222 sp = (class_3222)player;
            this.requestBatchedSync();
            player.field_7498.method_34254(this.method_34255());
        }
    }

    private class_1661 getFirstPlayerInventory() {
        for (class_1735 s : this.field_7761) {
            class_1263 class_12632 = s.field_7871;
            if (!(class_12632 instanceof class_1661)) continue;
            class_1661 pi = (class_1661)class_12632;
            return pi;
        }
        return null;
    }

    public void updateProbeStats(class_2338 position, int itemsProcessed) {
        if (this.controller != null) {
            ProcessProbeConfig config = this.controller.getProbeConfig(position);
            if (config != null) {
                config.itemsProcessed = itemsProcessed;
            }
        } else {
            ProcessProbeConfig config = this.clientProbeConfigs.get(position);
            if (config != null) {
                config.itemsProcessed = itemsProcessed;
                this.clientProbeConfigs.put(position, config);
            }
        }
    }

    private class_1657 getPlayerFromSlots() {
        class_1661 pi = this.getFirstPlayerInventory();
        return pi != null ? pi.field_7546 : null;
    }

    private void addPlayerInventory(class_1661 inv) {
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.method_7621(new class_1735((class_1263)inv, col + row * 9 + 9, 8 + col * 18, 120 + row * 18));
            }
        }
    }

    private void addPlayerHotbar(class_1661 inv) {
        for (int col = 0; col < 9; ++col) {
            this.method_7621(new class_1735((class_1263)inv, col, 8 + col * 18, 178));
        }
    }

    public class_1799 method_7601(class_1657 player, int slotIndex) {
        if (slotIndex < 0 || slotIndex >= this.field_7761.size()) {
            return class_1799.field_8037;
        }
        class_1735 slot = (class_1735)this.field_7761.get(slotIndex);
        if (slot == null || !slot.method_7681()) {
            return class_1799.field_8037;
        }
        class_1799 stackInSlot = slot.method_7677();
        class_1799 original = stackInSlot.method_7972();
        if (slotIndex >= 0 && slotIndex < 36) {
            if (this.controller == null) {
                return class_1799.field_8037;
            }
            class_1799 remaining = this.controller.insertItem(stackInSlot.method_7972());
            int inserted = stackInSlot.method_7947() - (remaining.method_7960() ? 0 : remaining.method_7947());
            if (inserted > 0) {
                slot.method_53512(remaining);
                slot.method_7668();
                if (player instanceof class_3222) {
                    class_3222 sp = (class_3222)player;
                    this.sendNetworkUpdate(sp);
                }
                return original;
            }
        }
        return class_1799.field_8037;
    }

    public void method_7593(int index, int button, class_1713 type, class_1657 player) {
        if (index < 0 || index >= this.field_7761.size()) {
            super.method_7593(index, button, type, player);
            if (this.controller != null && player instanceof class_3222) {
                class_3222 sp = (class_3222)player;
                this.sendNetworkUpdate(sp);
            }
            return;
        }
        super.method_7593(index, button, type, player);
        if (this.controller != null && player instanceof class_3222) {
            class_3222 sp = (class_3222)player;
            this.sendNetworkUpdate(sp);
        }
    }

    public boolean method_7597(class_1657 player) {
        return this.controller == null || this.controller.method_5443(player);
    }

    public Map<class_2338, ProcessProbeConfig> getProcessProbeConfigs() {
        if (this.controller != null) {
            return this.controller.getProcessProbeConfigs();
        }
        return new HashMap<class_2338, ProcessProbeConfig>(this.clientProbeConfigs);
    }

    public void updateProbeConfigs(Map<class_2338, ProcessProbeConfig> configs) {
        this.clientProbeConfigs.putAll(configs);
    }

    public void clearProbeConfigs() {
        this.clientProbeConfigs.clear();
    }

    public record SyncRequestPayload() implements class_8710
    {
        public static final class_8710.class_9154<SyncRequestPayload> ID = new class_8710.class_9154(class_2960.method_60655((String)"smartsorter", (String)"sync_request"));
        public static final class_9139<class_9129, SyncRequestPayload> CODEC = class_9139.method_56438((b, p) -> {}, b -> new SyncRequestPayload());

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return ID;
        }
    }

    public record ExtractionRequestPayload(ItemVariant variant, int amount, boolean toInventory) implements class_8710
    {
        public static final class_8710.class_9154<ExtractionRequestPayload> ID = new class_8710.class_9154(class_2960.method_60655((String)"smartsorter", (String)"extraction_request"));
        public static final class_9139<class_9129, ExtractionRequestPayload> CODEC = class_9139.method_56438((value, buf) -> ExtractionRequestPayload.write(buf, value), buf -> ExtractionRequestPayload.read(buf));

        public static void write(class_9129 buf, ExtractionRequestPayload payload) {
            class_1799.field_48349.encode((Object)buf, (Object)payload.variant().toStack(1));
            buf.method_10804(payload.amount());
            buf.method_52964(payload.toInventory());
        }

        public static ExtractionRequestPayload read(class_9129 buf) {
            class_1799 s = (class_1799)class_1799.field_48349.decode((Object)buf);
            ItemVariant v = ItemVariant.of((class_1799)s);
            int amt = buf.method_10816();
            boolean inv = buf.readBoolean();
            return new ExtractionRequestPayload(v, amt, inv);
        }

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return ID;
        }
    }

    public record DepositRequestPayload(ItemVariant variant, int amount) implements class_8710
    {
        public static final class_8710.class_9154<DepositRequestPayload> ID = new class_8710.class_9154(class_2960.method_60655((String)"smartsorter", (String)"deposit_request"));
        public static final class_9139<class_9129, DepositRequestPayload> CODEC = class_9139.method_56438((value, buf) -> DepositRequestPayload.write(buf, value), buf -> DepositRequestPayload.read(buf));

        public static void write(class_9129 buf, DepositRequestPayload payload) {
            class_1799.field_48349.encode((Object)buf, (Object)payload.variant().toStack(1));
            buf.method_10804(payload.amount());
        }

        public static DepositRequestPayload read(class_9129 buf) {
            class_1799 s = (class_1799)class_1799.field_48349.decode((Object)buf);
            return new DepositRequestPayload(ItemVariant.of((class_1799)s), buf.method_10816());
        }

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return ID;
        }
    }
}

