/*
 * Decompiled with CFR 0.152.
 */
package net.shaddii.smartsorter.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.minecraft.class_1263;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

public final class SortUtil {
    private static final Map<class_1792, Set<class_6862<class_1792>>> TAG_CACHE = new HashMap<class_1792, Set<class_6862<class_1792>>>();
    private static final int MAX_TAG_CACHE_SIZE = 1000;

    private SortUtil() {
    }

    public static boolean accepts(Storage<ItemVariant> target, ItemVariant incoming, boolean ignoreComponents, boolean useTags, boolean requireAllTags) {
        if (SortUtil.acceptsByContents(target, incoming, ignoreComponents)) {
            return true;
        }
        if (useTags) {
            return SortUtil.acceptsByTags(target, incoming, requireAllTags);
        }
        return false;
    }

    static boolean acceptsByContents(Storage<ItemVariant> target, ItemVariant incoming, boolean ignoreComponents) {
        for (StorageView view : target) {
            ItemVariant present;
            if (view.getAmount() == 0L || (present = (ItemVariant)view.getResource()).isBlank() || !(ignoreComponents ? present.getItem() == incoming.getItem() : present.equals((Object)incoming))) continue;
            return true;
        }
        return false;
    }

    static boolean acceptsByTags(Storage<ItemVariant> target, ItemVariant incoming, boolean requireAll) {
        Set<class_6862<class_1792>> inc = SortUtil.tagsOf(incoming.getItem());
        if (inc.isEmpty()) {
            return false;
        }
        HashSet<class_6862<class_1792>> chest = new HashSet<class_6862<class_1792>>();
        for (StorageView view : target) {
            ItemVariant present;
            if (view.getAmount() == 0L || (present = (ItemVariant)view.getResource()).isBlank()) continue;
            chest.addAll(SortUtil.tagsOf(present.getItem()));
        }
        if (chest.isEmpty()) {
            return false;
        }
        return requireAll ? inc.stream().allMatch(chest::contains) : inc.stream().anyMatch(chest::contains);
    }

    public static boolean acceptsByInventoryTags(class_1263 inv, ItemVariant incoming, boolean requireAll) {
        Set<class_6862<class_1792>> incomingTags = SortUtil.tagsOf(incoming.getItem());
        if (incomingTags.isEmpty()) {
            return false;
        }
        HashSet<class_6862<class_1792>> chestTags = new HashSet<class_6862<class_1792>>();
        for (int i = 0; i < inv.method_5439(); ++i) {
            class_1799 stack = inv.method_5438(i);
            if (stack.method_7960()) continue;
            chestTags.addAll(SortUtil.tagsOf(stack.method_7909()));
        }
        if (chestTags.isEmpty()) {
            return false;
        }
        if (requireAll) {
            return chestTags.containsAll(incomingTags);
        }
        for (class_6862<class_1792> tag : incomingTags) {
            if (!chestTags.contains(tag)) continue;
            return true;
        }
        return false;
    }

    public static void clearTagCache() {
        if (TAG_CACHE.size() > 1000) {
            TAG_CACHE.clear();
        }
    }

    static Set<class_6862<class_1792>> tagsOf(class_1792 item) {
        return TAG_CACHE.computeIfAbsent(item, i -> {
            class_6880 entry = class_7923.field_41178.method_47983(i);
            HashSet tags = new HashSet();
            entry.method_40228().forEach(tags::add);
            return tags;
        });
    }
}

