/*
 * Decompiled with CFR 0.152.
 */
package net.shaddii.smartsorter.widget;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_11905;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_11910;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_4185;
import net.minecraft.class_8710;
import net.shaddii.smartsorter.network.ProbeConfigUpdatePayload;
import net.shaddii.smartsorter.util.ProcessProbeConfig;
import net.shaddii.smartsorter.widget.DropdownWidget;

public class ProbeSelectorWidget {
    private final int x;
    private final int y;
    private final int width;
    private final int height;
    private final class_327 textRenderer;
    private final List<ProcessProbeConfig> probes = new ArrayList<ProcessProbeConfig>();
    private DropdownWidget dropdown;
    private class_4185 editButton;
    private class_342 renameField;
    private int selectedIndex = 0;
    private boolean isRenaming = false;
    private Consumer<ProcessProbeConfig> onConfigUpdate;

    public ProbeSelectorWidget(int x, int y, int width, int height, class_327 textRenderer) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.textRenderer = textRenderer;
        this.initWidgets();
    }

    public boolean isDropdownOpen() {
        return this.dropdown != null && this.dropdown.isOpen();
    }

    public void renderDropdownIfOpen(class_332 context, int mouseX, int mouseY) {
        if (this.dropdown != null && this.dropdown.isOpen()) {
            this.dropdown.renderDropdown(context, mouseX, mouseY);
        }
    }

    private void initWidgets() {
        int dropdownWidth = this.width - 25;
        this.dropdown = new DropdownWidget(this.x, this.y, dropdownWidth, this.height, (class_2561)class_2561.method_43470((String)""));
        this.editButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u270f"), btn -> this.startRenaming()).method_46434(this.x + dropdownWidth + 2, this.y, 20, this.height).method_46431();
        this.renameField = new class_342(this.textRenderer, this.x, this.y, dropdownWidth, this.height, (class_2561)class_2561.method_43470((String)""));
        this.renameField.method_1880(32);
        this.renameField.method_1862(false);
        this.renameField.method_1858(true);
    }

    public void updateProbes(Map<class_2338, ProcessProbeConfig> probeConfigs) {
        this.probes.clear();
        this.probes.addAll(probeConfigs.values());
        this.probes.sort((a, b) -> {
            if (a.position.method_10263() != b.position.method_10263()) {
                return Integer.compare(a.position.method_10263(), b.position.method_10263());
            }
            if (a.position.method_10264() != b.position.method_10264()) {
                return Integer.compare(a.position.method_10264(), b.position.method_10264());
            }
            return Integer.compare(a.position.method_10260(), b.position.method_10260());
        });
        this.dropdown.clearEntries();
        if (this.probes.isEmpty()) {
            this.dropdown.addEntry("none", "No Process Probes");
            this.dropdown.setSelectedIndex(0);
            this.selectedIndex = 0;
        } else {
            for (int i = 0; i < this.probes.size(); ++i) {
                ProcessProbeConfig config = this.probes.get(i);
                Object displayName = config.getDisplayName();
                displayName = !config.isRecipeFilterValid() ? "\u00a7c\u26a0 \u00a7r" + (String)displayName + " \u00a77(Config Error)" : (!config.enabled ? "\u00a7c\u2717 \u00a7r" + (String)displayName : "\u00a7a\u2713 \u00a7r" + (String)displayName);
                this.dropdown.addEntry((String)displayName, (String)displayName);
            }
            if (this.selectedIndex >= this.probes.size()) {
                this.selectedIndex = 0;
            }
            this.dropdown.setSelectedIndex(this.selectedIndex);
        }
    }

    public void updateProbeStats(class_2338 position, int itemsProcessed) {
        for (ProcessProbeConfig probe : this.probes) {
            if (!probe.position.equals((Object)position)) continue;
            probe.itemsProcessed = itemsProcessed;
            break;
        }
    }

    public void setSelectedIndex(int index) {
        this.selectedIndex = index;
        if (this.dropdown != null) {
            this.dropdown.setSelectedIndex(index);
        }
    }

    private void startRenaming() {
        if (this.probes.isEmpty() || this.isRenaming) {
            return;
        }
        this.isRenaming = true;
        ProcessProbeConfig config = this.probes.get(this.selectedIndex);
        this.renameField.method_1852(config.customName != null ? config.customName : "");
        this.renameField.method_1862(true);
        this.renameField.method_25365(true);
        this.dropdown.field_22764 = false;
    }

    public void finishRenaming() {
        if (!this.isRenaming) {
            return;
        }
        this.isRenaming = false;
        String newName = this.renameField.method_1882().trim();
        ProcessProbeConfig config = this.probes.get(this.selectedIndex);
        if (!newName.isEmpty() || config.customName != null) {
            config.customName = newName.isEmpty() ? null : newName;
            ClientPlayNetworking.send((class_8710)new ProbeConfigUpdatePayload(config.position, config.customName, config.enabled, config.recipeFilter, config.fuelFilter));
            if (this.onConfigUpdate != null) {
                this.onConfigUpdate.accept(config);
            }
            this.updateProbesFromList();
        }
        this.renameField.method_1862(false);
        this.renameField.method_25365(false);
        this.dropdown.field_22764 = true;
    }

    private void updateProbesFromList() {
        this.dropdown.clearEntries();
        for (int i = 0; i < this.probes.size(); ++i) {
            ProcessProbeConfig config = this.probes.get(i);
            Object displayName = config.getDisplayName();
            displayName = !config.enabled ? "\u00a7c\u2717 \u00a7r" + (String)displayName : "\u00a7a\u2713 \u00a7r" + (String)displayName;
            this.dropdown.addEntry((String)displayName, (String)displayName);
        }
        this.dropdown.setSelectedIndex(this.selectedIndex);
    }

    public void render(class_332 context, int mouseX, int mouseY, float delta) {
        if (this.isRenaming) {
            this.renameField.method_25394(context, mouseX, mouseY, delta);
        } else {
            this.dropdown.method_25394(context, mouseX, mouseY, delta);
        }
        this.editButton.method_25394(context, mouseX, mouseY, delta);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        class_11910 mouseInput = new class_11910(button, 0);
        class_11909 click = new class_11909(mouseX, mouseY, mouseInput);
        if (this.isRenaming) {
            if (this.renameField.method_25402(click, false)) {
                return true;
            }
            this.finishRenaming();
            return true;
        }
        if (this.editButton.method_25402(click, false)) {
            return true;
        }
        if (this.dropdown.mouseClicked(mouseX, mouseY, button)) {
            this.selectedIndex = this.dropdown.getSelectedIndex();
            return true;
        }
        return false;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.isRenaming) {
            class_11908 input = new class_11908(keyCode, scanCode, modifiers);
            if (keyCode == 257 || keyCode == 335) {
                this.finishRenaming();
                return true;
            }
            if (keyCode == 256) {
                this.renameField.method_1852("");
                this.finishRenaming();
                return true;
            }
            this.renameField.method_25404(input);
            return true;
        }
        return false;
    }

    public boolean charTyped(char chr, int modifiers) {
        if (this.isRenaming) {
            class_11905 input = new class_11905((int)chr, modifiers);
            return this.renameField.method_25400(input);
        }
        return false;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (this.dropdown != null && this.dropdown.isOpen()) {
            return this.dropdown.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
        }
        return false;
    }

    public ProcessProbeConfig getSelectedProbe() {
        if (this.probes.isEmpty() || this.selectedIndex >= this.probes.size()) {
            return null;
        }
        return this.probes.get(this.selectedIndex);
    }

    public void setOnConfigUpdate(Consumer<ProcessProbeConfig> callback) {
        this.onConfigUpdate = callback;
    }

    public void setOnSelectionChange(Consumer<ProcessProbeConfig> callback) {
        this.dropdown.setOnSelect(index -> {
            this.selectedIndex = index;
            if (callback != null && !this.probes.isEmpty() && index < this.probes.size()) {
                callback.accept(this.probes.get((int)index));
            }
        });
    }
}

