/*
 * Decompiled with CFR 0.152.
 */
package net.shaddii.smartsorter.util;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.shaddii.smartsorter.util.FuelFilterMode;
import net.shaddii.smartsorter.util.RecipeFilterMode;

public class ProcessProbeConfig {
    public class_2338 position;
    public String customName = null;
    public String machineType;
    public boolean enabled = true;
    public RecipeFilterMode recipeFilter = RecipeFilterMode.ORES_ONLY;
    public FuelFilterMode fuelFilter = FuelFilterMode.COAL_ONLY;
    public int itemsProcessed = 0;
    public Set<String> customRecipeWhitelist = new HashSet<String>();
    public Set<String> customFuelWhitelist = new HashSet<String>();
    public int index = 0;

    public ProcessProbeConfig() {
    }

    public ProcessProbeConfig(class_2338 position, String machineType) {
        this.position = position;
        this.machineType = machineType;
    }

    public boolean isRecipeFilterValid() {
        String normalizedType;
        if (this.machineType == null || this.machineType.equals("Unknown")) {
            return true;
        }
        return switch (normalizedType = this.machineType.toLowerCase().replace("minecraft:", "")) {
            case "blast_furnace" -> {
                if (this.recipeFilter != RecipeFilterMode.FOOD_ONLY) {
                    yield true;
                }
                yield false;
            }
            case "smoker" -> {
                if (this.recipeFilter != RecipeFilterMode.ORES_ONLY && this.recipeFilter != RecipeFilterMode.RAW_METALS_ONLY) {
                    yield true;
                }
                yield false;
            }
            default -> true;
        };
    }

    public String getValidationError() {
        if (this.isRecipeFilterValid()) {
            return null;
        }
        String normalizedType = this.machineType.toLowerCase();
        if (normalizedType.contains(":")) {
            normalizedType = normalizedType.substring(normalizedType.indexOf(58) + 1);
        }
        return switch (normalizedType) {
            case "blast_furnace" -> "Blast Furnace can only smelt ores and metal tools/armor";
            case "smoker" -> "Smoker can only cook food items";
            default -> "Invalid recipe filter for this machine type";
        };
    }

    public RecipeFilterMode[] getValidRecipeFilters() {
        RecipeFilterMode[] recipeFilterModeArray;
        String normalizedType;
        if (this.machineType == null) {
            return RecipeFilterMode.values();
        }
        switch (normalizedType = this.machineType.toLowerCase().replace("minecraft:", "")) {
            case "blast_furnace": {
                RecipeFilterMode[] recipeFilterModeArray2 = new RecipeFilterMode[5];
                recipeFilterModeArray2[0] = RecipeFilterMode.ALL_SMELTABLE;
                recipeFilterModeArray2[1] = RecipeFilterMode.ORES_ONLY;
                recipeFilterModeArray2[2] = RecipeFilterMode.RAW_METALS_ONLY;
                recipeFilterModeArray2[3] = RecipeFilterMode.NO_WOOD;
                recipeFilterModeArray = recipeFilterModeArray2;
                recipeFilterModeArray2[4] = RecipeFilterMode.CUSTOM;
                break;
            }
            case "smoker": {
                RecipeFilterMode[] recipeFilterModeArray3 = new RecipeFilterMode[4];
                recipeFilterModeArray3[0] = RecipeFilterMode.ALL_SMELTABLE;
                recipeFilterModeArray3[1] = RecipeFilterMode.FOOD_ONLY;
                recipeFilterModeArray3[2] = RecipeFilterMode.NO_WOOD;
                recipeFilterModeArray = recipeFilterModeArray3;
                recipeFilterModeArray3[3] = RecipeFilterMode.CUSTOM;
                break;
            }
            default: {
                recipeFilterModeArray = RecipeFilterMode.values();
            }
        }
        return recipeFilterModeArray;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public String getDisplayName() {
        if (this.customName != null && !this.customName.isEmpty()) {
            return this.customName;
        }
        Object type = this.machineType;
        if (((String)type).contains(":")) {
            type = ((String)type).substring(((String)type).indexOf(58) + 1);
        }
        if (!((String)type).isEmpty()) {
            type = ((String)type).substring(0, 1).toUpperCase() + ((String)type).substring(1).toLowerCase();
        }
        return (String)type + " #" + (this.index + 1);
    }

    public void resetStats() {
        this.itemsProcessed = 0;
    }

    public class_2487 toNbt() {
        class_2487 nbt = new class_2487();
        nbt.method_10544("pos", this.position.method_10063());
        if (this.customName != null) {
            nbt.method_10582("customName", this.customName);
        }
        nbt.method_10582("machineType", this.machineType);
        nbt.method_10556("enabled", this.enabled);
        nbt.method_10582("recipeFilter", this.recipeFilter.asString());
        nbt.method_10582("fuelFilter", this.fuelFilter.asString());
        nbt.method_10569("itemsProcessed", this.itemsProcessed);
        nbt.method_10569("index", this.index);
        class_2499 recipeList = new class_2499();
        for (String itemId : this.customRecipeWhitelist) {
            recipeList.add((Object)class_2519.method_23256((String)itemId));
        }
        nbt.method_10566("customRecipes", (class_2520)recipeList);
        class_2499 fuelList = new class_2499();
        for (String itemId : this.customFuelWhitelist) {
            fuelList.add((Object)class_2519.method_23256((String)itemId));
        }
        nbt.method_10566("customFuels", (class_2520)fuelList);
        return nbt;
    }

    public static ProcessProbeConfig fromNbt(class_2487 nbt) {
        ProcessProbeConfig config = new ProcessProbeConfig();
        if (nbt.method_10545("pos")) {
            config.position = class_2338.method_10092((long)nbt.method_10537("pos"));
        }
        if (nbt.method_10545("customName")) {
            config.customName = nbt.method_10558("customName");
        }
        config.machineType = nbt.method_10545("machineType") ? nbt.method_10558("machineType") : "Unknown";
        config.enabled = nbt.method_10545("enabled") ? nbt.method_10577("enabled") : true;
        String recipeStr = nbt.method_10545("recipeFilter") ? nbt.method_10558("recipeFilter") : "ORES_ONLY";
        config.recipeFilter = RecipeFilterMode.fromString(recipeStr);
        String fuelStr = nbt.method_10545("fuelFilter") ? nbt.method_10558("fuelFilter") : "COAL_ONLY";
        config.fuelFilter = FuelFilterMode.fromString(fuelStr);
        config.itemsProcessed = nbt.method_10550("itemsProcessed");
        config.index = nbt.method_10550("index");
        if (nbt.method_10545("customRecipes")) {
            class_2499 recipeList = nbt.method_10554("customRecipes", 8);
            for (int i = 0; i < recipeList.size(); ++i) {
                String itemId = recipeList.method_10608(i);
                if (itemId.isEmpty()) continue;
                config.customRecipeWhitelist.add(itemId);
            }
        }
        return config;
    }

    public ProcessProbeConfig copy() {
        ProcessProbeConfig copy = new ProcessProbeConfig();
        copy.position = this.position;
        copy.customName = this.customName;
        copy.machineType = this.machineType;
        copy.enabled = this.enabled;
        copy.recipeFilter = this.recipeFilter;
        copy.fuelFilter = this.fuelFilter;
        copy.itemsProcessed = this.itemsProcessed;
        copy.customRecipeWhitelist = new HashSet<String>(this.customRecipeWhitelist);
        copy.customFuelWhitelist = new HashSet<String>(this.customFuelWhitelist);
        copy.index = this.index;
        return copy;
    }
}

