/*
 * Decompiled with CFR 0.152.
 */
package net.shaddii.smartsorter.widget;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_6381;
import net.minecraft.class_6382;

public class DropdownWidget
extends class_339 {
    private final List<DropdownEntry> entries = new ArrayList<DropdownEntry>();
    private boolean isOpen = false;
    private int selectedIndex = 0;
    private Consumer<Integer> onSelect;
    private int scrollOffset = 0;
    private static final int ENTRY_HEIGHT = 12;
    private static final int MAX_VISIBLE_ENTRIES = 6;

    public DropdownWidget(int x, int y, int width, int height, class_2561 message) {
        super(x, y, width, height, message);
    }

    public void addEntry(String label, String tooltip) {
        this.entries.add(new DropdownEntry(label, tooltip));
    }

    public void setSelectedIndex(int index) {
        if (index >= 0 && index < this.entries.size()) {
            this.selectedIndex = index;
            this.method_25355((class_2561)class_2561.method_43470((String)this.entries.get((int)index).label));
            if (!this.isOpen) {
                this.scrollToShowIndex(index);
            }
        }
    }

    private void scrollToShowIndex(int index) {
        if (index < this.scrollOffset) {
            this.scrollOffset = index;
        } else if (index >= this.scrollOffset + 6) {
            this.scrollOffset = index - 6 + 1;
        }
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public void setOnSelect(Consumer<Integer> onSelect) {
        this.onSelect = onSelect;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        boolean insideBase;
        if (!this.field_22763 || !this.field_22764) {
            return false;
        }
        boolean bl = insideBase = mouseX >= (double)this.method_46426() && mouseX < (double)(this.method_46426() + this.field_22758) && mouseY >= (double)this.method_46427() && mouseY < (double)(this.method_46427() + this.field_22759);
        if (this.isOpen) {
            int relativeY;
            int clickedVisibleIndex;
            int clickedActualIndex;
            int dropdownY = this.getDropdownY();
            int visibleEntries = Math.min(6, this.entries.size());
            int dropdownHeight = visibleEntries * 12;
            if (mouseX >= (double)this.method_46426() && mouseX < (double)(this.method_46426() + this.field_22758) && mouseY >= (double)dropdownY && mouseY < (double)(dropdownY + dropdownHeight) && (clickedActualIndex = this.scrollOffset + (clickedVisibleIndex = (relativeY = (int)(mouseY - (double)dropdownY)) / 12)) >= 0 && clickedActualIndex < this.entries.size()) {
                this.selectEntry(clickedActualIndex);
                return true;
            }
        }
        if (insideBase) {
            boolean wasOpen = this.isOpen;
            boolean bl2 = this.isOpen = !this.isOpen;
            if (this.isOpen && !wasOpen) {
                this.scrollOffset = 0;
                this.scrollToShowIndex(this.selectedIndex);
            }
            return true;
        }
        return false;
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (!this.isOpen) {
            return false;
        }
        int dropdownY = this.getDropdownY();
        int visibleEntries = Math.min(6, this.entries.size());
        int dropdownHeight = visibleEntries * 12;
        if (mouseX >= (double)this.method_46426() && mouseX < (double)(this.method_46426() + this.field_22758) && mouseY >= (double)dropdownY && mouseY < (double)(dropdownY + dropdownHeight)) {
            int maxScroll = Math.max(0, this.entries.size() - 6);
            this.scrollOffset -= (int)verticalAmount;
            this.scrollOffset = Math.max(0, Math.min(maxScroll, this.scrollOffset));
            return true;
        }
        return false;
    }

    private void selectEntry(int index) {
        this.selectedIndex = index;
        this.method_25355((class_2561)class_2561.method_43470((String)this.entries.get((int)index).label));
        this.isOpen = false;
        if (this.onSelect != null) {
            this.onSelect.accept(index);
        }
    }

    private boolean shouldOpenUpwards() {
        class_310 client = class_310.method_1551();
        int screenHeight = client.method_22683().method_4502();
        int visibleEntries = Math.min(6, this.entries.size());
        int dropdownHeight = visibleEntries * 12;
        int spaceAbove = this.method_46427();
        int spaceBelow = screenHeight - (this.method_46427() + this.field_22759);
        return spaceAbove >= dropdownHeight && spaceAbove > spaceBelow;
    }

    private int getDropdownY() {
        int visibleEntries = Math.min(6, this.entries.size());
        int dropdownHeight = visibleEntries * 12;
        if (this.shouldOpenUpwards()) {
            return this.method_46427() - dropdownHeight;
        }
        return this.method_46427() + this.field_22759;
    }

    protected void method_47399(class_6382 builder) {
        builder.method_37034(class_6381.field_33788, this.method_25369());
    }

    public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
        class_310 client = class_310.method_1551();
        int buttonColor = this.method_49606() ? -9737365 : -7631989;
        context.method_25294(this.method_46426(), this.method_46427(), this.method_46426() + this.field_22758, this.method_46427() + this.field_22759, buttonColor);
        context.method_25294(this.method_46426(), this.method_46427(), this.method_46426() + this.field_22758, this.method_46427() + 1, -1);
        context.method_25294(this.method_46426(), this.method_46427(), this.method_46426() + 1, this.method_46427() + this.field_22759, -1);
        context.method_25294(this.method_46426(), this.method_46427() + this.field_22759 - 1, this.method_46426() + this.field_22758, this.method_46427() + this.field_22759, -13158601);
        context.method_25294(this.method_46426() + this.field_22758 - 1, this.method_46427(), this.method_46426() + this.field_22758, this.method_46427() + this.field_22759, -13158601);
        context.method_51439(client.field_1772, this.method_25369(), this.method_46426() + 4, this.method_46427() + (this.field_22759 - 8) / 2, -1, false);
        String arrow = this.isOpen ? (this.shouldOpenUpwards() ? "\u25b2" : "\u25bc") : "\u25bc";
        context.method_51433(client.field_1772, arrow, this.method_46426() + this.field_22758 - 12, this.method_46427() + (this.field_22759 - 8) / 2, -1, false);
    }

    public void renderDropdown(class_332 context, int mouseX, int mouseY) {
        int actualIndex;
        if (!this.isOpen) {
            return;
        }
        class_310 client = class_310.method_1551();
        int dropdownX = this.method_46426();
        int dropdownY = this.getDropdownY();
        int visibleEntries = Math.min(6, this.entries.size());
        int dropdownHeight = visibleEntries * 12;
        context.method_25294(dropdownX, dropdownY, dropdownX + this.field_22758, dropdownY + dropdownHeight, -587202560);
        for (int i = 0; i < visibleEntries && (actualIndex = this.scrollOffset + i) < this.entries.size(); ++i) {
            int entryY = dropdownY + i * 12;
            if (mouseX >= dropdownX && mouseX < dropdownX + this.field_22758 && mouseY >= entryY && mouseY < entryY + 12) {
                context.method_25294(dropdownX, entryY, dropdownX + this.field_22758, entryY + 12, -10790053);
            }
            if (actualIndex == this.selectedIndex) {
                context.method_25294(dropdownX, entryY, dropdownX + 2, entryY + 12, -11141291);
            }
            DropdownEntry entry = this.entries.get(actualIndex);
            context.method_51433(client.field_1772, entry.label, dropdownX + 4, entryY + 2, -1, false);
        }
        if (this.entries.size() > 6) {
            this.drawScrollbar(context, dropdownX, dropdownY, dropdownHeight);
        }
        context.method_25294(dropdownX, dropdownY, dropdownX + this.field_22758, dropdownY + 1, -1);
        context.method_25294(dropdownX, dropdownY + dropdownHeight - 1, dropdownX + this.field_22758, dropdownY + dropdownHeight, -1);
        context.method_25294(dropdownX, dropdownY, dropdownX + 1, dropdownY + dropdownHeight, -1);
        context.method_25294(dropdownX + this.field_22758 - 1, dropdownY, dropdownX + this.field_22758, dropdownY + dropdownHeight, -1);
    }

    private void drawScrollbar(class_332 context, int dropdownX, int dropdownY, int dropdownHeight) {
        int scrollbarX = dropdownX + this.field_22758 - 6;
        int scrollbarWidth = 4;
        context.method_25294(scrollbarX, dropdownY, scrollbarX + scrollbarWidth, dropdownY + dropdownHeight, -11184811);
        int maxScroll = this.entries.size() - 6;
        float scrollPercentage = (float)this.scrollOffset / (float)maxScroll;
        int handleHeight = Math.max(10, dropdownHeight * 6 / this.entries.size());
        int handleY = dropdownY + (int)(scrollPercentage * (float)(dropdownHeight - handleHeight));
        context.method_25294(scrollbarX, handleY, scrollbarX + scrollbarWidth, handleY + handleHeight, -5592406);
    }

    public boolean method_25405(double mouseX, double mouseY) {
        if (mouseX >= (double)this.method_46426() && mouseX < (double)(this.method_46426() + this.field_22758) && mouseY >= (double)this.method_46427() && mouseY < (double)(this.method_46427() + this.field_22759)) {
            return true;
        }
        if (this.isOpen) {
            int dropdownY = this.getDropdownY();
            int visibleEntries = Math.min(6, this.entries.size());
            int dropdownHeight = visibleEntries * 12;
            return mouseX >= (double)this.method_46426() && mouseX < (double)(this.method_46426() + this.field_22758) && mouseY >= (double)dropdownY && mouseY < (double)(dropdownY + dropdownHeight);
        }
        return false;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public void close() {
        this.isOpen = false;
    }

    public void setMaxDisplayedEntries(int max) {
    }

    public void clearEntries() {
        this.entries.clear();
        this.selectedIndex = 0;
        if (!this.isOpen) {
            this.scrollOffset = 0;
        }
    }

    private record DropdownEntry(String label, String tooltip) {
    }
}

