/*
 * Decompiled with CFR 0.152.
 */
package net.shaddii.smartsorter;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroup;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.object.builder.v1.block.entity.FabricBlockEntityTypeBuilder;
import net.fabricmc.fabric.api.resource.v1.ResourceLoader;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerType;
import net.minecraft.class_11352;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3264;
import net.minecraft.class_3302;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3917;
import net.minecraft.class_4970;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8710;
import net.minecraft.class_8824;
import net.minecraft.class_8942;
import net.shaddii.smartsorter.block.IntakeBlock;
import net.shaddii.smartsorter.block.OutputProbeBlock;
import net.shaddii.smartsorter.block.ProcessProbeBlock;
import net.shaddii.smartsorter.block.StorageControllerBlock;
import net.shaddii.smartsorter.blockentity.IntakeBlockEntity;
import net.shaddii.smartsorter.blockentity.OutputProbeBlockEntity;
import net.shaddii.smartsorter.blockentity.ProcessProbeBlockEntity;
import net.shaddii.smartsorter.blockentity.StorageControllerBlockEntity;
import net.shaddii.smartsorter.item.LinkingToolItem;
import net.shaddii.smartsorter.network.CategorySyncPayload;
import net.shaddii.smartsorter.network.ChestConfigBatchPayload;
import net.shaddii.smartsorter.network.ChestConfigUpdatePayload;
import net.shaddii.smartsorter.network.ChestPriorityBatchPayload;
import net.shaddii.smartsorter.network.CollectXpPayload;
import net.shaddii.smartsorter.network.FilterCategoryChangePayload;
import net.shaddii.smartsorter.network.OverflowNotificationPayload;
import net.shaddii.smartsorter.network.ProbeConfigBatchPayload;
import net.shaddii.smartsorter.network.ProbeConfigUpdatePayload;
import net.shaddii.smartsorter.network.ProbeStatsSyncPayload;
import net.shaddii.smartsorter.network.SortChestsPayload;
import net.shaddii.smartsorter.network.SortModeChangePayload;
import net.shaddii.smartsorter.network.SortProgressPayload;
import net.shaddii.smartsorter.network.StorageControllerSyncPacket;
import net.shaddii.smartsorter.network.StorageDeltaSyncPayload;
import net.shaddii.smartsorter.screen.OutputProbeScreenHandler;
import net.shaddii.smartsorter.screen.StorageControllerScreenHandler;
import net.shaddii.smartsorter.util.CategoryManager;
import net.shaddii.smartsorter.util.ChestConfig;
import net.shaddii.smartsorter.util.ChunkedSorter;
import net.shaddii.smartsorter.util.ProcessProbeConfig;

public class SmartSorter
implements ModInitializer {
    public static final String MOD_ID = "smartsorter";
    public static class_2248 INTAKE_BLOCK;
    public static class_2248 PROBE_BLOCK;
    public static class_2248 STORAGE_CONTROLLER_BLOCK;
    public static class_2248 PROCESS_PROBE_BLOCK;
    public static class_1792 INTAKE_ITEM;
    public static class_1792 PROBE_ITEM;
    public static class_1792 STORAGE_CONTROLLER_ITEM;
    public static class_1792 PROCESS_PROBE_ITEM;
    public static class_1792 LINKING_TOOL;
    public static class_2591<IntakeBlockEntity> INTAKE_BE_TYPE;
    public static class_2591<OutputProbeBlockEntity> PROBE_BE_TYPE;
    public static class_2591<StorageControllerBlockEntity> STORAGE_CONTROLLER_BE_TYPE;
    public static class_2591<ProcessProbeBlockEntity> PROCESS_PROBE_BE_TYPE;
    public static class_3917<StorageControllerScreenHandler> STORAGE_CONTROLLER_SCREEN_HANDLER;
    public static class_3917<OutputProbeScreenHandler> OUTPUT_PROBE_SCREEN_HANDLER;

    public void onInitialize() {
        this.registerBlocks();
        this.registerItems();
        this.registerBlockEntities();
        this.registerScreens();
        this.registerTools();
        this.registerCreativeTab();
        this.registerNetworkPayloads();
        this.registerNetworkHandlers();
        this.registerEvents();
        ChunkedSorter.init();
        ResourceLoader.get((class_3264)class_3264.field_14190).registerReloader(class_2960.method_60655((String)MOD_ID, (String)"category_manager"), (class_3302)CategoryManager.getInstance());
    }

    private static void writeNameToChestDirect(class_1937 world, class_2338 chestPos, String customName) {
        if (world == null || world.method_8608()) {
            return;
        }
        class_2586 blockEntity = world.method_8321(chestPos);
        if (blockEntity == null) {
            return;
        }
        class_2487 nbt = blockEntity.method_38244((class_7225.class_7874)world.method_30349());
        if (customName == null || customName.isEmpty()) {
            nbt.method_10551("CustomName");
        } else {
            class_5250 textComponent = class_2561.method_43470((String)customName);
            DataResult result = class_8824.field_46597.encodeStart((DynamicOps)world.method_30349().method_57093((DynamicOps)class_2509.field_11560), (Object)textComponent);
            result.result().ifPresent(nbtElement -> nbt.method_10566("CustomName", nbtElement));
        }
        try (class_8942.class_11340 logging = new class_8942.class_11340(blockEntity.method_71402(), LogUtils.getLogger());){
            blockEntity.method_58690(class_11352.method_71417((class_8942)logging, (class_7225.class_7874)world.method_30349(), (class_2487)nbt));
        }
        blockEntity.method_5431();
        class_2680 state = world.method_8320(chestPos);
        world.method_8413(chestPos, state, state, 3);
    }

    private void registerBlocks() {
        INTAKE_BLOCK = this.registerBlock("intake", (class_2248)new IntakeBlock(class_4970.class_2251.method_9637().method_63500(class_5321.method_29179((class_5321)class_7924.field_41254, (class_2960)SmartSorter.id("intake"))).method_9632(0.6f).method_22488()));
        PROBE_BLOCK = this.registerBlock("output_probe", (class_2248)new OutputProbeBlock(class_4970.class_2251.method_9637().method_63500(class_5321.method_29179((class_5321)class_7924.field_41254, (class_2960)SmartSorter.id("output_probe"))).method_9632(0.6f).method_22488()));
        STORAGE_CONTROLLER_BLOCK = this.registerBlock("storage_controller", (class_2248)new StorageControllerBlock(class_4970.class_2251.method_9637().method_63500(class_5321.method_29179((class_5321)class_7924.field_41254, (class_2960)SmartSorter.id("storage_controller"))).method_9632(0.6f)));
        PROCESS_PROBE_BLOCK = this.registerBlock("process_probe", (class_2248)new ProcessProbeBlock(class_4970.class_2251.method_9637().method_63500(class_5321.method_29179((class_5321)class_7924.field_41254, (class_2960)SmartSorter.id("process_probe"))).method_9632(0.6f).method_22488()));
    }

    private class_2248 registerBlock(String name, class_2248 block) {
        return (class_2248)class_2378.method_10230((class_2378)class_7923.field_41175, (class_2960)SmartSorter.id(name), (Object)block);
    }

    private void registerItems() {
        INTAKE_ITEM = this.registerBlockItem("intake", INTAKE_BLOCK);
        PROBE_ITEM = this.registerBlockItem("output_probe", PROBE_BLOCK);
        STORAGE_CONTROLLER_ITEM = this.registerBlockItem("storage_controller", STORAGE_CONTROLLER_BLOCK);
        PROCESS_PROBE_ITEM = this.registerBlockItem("process_probe", PROCESS_PROBE_BLOCK);
    }

    private class_1792 registerBlockItem(String name, final class_2248 block) {
        class_1792.class_1793 settings = new class_1792.class_1793().method_63686(class_5321.method_29179((class_5321)class_7924.field_41197, (class_2960)SmartSorter.id(name)));
        return (class_1792)class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)SmartSorter.id(name), (Object)new class_1747(this, block, settings){

            public class_2561 method_7864(class_1799 stack) {
                return block.method_9518();
            }
        });
    }

    private void registerBlockEntities() {
        INTAKE_BE_TYPE = (class_2591)class_2378.method_10230((class_2378)class_7923.field_41181, (class_2960)SmartSorter.id("intake"), (Object)FabricBlockEntityTypeBuilder.create(IntakeBlockEntity::new, (class_2248[])new class_2248[]{INTAKE_BLOCK}).build());
        PROBE_BE_TYPE = (class_2591)class_2378.method_10230((class_2378)class_7923.field_41181, (class_2960)SmartSorter.id("output_probe"), (Object)FabricBlockEntityTypeBuilder.create(OutputProbeBlockEntity::new, (class_2248[])new class_2248[]{PROBE_BLOCK}).build());
        STORAGE_CONTROLLER_BE_TYPE = (class_2591)class_2378.method_10230((class_2378)class_7923.field_41181, (class_2960)SmartSorter.id("storage_controller"), (Object)FabricBlockEntityTypeBuilder.create(StorageControllerBlockEntity::new, (class_2248[])new class_2248[]{STORAGE_CONTROLLER_BLOCK}).build());
        PROCESS_PROBE_BE_TYPE = (class_2591)class_2378.method_10230((class_2378)class_7923.field_41181, (class_2960)SmartSorter.id("process_probe"), (Object)FabricBlockEntityTypeBuilder.create(ProcessProbeBlockEntity::new, (class_2248[])new class_2248[]{PROCESS_PROBE_BLOCK}).build());
    }

    private void registerScreens() {
        STORAGE_CONTROLLER_SCREEN_HANDLER = (class_3917)class_2378.method_10230((class_2378)class_7923.field_41187, (class_2960)SmartSorter.id("storage_controller"), (Object)new class_3917(StorageControllerScreenHandler::new, null));
        OUTPUT_PROBE_SCREEN_HANDLER = (class_3917)class_2378.method_10230((class_2378)class_7923.field_41187, (class_2960)SmartSorter.id("output_probe"), (Object)new ExtendedScreenHandlerType(OutputProbeScreenHandler::new, OutputProbeBlockEntity.ProbeData.CODEC));
    }

    private void registerTools() {
        class_1792.class_1793 settings = new class_1792.class_1793().method_63686(class_5321.method_29179((class_5321)class_7924.field_41197, (class_2960)SmartSorter.id("linking_tool"))).method_7889(1);
        LINKING_TOOL = (class_1792)class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)SmartSorter.id("linking_tool"), (Object)((Object)new LinkingToolItem(settings)));
    }

    private void registerCreativeTab() {
        class_2378.method_10230((class_2378)class_7923.field_44687, (class_2960)SmartSorter.id("smartsorter_group"), (Object)FabricItemGroup.builder().method_47321((class_2561)class_2561.method_43471((String)"itemGroup.smartsorter")).method_47320(() -> new class_1799((class_1935)STORAGE_CONTROLLER_ITEM)).method_47317((ctx, entries) -> {
            entries.method_45421((class_1935)STORAGE_CONTROLLER_ITEM);
            entries.method_45421((class_1935)INTAKE_ITEM);
            entries.method_45421((class_1935)PROBE_ITEM);
            entries.method_45421((class_1935)PROCESS_PROBE_ITEM);
            entries.method_45421((class_1935)LINKING_TOOL);
        }).method_47324());
    }

    private void registerNetworkPayloads() {
        PayloadTypeRegistry.playS2C().register(StorageControllerSyncPacket.SyncPayload.ID_PAYLOAD, StorageControllerSyncPacket.SyncPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(ProbeStatsSyncPayload.ID, ProbeStatsSyncPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(ProbeConfigBatchPayload.ID, ProbeConfigBatchPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(ChestConfigBatchPayload.ID, ChestConfigBatchPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(ChestConfigUpdatePayload.ID, ChestConfigUpdatePayload.CODEC);
        PayloadTypeRegistry.playS2C().register(OverflowNotificationPayload.ID, OverflowNotificationPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(StorageDeltaSyncPayload.ID, StorageDeltaSyncPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(SortProgressPayload.ID, SortProgressPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(ChestPriorityBatchPayload.ID, ChestPriorityBatchPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(CategorySyncPayload.ID, CategorySyncPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(StorageControllerScreenHandler.ExtractionRequestPayload.ID, StorageControllerScreenHandler.ExtractionRequestPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(StorageControllerScreenHandler.SyncRequestPayload.ID, StorageControllerScreenHandler.SyncRequestPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(StorageControllerScreenHandler.DepositRequestPayload.ID, StorageControllerScreenHandler.DepositRequestPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(SortModeChangePayload.ID, SortModeChangePayload.CODEC);
        PayloadTypeRegistry.playC2S().register(FilterCategoryChangePayload.ID, FilterCategoryChangePayload.CODEC);
        PayloadTypeRegistry.playC2S().register(CollectXpPayload.ID, CollectXpPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(ProbeConfigUpdatePayload.ID, ProbeConfigUpdatePayload.CODEC);
        PayloadTypeRegistry.playC2S().register(ChestConfigUpdatePayload.ID, ChestConfigUpdatePayload.CODEC);
        PayloadTypeRegistry.playC2S().register(SortChestsPayload.ID, SortChestsPayload.CODEC);
    }

    private void registerNetworkHandlers() {
        ServerPlayNetworking.registerGlobalReceiver(StorageControllerScreenHandler.ExtractionRequestPayload.ID, (payload, context) -> context.server().execute(() -> {
            class_3222 player = context.player();
            class_1703 patt0$temp = player.field_7512;
            if (patt0$temp instanceof StorageControllerScreenHandler) {
                StorageControllerScreenHandler handler = (StorageControllerScreenHandler)patt0$temp;
                if (handler.controller != null) {
                    handler.extractItem(payload.variant(), payload.amount(), payload.toInventory(), (class_1657)player);
                    handler.sendNetworkUpdate(player);
                }
            }
        }));
        ServerPlayNetworking.registerGlobalReceiver(StorageControllerScreenHandler.DepositRequestPayload.ID, (payload, context) -> context.server().execute(() -> {
            class_3222 player = context.player();
            class_1703 patt0$temp = player.field_7512;
            if (patt0$temp instanceof StorageControllerScreenHandler) {
                StorageControllerScreenHandler handler = (StorageControllerScreenHandler)patt0$temp;
                if (handler.controller != null) {
                    class_1799 stack = payload.variant().toStack(payload.amount());
                    handler.depositItem(stack, payload.amount(), (class_1657)player);
                    handler.sendNetworkUpdate(player);
                }
            }
        }));
        ServerPlayNetworking.registerGlobalReceiver(SortChestsPayload.ID, (payload, context) -> context.server().execute(() -> {
            class_3222 player = context.player();
            class_1703 patt0$temp = player.field_7512;
            if (patt0$temp instanceof StorageControllerScreenHandler) {
                StorageControllerScreenHandler handler = (StorageControllerScreenHandler)patt0$temp;
                StorageControllerBlockEntity controller = handler.controller;
                if (controller != null) {
                    ChunkedSorter.startSorting(player, controller, payload.sortedPositions());
                }
            }
        }));
        ServerPlayNetworking.registerGlobalReceiver(StorageControllerScreenHandler.SyncRequestPayload.ID, (payload, context) -> context.server().execute(() -> {
            class_1703 patt0$temp = context.player().field_7512;
            if (patt0$temp instanceof StorageControllerScreenHandler) {
                StorageControllerScreenHandler handler = (StorageControllerScreenHandler)patt0$temp;
                handler.sendNetworkUpdate(context.player());
            }
        }));
        ServerPlayNetworking.registerGlobalReceiver(SortModeChangePayload.ID, (payload, context) -> context.server().execute(() -> {
            class_1703 patt0$temp = context.player().field_7512;
            if (patt0$temp instanceof StorageControllerScreenHandler) {
                StorageControllerScreenHandler handler = (StorageControllerScreenHandler)patt0$temp;
                handler.setSortMode(payload.getSortMode());
                handler.sendNetworkUpdate(context.player());
            }
        }));
        ServerPlayNetworking.registerGlobalReceiver(FilterCategoryChangePayload.ID, (payload, context) -> context.server().execute(() -> {
            class_1703 patt0$temp = context.player().field_7512;
            if (patt0$temp instanceof StorageControllerScreenHandler) {
                StorageControllerScreenHandler handler = (StorageControllerScreenHandler)patt0$temp;
                handler.setFilterCategory(payload.getCategory());
                handler.sendNetworkUpdate(context.player());
            }
        }));
        ServerPlayNetworking.registerGlobalReceiver(CollectXpPayload.ID, (payload, context) -> context.server().execute(() -> {
            class_3222 player = context.player();
            class_1703 patt0$temp = player.field_7512;
            if (patt0$temp instanceof StorageControllerScreenHandler) {
                int xp;
                StorageControllerScreenHandler handler = (StorageControllerScreenHandler)patt0$temp;
                if (handler.controller != null && (xp = handler.controller.collectExperience()) > 0) {
                    player.method_7255(xp);
                    player.method_7353((class_2561)class_2561.method_43470((String)("\u00a7a+\u00a7e" + xp + " XP \u00a7acollected!")), true);
                    player.method_51469().method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14627, class_3419.field_15248, 0.5f, 1.0f);
                    handler.sendNetworkUpdate(player);
                }
            }
        }));
        ServerPlayNetworking.registerGlobalReceiver(ProbeConfigUpdatePayload.ID, (payload, context) -> context.server().execute(() -> {
            class_3222 player = context.player();
            class_1703 patt0$temp = player.field_7512;
            if (patt0$temp instanceof StorageControllerScreenHandler) {
                ProcessProbeConfig config;
                StorageControllerScreenHandler handler = (StorageControllerScreenHandler)patt0$temp;
                if (handler.controller != null && (config = handler.controller.getProbeConfig(payload.position())) != null) {
                    config.customName = payload.customName();
                    config.enabled = payload.enabled();
                    config.recipeFilter = payload.recipeFilter();
                    config.fuelFilter = payload.fuelFilter();
                    handler.controller.updateProbeConfig(config);
                    handler.controller.method_5431();
                    handler.sendNetworkUpdate(player);
                }
            }
        }));
        ServerPlayNetworking.registerGlobalReceiver(ChestConfigUpdatePayload.ID, (payload, context) -> context.server().execute(() -> {
            class_2338 chestPos;
            OutputProbeScreenHandler probeHandler;
            StorageControllerScreenHandler mainHandler;
            class_3222 player = context.player();
            StorageControllerBlockEntity controller = null;
            OutputProbeBlockEntity probe = null;
            class_1703 patt0$temp = player.field_7512;
            if (patt0$temp instanceof StorageControllerScreenHandler) {
                mainHandler = (StorageControllerScreenHandler)patt0$temp;
                controller = mainHandler.controller;
            } else {
                class_1703 patt1$temp = player.field_7512;
                if (patt1$temp instanceof OutputProbeScreenHandler) {
                    probeHandler = (OutputProbeScreenHandler)patt1$temp;
                    controller = probeHandler.controller;
                    probe = probeHandler.probe;
                }
            }
            if (probe != null) {
                probe.setChestConfig(payload.config());
            }
            if (controller != null) {
                controller.updateChestConfig(payload.config().position, payload.config());
                class_1703 patt2$temp = player.field_7512;
                if (patt2$temp instanceof StorageControllerScreenHandler) {
                    mainHandler = (StorageControllerScreenHandler)patt2$temp;
                    mainHandler.sendNetworkUpdate(player);
                } else {
                    class_1703 patt3$temp = player.field_7512;
                    if (patt3$temp instanceof OutputProbeScreenHandler) {
                        probeHandler = (OutputProbeScreenHandler)patt3$temp;
                        ChestConfig refreshedConfig = controller.getChestConfig(payload.config().position);
                        if (refreshedConfig != null) {
                            probeHandler.setChestConfig(refreshedConfig);
                            ServerPlayNetworking.send((class_3222)player, (class_8710)new ChestConfigUpdatePayload(refreshedConfig));
                        }
                    }
                }
            } else if (probe != null && probe.method_10997() != null && (chestPos = payload.config().position) != null) {
                SmartSorter.writeNameToChestDirect(probe.method_10997(), chestPos, payload.config().customName);
            }
        }));
    }

    private void registerEvents() {
        UseBlockCallback.EVENT.register((player, world, hand, hit) -> class_1269.field_5811);
    }

    public static class_2960 id(String path) {
        return class_2960.method_60655((String)MOD_ID, (String)path);
    }
}

