/*
 * Decompiled with CFR 0.152.
 */
package net.shaddii.smartsorter.blockentity;

import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_7225;
import net.shaddii.smartsorter.SmartSorter;
import net.shaddii.smartsorter.StorageLogic;
import net.shaddii.smartsorter.blockentity.OutputProbeBlockEntity;
import net.shaddii.smartsorter.blockentity.StorageControllerBlockEntity;

public class IntakeBlockEntity
extends class_2586 {
    private static final int MOVE_COOLDOWN = 2;
    private static final int IDLE_COOLDOWN = 10;
    private static final long VALIDATION_INTERVAL = 100L;
    private final List<class_2338> outputs = new ArrayList<class_2338>();
    private class_2338 controllerPos = null;
    private class_1799 buffer = class_1799.field_8037;
    private int cooldown = 0;

    public IntakeBlockEntity(class_2338 pos, class_2680 state) {
        super(SmartSorter.INTAKE_BE_TYPE, pos, state);
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, IntakeBlockEntity be) {
        if (world.method_8608()) {
            return;
        }
        if (world.method_8510() % 100L == 0L) {
            be.validateLinks(world);
        }
        if (be.cooldown > 0) {
            --be.cooldown;
            return;
        }
        boolean moved = StorageLogic.pullAndRoute(be);
        int n = be.cooldown = moved ? 2 : 10;
        if (moved) {
            be.method_5431();
        }
    }

    private void validateLinks(class_1937 world) {
        class_2586 be;
        if (this.controllerPos != null && !((be = world.method_8321(this.controllerPos)) instanceof StorageControllerBlockEntity)) {
            this.controllerPos = null;
            this.method_5431();
        }
        this.outputs.removeIf(outputPos -> {
            class_2586 be = world.method_8321(outputPos);
            return !(be instanceof OutputProbeBlockEntity);
        });
    }

    public boolean setController(class_2338 pos) {
        if (this.controllerPos == null || !this.controllerPos.equals((Object)pos)) {
            this.controllerPos = pos;
            this.outputs.clear();
            this.method_5431();
            return true;
        }
        return false;
    }

    public class_2338 getController() {
        return this.controllerPos;
    }

    public boolean clearController() {
        if (this.controllerPos != null) {
            this.controllerPos = null;
            this.method_5431();
            return true;
        }
        return false;
    }

    public boolean addOutput(class_2338 probePos) {
        if (!this.outputs.contains(probePos)) {
            this.outputs.add(probePos);
            this.controllerPos = null;
            this.method_5431();
            return true;
        }
        return false;
    }

    public boolean removeOutput(class_2338 probePos) {
        boolean removed = this.outputs.remove(probePos);
        if (removed) {
            this.method_5431();
        }
        return removed;
    }

    public List<class_2338> getOutputs() {
        return this.outputs;
    }

    public boolean isInManagedMode() {
        return this.controllerPos != null;
    }

    public boolean isInDirectMode() {
        return !this.outputs.isEmpty();
    }

    public class_1799 getBuffer() {
        return this.buffer;
    }

    public void setBuffer(class_1799 stack) {
        this.buffer = stack;
        this.method_5431();
    }

    protected void writeNbt(class_2487 nbt, class_7225.class_7874 lookup) {
        if (this.controllerPos != null) {
            nbt.method_10544("controller", this.controllerPos.method_10063());
        }
        nbt.method_10569("out_count", this.outputs.size());
        for (int i = 0; i < this.outputs.size(); ++i) {
            nbt.method_10544("o" + i, this.outputs.get(i).method_10063());
        }
        if (!this.buffer.method_7960()) {
            class_2520 encoded = (class_2520)class_1799.field_49266.encodeStart((DynamicOps)lookup.method_57093((DynamicOps)class_2509.field_11560), (Object)this.buffer).getOrThrow();
            nbt.method_10566("buffer", encoded);
        }
    }

    protected void readNbt(class_2487 nbt, class_7225.class_7874 lookup) {
        nbt.method_10537("controller").ifPresent(pos -> {
            this.controllerPos = class_2338.method_10092((long)pos);
        });
        this.outputs.clear();
        int c = nbt.method_10550("out_count").orElse(0);
        for (int i = 0; i < c; ++i) {
            nbt.method_10537("o" + i).ifPresent(pos -> this.outputs.add(class_2338.method_10092((long)pos)));
        }
        this.buffer = nbt.method_10545("buffer") ? class_1799.field_49266.parse((DynamicOps)lookup.method_57093((DynamicOps)class_2509.field_11560), (Object)nbt.method_10580("buffer")).result().orElse(class_1799.field_8037) : class_1799.field_8037;
    }
}

