/*
 * Decompiled with CFR 0.152.
 */
package net.shaddii.smartsorter.blockentity.controller;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_11352;
import net.minecraft.class_1263;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7225;
import net.minecraft.class_8710;
import net.minecraft.class_8824;
import net.minecraft.class_8942;
import net.shaddii.smartsorter.blockentity.OutputProbeBlockEntity;
import net.shaddii.smartsorter.blockentity.StorageControllerBlockEntity;
import net.shaddii.smartsorter.blockentity.controller.ProbeRegistry;
import net.shaddii.smartsorter.network.ChestPriorityBatchPayload;
import net.shaddii.smartsorter.screen.StorageControllerScreenHandler;
import net.shaddii.smartsorter.util.Category;
import net.shaddii.smartsorter.util.CategoryManager;
import net.shaddii.smartsorter.util.ChestConfig;
import net.shaddii.smartsorter.util.ChestPriorityManager;

public class ChestConfigManager {
    private final Map<class_2338, ChestConfig> chestConfigs = new LinkedHashMap<class_2338, ChestConfig>();
    private final ChestPriorityManager priorityManager = new ChestPriorityManager();
    private final ProbeRegistry probeRegistry;

    public ChestConfigManager(ProbeRegistry probeRegistry) {
        this.probeRegistry = probeRegistry;
    }

    public void onChestDetected(class_1937 world, class_2338 chestPos, OutputProbeBlockEntity probe) {
        if (this.chestConfigs.containsKey(chestPos)) {
            return;
        }
        ChestConfig config = null;
        ChestConfig probeConfig = probe.getChestConfig();
        if (probeConfig != null) {
            config = probeConfig.copy();
        }
        if (config == null) {
            String existingName = this.readNameFromChest(world, chestPos);
            config = new ChestConfig(chestPos);
            if (existingName != null && !existingName.isEmpty()) {
                config.customName = existingName;
            }
            config.simplePrioritySelection = ChestConfig.SimplePriority.MEDIUM;
        }
        Map<class_2338, Integer> newPriorities = this.priorityManager.addChest(chestPos, config, this.chestConfigs);
        this.applyPriorityUpdates(world, newPriorities);
        this.probeRegistry.invalidateCache();
    }

    public void onChestRemoved(class_1937 world, class_2338 chestPos, List<class_2338> remainingProbes) {
        ChestConfig removed;
        boolean stillLinked = false;
        for (class_2338 probePos : remainingProbes) {
            OutputProbeBlockEntity probe;
            class_2338 targetPos;
            class_2586 be = world.method_8321(probePos);
            if (!(be instanceof OutputProbeBlockEntity) || (targetPos = (probe = (OutputProbeBlockEntity)be).getTargetPos()) == null || !targetPos.equals((Object)chestPos)) continue;
            stillLinked = true;
            break;
        }
        if (!stillLinked && (removed = this.chestConfigs.remove(chestPos)) != null) {
            this.clearNameFromChest(world, chestPos);
        }
    }

    public void updateChestConfig(class_1937 world, class_2338 position, ChestConfig config, StorageControllerBlockEntity controller) {
        ChestConfig oldConfig = this.chestConfigs.get(position);
        if (oldConfig == null) {
            Map<class_2338, Integer> newPriorities = this.priorityManager.addChest(position, config, this.chestConfigs);
            this.applyPriorityUpdates(world, newPriorities);
        } else if (oldConfig.simplePrioritySelection != config.simplePrioritySelection && config.filterMode != ChestConfig.FilterMode.CUSTOM) {
            Map<class_2338, Integer> newPriorities = this.priorityManager.updateChestPriority(position, config.simplePrioritySelection, this.chestConfigs);
            this.applyPriorityUpdates(world, newPriorities);
        } else {
            config.priority = oldConfig.priority;
            config.updateHiddenPriority();
            this.chestConfigs.put(position, config);
            this.syncConfigToProbe(world, config);
        }
        this.writeNameToChest(world, position, config.customName);
        this.probeRegistry.invalidateCache();
    }

    public void removeChestConfig(class_1937 world, class_2338 chestPos, StorageControllerBlockEntity controller) {
        if (this.chestConfigs.containsKey(chestPos)) {
            Map<class_2338, Integer> newPriorities = this.priorityManager.removeChest(chestPos, this.chestConfigs);
            this.applyPriorityUpdates(world, newPriorities);
            this.clearNameFromChest(world, chestPos);
            this.probeRegistry.invalidateCache();
        }
    }

    public Map<class_2338, ChestConfig> getChestConfigs(class_1937 world, List<class_2338> linkedProbes) {
        LinkedHashMap<class_2338, ChestConfig> configs = new LinkedHashMap<class_2338, ChestConfig>(this.chestConfigs);
        for (ChestConfig config : configs.values()) {
            config.cachedFullness = this.calculateChestFullness(world, config.position, linkedProbes);
            config.previewItems = this.getChestPreviewItems(world, config.position, linkedProbes);
        }
        return configs;
    }

    public ChestConfig getChestConfig(class_2338 position) {
        return this.chestConfigs.get(position);
    }

    public boolean isChestLinked(class_1937 world, class_2338 chestPos, List<class_2338> linkedProbes) {
        if (world == null) {
            return false;
        }
        for (class_2338 probePos : linkedProbes) {
            OutputProbeBlockEntity probe;
            class_2586 be = world.method_8321(probePos);
            if (!(be instanceof OutputProbeBlockEntity) || !chestPos.equals((Object)(probe = (OutputProbeBlockEntity)be).getTargetPos())) continue;
            return true;
        }
        return false;
    }

    public void clearAllChestNames(class_1937 world) {
        for (class_2338 chestPos : this.chestConfigs.keySet()) {
            this.clearNameFromChest(world, chestPos);
        }
    }

    public class_2499 writeToNbt() {
        class_2499 list = new class_2499();
        for (ChestConfig config : this.chestConfigs.values()) {
            class_2487 nbt = new class_2487();
            nbt.method_10544("Pos", config.position.method_10063());
            nbt.method_10582("Name", config.customName != null ? config.customName : "");
            nbt.method_10582("Category", config.filterCategory.asString());
            nbt.method_10569("Priority", config.priority);
            nbt.method_10582("Mode", config.filterMode.name());
            nbt.method_10556("AutoFrame", config.autoItemFrame);
            if (config.simplePrioritySelection != null) {
                nbt.method_10582("SimplePriority", config.simplePrioritySelection.name());
            }
            list.add((Object)nbt);
        }
        return list;
    }

    public void readFromNbt(class_2499 list) {
        this.chestConfigs.clear();
        for (int i = 0; i < list.size(); ++i) {
            list.method_10602(i).ifPresent(nbt -> nbt.method_10537("Pos").ifPresent(posLong -> {
                class_2338 pos = class_2338.method_10092((long)posLong);
                String name = nbt.method_10558("Name").orElse("");
                String categoryStr = nbt.method_10558("Category").orElse("smartsorter:all");
                int priority = nbt.method_10550("Priority").orElse(1);
                String modeStr = nbt.method_10558("Mode").orElse("NONE");
                boolean autoFrame = nbt.method_10577("AutoFrame").orElse(false);
                Category category = CategoryManager.getInstance().getCategory(categoryStr);
                ChestConfig.FilterMode mode = ChestConfig.FilterMode.valueOf(modeStr);
                ChestConfig config = new ChestConfig(pos, name, category, priority, mode, autoFrame);
                nbt.method_10558("SimplePriority").ifPresent(str -> {
                    try {
                        config.simplePrioritySelection = ChestConfig.SimplePriority.valueOf(str);
                    }
                    catch (Exception e) {
                        config.simplePrioritySelection = ChestConfig.SimplePriority.MEDIUM;
                    }
                });
                if (config.simplePrioritySelection == null) {
                    config.simplePrioritySelection = ChestConfig.SimplePriority.MEDIUM;
                }
                this.chestConfigs.put(pos, config);
            }));
        }
        if (!this.chestConfigs.isEmpty()) {
            Map<class_2338, Integer> recalculated = this.priorityManager.recalculateAll(this.chestConfigs);
            for (Map.Entry<class_2338, Integer> entry : recalculated.entrySet()) {
                ChestConfig config = this.chestConfigs.get(entry.getKey());
                if (config == null) continue;
                config.priority = entry.getValue();
                config.updateHiddenPriority();
            }
        }
    }

    public Map<class_2338, ChestConfig> getAllConfigs() {
        return new LinkedHashMap<class_2338, ChestConfig>(this.chestConfigs);
    }

    private void applyPriorityUpdates(class_1937 world, Map<class_2338, Integer> newPriorities) {
        for (Map.Entry<class_2338, Integer> entry : newPriorities.entrySet()) {
            ChestConfig config = this.chestConfigs.get(entry.getKey());
            if (config == null) continue;
            config.priority = entry.getValue();
            config.updateHiddenPriority();
            this.syncConfigToProbe(world, config);
        }
        this.probeRegistry.invalidateCache();
        this.sendPriorityUpdatesToClients(world);
    }

    private void syncConfigToProbe(class_1937 world, ChestConfig config) {
        if (world == null) {
            return;
        }
        for (class_2338 probePos : this.probeRegistry.getLinkedProbes()) {
            OutputProbeBlockEntity probe;
            class_2338 targetPos;
            class_2586 be = world.method_8321(probePos);
            if (!(be instanceof OutputProbeBlockEntity) || (targetPos = (probe = (OutputProbeBlockEntity)be).getTargetPos()) == null || !targetPos.equals((Object)config.position)) continue;
            probe.updateLocalConfig(config.copy());
        }
    }

    private void sendPriorityUpdatesToClients(class_1937 world) {
        if (!(world instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)world;
        ChestPriorityBatchPayload payload = ChestPriorityBatchPayload.fromConfigs(this.chestConfigs);
        for (class_3222 player : serverWorld.method_18456()) {
            class_1703 class_17032 = player.field_7512;
            if (!(class_17032 instanceof StorageControllerScreenHandler)) continue;
            StorageControllerScreenHandler handler = (StorageControllerScreenHandler)class_17032;
            ServerPlayNetworking.send((class_3222)player, (class_8710)payload);
        }
    }

    public int calculateChestFullness(class_1937 world, class_2338 chestPos, List<class_2338> linkedProbes) {
        if (world == null) {
            return -1;
        }
        for (class_2338 probePos : linkedProbes) {
            OutputProbeBlockEntity probe;
            class_2338 targetPos;
            class_2586 be = world.method_8321(probePos);
            if (!(be instanceof OutputProbeBlockEntity) || (targetPos = (probe = (OutputProbeBlockEntity)be).getTargetPos()) == null || !targetPos.equals((Object)chestPos)) continue;
            class_1263 inv = probe.getTargetInventory();
            if (inv == null) {
                return -1;
            }
            int totalSlots = inv.method_5439();
            int occupiedSlots = 0;
            for (int i = 0; i < totalSlots; ++i) {
                if (inv.method_5438(i).method_7960()) continue;
                ++occupiedSlots;
            }
            return totalSlots > 0 ? occupiedSlots * 100 / totalSlots : 0;
        }
        return -1;
    }

    private List<class_1799> getChestPreviewItems(class_1937 world, class_2338 chestPos, List<class_2338> linkedProbes) {
        ArrayList<class_1799> items = new ArrayList<class_1799>();
        if (world == null) {
            return items;
        }
        for (class_2338 probePos : linkedProbes) {
            OutputProbeBlockEntity probe;
            class_2338 targetPos;
            class_2586 be = world.method_8321(probePos);
            if (!(be instanceof OutputProbeBlockEntity) || (targetPos = (probe = (OutputProbeBlockEntity)be).getTargetPos()) == null || !targetPos.equals((Object)chestPos)) continue;
            class_1263 inv = probe.getTargetInventory();
            if (inv == null) break;
            for (int i = 0; i < inv.method_5439() && items.size() < 8; ++i) {
                class_1799 stack = inv.method_5438(i);
                if (stack.method_7960()) continue;
                items.add(stack.method_7972());
            }
        }
        return items;
    }

    private void writeNameToChest(class_1937 world, class_2338 chestPos, String customName) {
        if (world == null) {
            return;
        }
        class_2586 blockEntity = world.method_8321(chestPos);
        if (blockEntity == null) {
            return;
        }
        class_2487 nbt = blockEntity.method_38244((class_7225.class_7874)world.method_30349());
        if (customName == null || customName.isEmpty()) {
            nbt.method_10551("CustomName");
        } else {
            class_5250 textComponent = class_2561.method_43470((String)customName);
            DataResult result = class_8824.field_46597.encodeStart((DynamicOps)world.method_30349().method_57093((DynamicOps)class_2509.field_11560), (Object)textComponent);
            result.result().ifPresent(nbtElement -> nbt.method_10566("CustomName", nbtElement));
        }
        try (class_8942.class_11340 logging = new class_8942.class_11340(blockEntity.method_71402(), LogUtils.getLogger());){
            blockEntity.method_58690(class_11352.method_71417((class_8942)logging, (class_7225.class_7874)world.method_30349(), (class_2487)nbt));
        }
        blockEntity.method_5431();
        class_2680 state = world.method_8320(chestPos);
        world.method_8413(chestPos, state, state, 3);
    }

    private String readNameFromChest(class_1937 world, class_2338 chestPos) {
        if (world == null) {
            return "";
        }
        class_2586 blockEntity = world.method_8321(chestPos);
        if (blockEntity == null) {
            return "";
        }
        class_2487 nbt = blockEntity.method_38244((class_7225.class_7874)world.method_30349());
        if (nbt.method_10545("CustomName")) {
            try {
                DataResult result = class_8824.field_46597.parse((DynamicOps)world.method_30349().method_57093((DynamicOps)class_2509.field_11560), (Object)nbt.method_10580("CustomName"));
                return result.result().map(class_2561::getString).orElse("");
            }
            catch (Exception e) {
                return "";
            }
        }
        return "";
    }

    private void clearNameFromChest(class_1937 world, class_2338 chestPos) {
        if (world == null) {
            return;
        }
        class_2586 blockEntity = world.method_8321(chestPos);
        if (blockEntity == null) {
            return;
        }
        class_2487 nbt = blockEntity.method_38244((class_7225.class_7874)world.method_30349());
        if (nbt.method_10545("CustomName")) {
            nbt.method_10551("CustomName");
            try (class_8942.class_11340 logging = new class_8942.class_11340(blockEntity.method_71402(), LogUtils.getLogger());){
                blockEntity.method_58690(class_11352.method_71417((class_8942)logging, (class_7225.class_7874)world.method_30349(), (class_2487)nbt));
            }
            blockEntity.method_5431();
            class_2680 state = world.method_8320(chestPos);
            world.method_8413(chestPos, state, state, 3);
        }
    }
}

