/*
 * Decompiled with CFR 0.152.
 */
package net.shaddii.smartsorter.blockentity.controller;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.shaddii.smartsorter.blockentity.OutputProbeBlockEntity;
import net.shaddii.smartsorter.blockentity.controller.NetworkInventoryManager;
import net.shaddii.smartsorter.blockentity.controller.ProbeRegistry;
import net.shaddii.smartsorter.util.ChestConfig;

public class ItemRoutingService {
    private static final InsertionResult EMPTY_SUCCESS = new InsertionResult(class_1799.field_8037, false, null, null);
    private final ProbeRegistry probeRegistry;
    private final Map<class_2338, OutputProbeBlockEntity> probeCache = new HashMap<class_2338, OutputProbeBlockEntity>();

    public ItemRoutingService(ProbeRegistry probeRegistry) {
        this.probeRegistry = probeRegistry;
    }

    public InsertionResult insertItem(class_1937 world, class_1799 stack) {
        if (world == null || stack.method_7960()) {
            return new InsertionResult(stack, false, null, null);
        }
        this.probeCache.clear();
        ItemVariant variant = ItemVariant.of((class_1799)stack);
        class_1799 remaining = stack.method_7972();
        class_2338 insertedInto = null;
        String insertedIntoName = null;
        boolean potentialOverflow = false;
        List<class_2338> sortedProbes = this.probeRegistry.getSortedProbes(world);
        for (class_2338 probePos : sortedProbes) {
            ChestConfig config;
            if (remaining.method_7960()) break;
            OutputProbeBlockEntity probe = this.getCachedProbe(world, probePos);
            if (probe == null || (config = probe.getChestConfig()) == null || config.filterMode == ChestConfig.FilterMode.NONE || config.filterMode == ChestConfig.FilterMode.OVERFLOW || !probe.accepts(variant)) continue;
            int inserted = this.insertIntoInventory(world, probe, remaining);
            if (inserted > 0 && insertedInto == null) {
                insertedInto = probe.getTargetPos();
                insertedIntoName = this.getChestDisplayName(config);
            }
            remaining.method_7934(inserted);
        }
        if (remaining.method_7960()) {
            return new InsertionResult(class_1799.field_8037, false, insertedInto, insertedIntoName);
        }
        potentialOverflow = true;
        boolean didOverflow = false;
        for (class_2338 probePos : sortedProbes) {
            ChestConfig config;
            if (remaining.method_7960()) break;
            OutputProbeBlockEntity probe = this.getCachedProbe(world, probePos);
            if (probe == null || (config = probe.getChestConfig()) == null || config.filterMode != ChestConfig.FilterMode.NONE && config.filterMode != ChestConfig.FilterMode.OVERFLOW || !probe.accepts(variant)) continue;
            int inserted = this.insertIntoInventory(world, probe, remaining);
            if (inserted > 0) {
                if (insertedInto == null) {
                    insertedInto = probe.getTargetPos();
                    insertedIntoName = this.getChestDisplayName(config);
                }
                if (potentialOverflow && config.filterMode == ChestConfig.FilterMode.OVERFLOW) {
                    didOverflow = true;
                }
            }
            remaining.method_7934(inserted);
        }
        if (remaining.method_7960() && !didOverflow && insertedInto == null) {
            return EMPTY_SUCCESS;
        }
        return new InsertionResult(remaining, didOverflow, insertedInto, insertedIntoName);
    }

    public class_1799 extractItem(class_1937 world, ItemVariant variant, int amount, NetworkInventoryManager networkManager) {
        int totalExtracted;
        if (world == null || amount <= 0) {
            return class_1799.field_8037;
        }
        List<class_2338> probesWithItem = networkManager.getProbesWithItem(variant);
        if (probesWithItem.isEmpty()) {
            return class_1799.field_8037;
        }
        int remaining = amount;
        for (class_2338 probePos : new ArrayList<class_2338>(probesWithItem)) {
            OutputProbeBlockEntity probe;
            Storage<ItemVariant> storage;
            if (remaining <= 0) break;
            class_2586 be = world.method_8321(probePos);
            if (!(be instanceof OutputProbeBlockEntity) || (storage = (probe = (OutputProbeBlockEntity)be).getTargetStorage()) == null) continue;
            int extracted = this.extractFromInventory(world, probe, variant, remaining);
            remaining -= extracted;
        }
        return (totalExtracted = amount - remaining) > 0 ? variant.toStack(totalExtracted) : class_1799.field_8037;
    }

    private int insertIntoInventory(class_1937 world, OutputProbeBlockEntity probe, class_1799 stack) {
        int maxStack;
        class_1799 slotStack;
        int i;
        class_1263 inv = probe.getTargetInventory();
        if (inv == null) {
            return 0;
        }
        int originalCount = stack.method_7947();
        for (i = 0; i < inv.method_5439() && !stack.method_7960(); ++i) {
            int canAdd;
            slotStack = inv.method_5438(i);
            if (slotStack.method_7960() || !class_1799.method_31577((class_1799)slotStack, (class_1799)stack) || (canAdd = (maxStack = Math.min(slotStack.method_7914(), inv.method_5444())) - slotStack.method_7947()) <= 0) continue;
            int toAdd = Math.min(canAdd, stack.method_7947());
            slotStack.method_7933(toAdd);
            stack.method_7934(toAdd);
            inv.method_5431();
        }
        for (i = 0; i < inv.method_5439() && !stack.method_7960(); ++i) {
            slotStack = inv.method_5438(i);
            if (!slotStack.method_7960()) continue;
            maxStack = Math.min(stack.method_7914(), inv.method_5444());
            int toAdd = Math.min(maxStack, stack.method_7947());
            class_1799 newStack = stack.method_7972();
            newStack.method_7939(toAdd);
            inv.method_5447(i, newStack);
            stack.method_7934(toAdd);
            inv.method_5431();
        }
        return originalCount - stack.method_7947();
    }

    private int extractFromInventory(class_1937 world, OutputProbeBlockEntity probe, ItemVariant variant, int amount) {
        class_1263 inv = probe.getTargetInventory();
        if (inv == null) {
            return 0;
        }
        int extracted = 0;
        for (int i = 0; i < inv.method_5439() && extracted < amount; ++i) {
            ItemVariant stackVariant;
            class_1799 stack = inv.method_5438(i);
            if (stack.method_7960() || !(stackVariant = ItemVariant.of((class_1799)stack)).equals((Object)variant)) continue;
            int toExtract = Math.min(amount - extracted, stack.method_7947());
            stack.method_7934(toExtract);
            inv.method_5431();
            extracted += toExtract;
        }
        return extracted;
    }

    private OutputProbeBlockEntity getCachedProbe(class_1937 world, class_2338 pos) {
        return this.probeCache.computeIfAbsent(pos, p -> {
            OutputProbeBlockEntity probe;
            class_2586 be = world.method_8321(p);
            return be instanceof OutputProbeBlockEntity ? (probe = (OutputProbeBlockEntity)be) : null;
        });
    }

    private String getChestDisplayName(ChestConfig config) {
        if (config.customName != null && !config.customName.isEmpty()) {
            return config.customName;
        }
        return config.filterCategory.getDisplayName() + " Storage";
    }

    public record InsertionResult(class_1799 remainder, boolean overflowed, class_2338 destination, String destinationName) {
    }
}

