/*
 * Decompiled with CFR 0.152.
 */
package net.shaddii.smartsorter.blockentity.processor;

import java.util.Map;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2609;
import net.minecraft.class_3218;
import net.minecraft.class_3956;
import net.shaddii.smartsorter.blockentity.StorageControllerBlockEntity;
import net.shaddii.smartsorter.blockentity.processor.ExperienceCollector;
import net.shaddii.smartsorter.blockentity.processor.RecipeValidator;
import net.shaddii.smartsorter.util.ProcessProbeConfig;

public class SmeltingProcessor {
    private static final int MAX_FUEL_PER_INSERT = 16;
    private static final int MAX_INPUT_PER_INSERT = 4;
    private final RecipeValidator recipeValidator;
    private final ExperienceCollector xpCollector;
    private int itemsProcessed = 0;

    public SmeltingProcessor(RecipeValidator validator, ExperienceCollector collector) {
        this.recipeValidator = validator;
        this.xpCollector = collector;
    }

    public void processSmeltingMachine(class_3218 world, class_2338 probePos, class_2609 machine, StorageControllerBlockEntity controller, ProcessProbeConfig config) {
        boolean outputsHandled = this.extractOutputs(world, probePos, (class_1263)machine, controller);
        if (!outputsHandled) {
            return;
        }
        SmeltingNeeds needs = this.analyzeSmeltingNeeds(machine);
        if (!needs.needsInput && !needs.needsFuel) {
            return;
        }
        Map<ItemVariant, Long> networkItems = controller.getNetworkItems();
        class_3956<?> recipeType = this.recipeValidator.getRecipeType(machine);
        if (needs.needsInput) {
            this.supplyInput(world, machine, controller, networkItems, needs, recipeType, config);
        }
        if (needs.needsFuel) {
            this.supplyFuel(world, machine, controller, networkItems, needs, config);
        }
    }

    private boolean extractOutputs(class_3218 world, class_2338 probePos, class_1263 inventory, StorageControllerBlockEntity controller) {
        boolean allExtracted = true;
        int outputSlot = 2;
        class_1799 output = inventory.method_5438(outputSlot);
        if (!output.method_7960()) {
            class_1799 toInsert = output.method_7972();
            class_1799 remaining = controller.insertItem(toInsert).remainder();
            if (remaining.method_7960()) {
                class_2609 smeltingMachine;
                int xp;
                if (inventory instanceof class_2609 && (xp = this.xpCollector.collectFurnaceExperience(world, smeltingMachine = (class_2609)inventory, toInsert)) > 0) {
                    controller.addExperience(xp);
                }
                inventory.method_5447(outputSlot, class_1799.field_8037);
                inventory.method_5431();
                this.itemsProcessed += toInsert.method_7947();
                controller.syncProbeStatsToClients(probePos, this.itemsProcessed);
            } else {
                allExtracted = false;
            }
        }
        return allExtracted;
    }

    private void supplyInput(class_3218 world, class_2609 machine, StorageControllerBlockEntity controller, Map<ItemVariant, Long> networkItems, SmeltingNeeds needs, class_3956<?> recipeType, ProcessProbeConfig config) {
        for (Map.Entry<ItemVariant, Long> entry : networkItems.entrySet()) {
            if (entry.getValue() <= 0L) continue;
            ItemVariant variant = entry.getKey();
            if (needs.currentInput.method_7960() ? !this.recipeValidator.canSmelt(world, variant, machine, recipeType) || !this.recipeValidator.matchesRecipeFilter(variant, config.recipeFilter) : !ItemVariant.of((class_1799)needs.currentInput).equals((Object)variant)) continue;
            int amount = (int)Math.min((long)needs.inputSpace, entry.getValue());
            class_1799 extracted = controller.extractItem(variant, amount);
            if (extracted.method_7960()) continue;
            class_1799 existing = machine.method_5438(0);
            if (existing.method_7960()) {
                machine.method_5447(0, extracted);
            } else {
                existing.method_7933(extracted.method_7947());
            }
            machine.method_5431();
            break;
        }
    }

    private void supplyFuel(class_3218 world, class_2609 machine, StorageControllerBlockEntity controller, Map<ItemVariant, Long> networkItems, SmeltingNeeds needs, ProcessProbeConfig config) {
        for (Map.Entry<ItemVariant, Long> entry : networkItems.entrySet()) {
            if (entry.getValue() <= 0L) continue;
            ItemVariant variant = entry.getKey();
            if (needs.currentFuel.method_7960() ? !this.recipeValidator.isFuel(world, variant) || !this.recipeValidator.matchesFuelFilter(variant, config.fuelFilter) : !ItemVariant.of((class_1799)needs.currentFuel).equals((Object)variant)) continue;
            int amount = (int)Math.min((long)needs.fuelSpace, entry.getValue());
            class_1799 extracted = controller.extractItem(variant, amount);
            if (extracted.method_7960()) continue;
            class_1799 existing = machine.method_5438(1);
            if (existing.method_7960()) {
                machine.method_5447(1, extracted);
            } else {
                existing.method_7933(extracted.method_7947());
            }
            machine.method_5431();
            break;
        }
    }

    private SmeltingNeeds analyzeSmeltingNeeds(class_2609 machine) {
        SmeltingNeeds needs = new SmeltingNeeds();
        class_1799 input = machine.method_5438(0);
        if (input.method_7960()) {
            needs.needsInput = true;
            needs.inputSpace = 4;
        } else if (input.method_7947() < input.method_7914()) {
            needs.needsInput = true;
            needs.currentInput = input;
            needs.inputSpace = Math.min(input.method_7914() - input.method_7947(), 4);
        }
        class_1799 fuel = machine.method_5438(1);
        if (fuel.method_7960()) {
            needs.needsFuel = true;
            needs.fuelSpace = 16;
        } else if (fuel.method_7947() < fuel.method_7914()) {
            needs.needsFuel = true;
            needs.currentFuel = fuel;
            needs.fuelSpace = Math.min(fuel.method_7914() - fuel.method_7947(), 16);
        }
        return needs;
    }

    public int getItemsProcessed() {
        return this.itemsProcessed;
    }

    public void setItemsProcessed(int count) {
        this.itemsProcessed = count;
    }

    private static class SmeltingNeeds {
        boolean needsInput = false;
        boolean needsFuel = false;
        int inputSpace = 0;
        int fuelSpace = 0;
        class_1799 currentInput = class_1799.field_8037;
        class_1799 currentFuel = class_1799.field_8037;

        private SmeltingNeeds() {
        }
    }
}

