/*
 * Decompiled with CFR 0.152.
 */
package net.shaddii.smartsorter.client;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fc;
import org.joml.Vector2f;
import org.joml.Vector2fc;

public class OverflowNotificationOverlay {
    private static final List<OverflowEntry> entries = new ArrayList<OverflowEntry>();
    private static final long DISPLAY_DURATION = 8000L;
    private static final long FADE_DURATION = 1000L;
    private static final int MAX_VISIBLE = 6;
    private static final int ENTRY_HEIGHT = 18;
    private static final int PANEL_WIDTH = 100;
    private static final int PADDING = 4;
    private static final float TEXT_SCALE = 0.65f;
    private static final int ICON_SIZE = 16;
    private static final int PANEL_Y_OFFSET = 10;
    private static float scrollOffset = 0.0f;
    private static final float SCROLL_SPEED = 20.0f;
    private static long lastScrollTime = 0L;
    private static final long SCROLL_PAUSE_DURATION = 3000L;

    public static void show(Map<ItemVariant, Long> overflowItems, Map<ItemVariant, String> destinations) {
        for (Map.Entry<ItemVariant, Long> entry : overflowItems.entrySet()) {
            String destName = destinations.getOrDefault(entry.getKey(), "Overflow Storage");
            OverflowNotificationOverlay.addOverflowNotification(entry.getKey(), entry.getValue(), destName);
        }
    }

    public static void addOverflowNotification(ItemVariant variant, long amount, String destinationName) {
        for (OverflowEntry entry : entries) {
            if (!entry.variant.equals((Object)variant)) continue;
            entries.remove(entry);
            break;
        }
        entries.add(0, new OverflowEntry(variant, amount, destinationName));
    }

    public static boolean isActive() {
        return !entries.isEmpty();
    }

    public static void dismiss() {
        entries.clear();
        scrollOffset = 0.0f;
    }

    public static void scroll(int direction) {
        if (entries.size() <= 6) {
            return;
        }
        scrollOffset = Math.max(0.0f, Math.min((float)(entries.size() - 6), scrollOffset + (float)direction));
        for (OverflowEntry entry : entries) {
            entry.extendLifetime(200L);
        }
        lastScrollTime = System.currentTimeMillis();
    }

    public static void render(class_332 context, float tickDelta) {
        if (entries.isEmpty()) {
            return;
        }
        class_310 client = class_310.method_1551();
        class_327 textRenderer = client.field_1772;
        int screenWidth = client.method_22683().method_4486();
        entries.removeIf(OverflowEntry::shouldRemove);
        int visibleCount = Math.min(entries.size(), 6);
        int panelHeight = visibleCount * 18 + 8;
        int panelX = screenWidth - 100 - 10;
        int panelY = 10;
        float panelAlpha = 1.0f;
        if (!entries.isEmpty()) {
            panelAlpha = entries.get(0).getAlpha();
        }
        int alphaInt = (int)(panelAlpha * 208.0f) << 24;
        int bgColor = alphaInt | 0;
        context.method_25294(panelX, panelY, panelX + 100, panelY + panelHeight, bgColor);
        int borderAlpha = (int)(panelAlpha * 255.0f) << 24;
        int borderColor = borderAlpha | 0x555555;
        context.method_25294(panelX, panelY, panelX + 100, panelY + 1, borderColor);
        context.method_25294(panelX, panelY + panelHeight - 1, panelX + 100, panelY + panelHeight, borderColor);
        context.method_25294(panelX, panelY, panelX + 1, panelY + panelHeight, borderColor);
        context.method_25294(panelX + 100 - 1, panelY, panelX + 100, panelY + panelHeight, borderColor);
        if (entries.size() > 6) {
            int scrollBarHeight = Math.max(10, 6 * panelHeight / entries.size());
            int scrollBarY = panelY + (int)(scrollOffset / (float)entries.size() * (float)panelHeight);
            int scrollBarX = panelX + 100 - 4;
            int scrollbarColor = borderAlpha | 0xAAAAAA;
            context.method_25294(scrollBarX, scrollBarY, scrollBarX + 2, scrollBarY + scrollBarHeight, scrollbarColor);
        }
        int startIndex = (int)scrollOffset;
        int endIndex = Math.min(startIndex + 6, entries.size());
        for (int i = startIndex; i < endIndex; ++i) {
            OverflowEntry entry = entries.get(i);
            int entryY = panelY + 4 + (i - startIndex) * 18;
            float alpha = entry.getAlpha();
            if (alpha <= 0.0f) continue;
            OverflowNotificationOverlay.renderEntry(context, textRenderer, entry, panelX + 4, entryY, 92, alpha);
        }
    }

    private static void renderEntry(class_332 context, class_327 textRenderer, OverflowEntry entry, int x, int y, int width, float alpha) {
        int alphaInt = (int)(alpha * 255.0f);
        int textColor = alphaInt << 24 | 0xFFFFFF;
        int amountColor = alphaInt << 24 | 0xFFAA00;
        int destColor = alphaInt << 24 | 0x55FF55;
        class_1799 stack = entry.variant.toStack();
        context.method_51448().pushMatrix();
        context.method_51448().translate((Vector2fc)new Vector2f((float)x, (float)y));
        context.method_51427(stack, 0, 0);
        context.method_51448().popMatrix();
        int textX = x + 16 + 3;
        int textY = y;
        Object itemName = entry.variant.getItem().method_63680().getString();
        if (((String)itemName).length() > 18) {
            itemName = ((String)itemName).substring(0, 15) + "...";
        }
        OverflowNotificationOverlay.drawScaledText(context, textRenderer, (String)itemName, textX, textY, textColor, 0.65f);
        String amountText = String.format("%,d", entry.amount);
        Object destText = entry.destinationName;
        if (((String)destText).length() > 14) {
            destText = ((String)destText).substring(0, 11) + "...";
        }
        String bottomLine = "\u00a76" + amountText + " \u00a77\u2192 \u00a7a" + (String)destText;
        OverflowNotificationOverlay.drawScaledText(context, textRenderer, bottomLine, textX, textY + 8, amountColor, 0.5525f);
    }

    private static void drawScaledText(class_332 context, class_327 textRenderer, String text, int x, int y, int color, float scale) {
        Matrix3x2f oldMatrix = new Matrix3x2f((Matrix3x2fc)context.method_51448());
        Matrix3x2f scaleMatrix = new Matrix3x2f().scaling(scale, scale);
        context.method_51448().mul((Matrix3x2fc)scaleMatrix);
        Matrix3x2f translateMatrix = new Matrix3x2f().translation((float)x / scale, (float)y / scale);
        context.method_51448().mul((Matrix3x2fc)translateMatrix);
        context.method_51433(textRenderer, text, 0, 0, color, false);
        context.method_51448().set((Matrix3x2fc)oldMatrix);
    }

    public static boolean handleMouseScroll(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        boolean isHovering;
        if (entries.isEmpty() || entries.size() <= 6) {
            return false;
        }
        class_310 client = class_310.method_1551();
        int screenWidth = client.method_22683().method_4486();
        int panelX = screenWidth - 100 - 10;
        int panelY = 10;
        int visibleCount = Math.min(entries.size(), 6);
        int panelHeight = visibleCount * 18 + 8;
        boolean bl = isHovering = mouseX >= (double)panelX && mouseX < (double)(panelX + 100) && mouseY >= (double)panelY && mouseY < (double)(panelY + panelHeight);
        if (isHovering) {
            scrollOffset = Math.max(0.0f, Math.min((float)(entries.size() - 6), scrollOffset - (float)(verticalAmount * 20.0 / 100.0)));
            for (OverflowEntry entry : entries) {
                entry.extendLifetime(200L);
            }
            lastScrollTime = System.currentTimeMillis();
            return true;
        }
        return false;
    }

    public static boolean handleMouseClick(double mouseX, double mouseY, int button) {
        boolean isHovering;
        if (entries.isEmpty()) {
            return false;
        }
        class_310 client = class_310.method_1551();
        int screenWidth = client.method_22683().method_4486();
        int panelX = screenWidth - 100 - 10;
        int panelY = 10;
        int visibleCount = Math.min(entries.size(), 6);
        int panelHeight = visibleCount * 18 + 8;
        boolean bl = isHovering = mouseX >= (double)panelX && mouseX < (double)(panelX + 100) && mouseY >= (double)panelY && mouseY < (double)(panelY + panelHeight);
        if (isHovering && button == 2) {
            long timeSinceScroll = System.currentTimeMillis() - lastScrollTime;
            if (timeSinceScroll > 500L) {
                entries.clear();
                scrollOffset = 0.0f;
                lastScrollTime = 0L;
                return true;
            }
            return true;
        }
        return isHovering;
    }

    public static void clear() {
        entries.clear();
        scrollOffset = 0.0f;
    }

    private static class OverflowEntry {
        final ItemVariant variant;
        final long amount;
        final String destinationName;
        long creationTime;

        OverflowEntry(ItemVariant variant, long amount, String destinationName) {
            this.variant = variant;
            this.amount = amount;
            this.destinationName = destinationName;
            this.creationTime = System.currentTimeMillis();
        }

        float getAlpha() {
            long elapsed = System.currentTimeMillis() - this.creationTime;
            if (elapsed < 7000L) {
                return 1.0f;
            }
            float fadeProgress = (float)(elapsed - 7000L) / 1000.0f;
            return Math.max(0.0f, 1.0f - fadeProgress);
        }

        boolean shouldRemove() {
            long elapsed = System.currentTimeMillis() - this.creationTime;
            return elapsed > 8000L;
        }

        void extendLifetime(long milliseconds) {
            this.creationTime = Math.min(this.creationTime + milliseconds, System.currentTimeMillis());
        }
    }
}

