/*
 * Decompiled with CFR 0.152.
 */
package net.shaddii.smartsorter.client;

import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;

public class SortProgressOverlay {
    private static int currentProgress = 0;
    private static int totalChests = 0;
    private static boolean isActive = false;
    private static long lastUpdateTime = 0L;
    private static final long FADE_DELAY = 2000L;
    private static final int PROGRESS_Y_OFFSET = 140;

    public static void updateProgress(int current, int total, boolean complete) {
        currentProgress = current;
        totalChests = total;
        isActive = !complete || System.currentTimeMillis() - lastUpdateTime < 2000L;
        lastUpdateTime = System.currentTimeMillis();
        if (complete) {
            isActive = true;
        }
    }

    public static void render(class_332 context) {
        long timeSinceComplete;
        if (!isActive || totalChests == 0) {
            return;
        }
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null) {
            return;
        }
        int screenWidth = client.method_22683().method_4486();
        int barWidth = 100;
        int barHeight = 5;
        int xOffset = 10;
        int yOffset = 10;
        float textScale = 0.75f;
        int textGap = 2;
        int x = screenWidth - barWidth - xOffset;
        int y = 140;
        float alpha = 1.0f;
        if (currentProgress >= totalChests && (timeSinceComplete = System.currentTimeMillis() - lastUpdateTime) > 1500L) {
            alpha = Math.max(0.0f, 1.0f - (float)(timeSinceComplete - 1500L) / 500.0f);
        }
        if (alpha <= 0.0f) {
            isActive = false;
            return;
        }
        int alphaInt = (int)(alpha * 255.0f) << 24;
        float progressPercent = (float)currentProgress / (float)totalChests;
        int progressWidth = (int)((float)barWidth * progressPercent);
        context.method_25294(x, y, x + barWidth, y + barHeight, alphaInt | 0x3A3A3A);
        int barColor = currentProgress >= totalChests ? 0x55FF55 : 0xFFAA00;
        context.method_25294(x, y, x + progressWidth, y + barHeight, alphaInt | barColor);
        context.method_25294(x, y, x + barWidth, y + 1, alphaInt | 0);
        context.method_25294(x, y + barHeight - 1, x + barWidth, y + barHeight, alphaInt | 0);
        String statusText = currentProgress >= totalChests ? "\u2713 Sorted " + totalChests + " chests" : "Sorting " + currentProgress + "/" + totalChests;
        int fullTextWidth = client.field_1772.method_1727(statusText);
        int scaledTextWidth = (int)((float)fullTextWidth * textScale);
        int textX = x + (barWidth - scaledTextWidth) / 2;
        int textY = y + barHeight + textGap;
        context.method_51448().pushMatrix();
        context.method_51448().translate((float)textX, (float)textY);
        context.method_51448().scale(textScale, textScale);
        context.method_51439(client.field_1772, (class_2561)class_2561.method_43470((String)statusText), 0, 0, 0xFFFFFFFF | alphaInt, true);
        context.method_51448().popMatrix();
    }
}

