/*
 * Decompiled with CFR 0.152.
 */
package net.shaddii.smartsorter.widget;

import java.util.function.Consumer;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_11909;
import net.minecraft.class_11910;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_8710;
import net.shaddii.smartsorter.network.ProbeConfigUpdatePayload;
import net.shaddii.smartsorter.util.FuelFilterMode;
import net.shaddii.smartsorter.util.ProcessProbeConfig;
import net.shaddii.smartsorter.util.RecipeFilterMode;
import net.shaddii.smartsorter.widget.CheckboxWidget;
import net.shaddii.smartsorter.widget.DropdownWidget;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fc;

public class ProbeConfigPanel {
    private long lastStatusChangeTime = 0L;
    private boolean previousEnabledState = false;
    private final int x;
    private final int y;
    private final int width;
    private final int height;
    private final class_327 textRenderer;
    private ProcessProbeConfig config;
    private CheckboxWidget enabledCheckbox;
    private DropdownWidget recipeFilterDropdown;
    private DropdownWidget fuelFilterDropdown;
    private Consumer<ProcessProbeConfig> onConfigUpdate;
    private long warningStartTime = 0L;
    private static final long WARNING_BLINK_DURATION = 500L;
    private static final int PADDING = 5;
    private static final int LINE_HEIGHT = 11;
    private static final int DROPDOWN_WIDTH = 80;
    private static final int DROPDOWN_HEIGHT = 10;

    public ProbeConfigPanel(int x, int y, int width, int height, class_327 textRenderer) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.textRenderer = textRenderer;
        this.initializeWidgets();
    }

    private void initializeWidgets() {
        int innerX = this.x + 5;
        int innerY = this.y + 18;
        this.enabledCheckbox = CheckboxWidget.builder((class_2561)class_2561.method_43470((String)"Enabled"), this.textRenderer).pos(innerX, innerY).dimensions(55, 9).callback(this::onEnabledChanged).build();
        this.recipeFilterDropdown = new DropdownWidget(innerX + 35, innerY + 12, 80, 10, (class_2561)class_2561.method_43470((String)""));
        this.fuelFilterDropdown = new DropdownWidget(innerX + 35, innerY + 25, 80, 10, (class_2561)class_2561.method_43470((String)""));
    }

    public void setConfig(ProcessProbeConfig newConfig) {
        this.config = newConfig;
        if (this.config == null) {
            return;
        }
        this.enabledCheckbox.setChecked(this.config.enabled);
        this.setupRecipeFilterDropdown();
        this.setupFuelFilterDropdown();
    }

    private void setupRecipeFilterDropdown() {
        this.recipeFilterDropdown.clearEntries();
        RecipeFilterMode[] validFilters = this.config.getValidRecipeFilters();
        boolean currentFilterIsValid = this.config.isRecipeFilterValid();
        for (RecipeFilterMode mode : validFilters) {
            this.recipeFilterDropdown.addEntry(mode.getDisplayName(), mode.getDisplayName());
        }
        if (!currentFilterIsValid) {
            String invalidLabel = "\u00a7c" + this.config.recipeFilter.getDisplayName();
            this.recipeFilterDropdown.addEntry(invalidLabel, this.config.recipeFilter.getDisplayName());
            this.recipeFilterDropdown.setSelectedIndex(validFilters.length);
            this.warningStartTime = System.currentTimeMillis();
        } else {
            for (int i = 0; i < validFilters.length; ++i) {
                if (validFilters[i] != this.config.recipeFilter) continue;
                this.recipeFilterDropdown.setSelectedIndex(i);
                break;
            }
            this.warningStartTime = 0L;
        }
        this.recipeFilterDropdown.setOnSelect(index -> {
            if (this.config != null && index < validFilters.length) {
                this.config.recipeFilter = validFilters[index];
                this.warningStartTime = 0L;
                this.sendConfigUpdate();
                this.notifyUpdate();
                this.setupRecipeFilterDropdown();
            }
        });
    }

    private void setupFuelFilterDropdown() {
        this.fuelFilterDropdown.clearEntries();
        for (FuelFilterMode mode : FuelFilterMode.values()) {
            this.fuelFilterDropdown.addEntry(mode.getDisplayName(), mode.getDisplayName());
        }
        this.fuelFilterDropdown.setSelectedIndex(this.config.fuelFilter.ordinal());
        this.fuelFilterDropdown.setOnSelect(index -> {
            if (this.config != null) {
                this.config.fuelFilter = FuelFilterMode.values()[index];
                this.sendConfigUpdate();
                this.notifyUpdate();
            }
        });
    }

    private void onEnabledChanged(boolean checked) {
        if (this.config != null) {
            if (this.config.enabled != checked) {
                this.lastStatusChangeTime = System.currentTimeMillis();
                this.previousEnabledState = this.config.enabled;
            }
            this.config.enabled = checked;
            this.sendConfigUpdate();
            this.notifyUpdate();
        }
    }

    private void sendConfigUpdate() {
        if (this.config != null) {
            ClientPlayNetworking.send((class_8710)new ProbeConfigUpdatePayload(this.config.position, this.config.customName, this.config.enabled, this.config.recipeFilter, this.config.fuelFilter));
        }
    }

    private void notifyUpdate() {
        if (this.onConfigUpdate != null && this.config != null) {
            this.onConfigUpdate.accept(this.config);
        }
    }

    private void drawCenteredError(class_332 context, String error, int yPos) {
        float scale = 0.6f;
        int textWidth = (int)((float)this.textRenderer.method_1727(error) * scale);
        int centerX = this.x + this.width / 2 - textWidth / 2;
        this.drawScaledText(context, "\u00a7c" + error, centerX, yPos, -43691, scale);
    }

    public void render(class_332 context, int mouseX, int mouseY, float delta) {
        String error;
        this.drawBackground(context);
        if (this.config == null) {
            this.drawNoProbeMessage(context);
            return;
        }
        int currentY = this.y + 4;
        currentY = this.drawTitle(context, currentY);
        currentY = this.drawMachineInfo(context, currentY);
        currentY += 7;
        this.enabledCheckbox.method_25394(context, mouseX, mouseY, delta);
        currentY += 11;
        currentY = this.drawRecipeFilter(context, currentY, mouseX, mouseY, delta);
        this.drawFuelFilter(context, currentY += 13, mouseX, mouseY, delta);
        this.drawStatistics(context, currentY += 13);
        if (!this.config.isRecipeFilterValid() && (error = this.config.getValidationError()) != null) {
            this.drawCenteredError(context, error, currentY += 10);
        }
        this.renderDropdowns(context, mouseX, mouseY);
    }

    private void drawBackground(class_332 context) {
        context.method_25294(this.x, this.y, this.x + this.width, this.y + this.height, -13948117);
        context.method_25294(this.x + 1, this.y + 1, this.x + this.width - 1, this.y + this.height - 1, -12829636);
    }

    private void drawNoProbeMessage(class_332 context) {
        String message = "No probe selected";
        float scale = 0.65f;
        int scaledTextWidth = (int)((float)this.textRenderer.method_1727(message) * scale);
        int textX = this.x + this.width / 2 - scaledTextWidth / 2;
        int textY = this.y + this.height / 2 - 4;
        this.drawScaledText(context, message, textX, textY, -7829368, scale);
    }

    private int drawTitle(class_332 context, int currentY) {
        String title = "Configuration";
        String statusIcon = "";
        int statusColor = -1;
        if (this.config != null) {
            if (this.config.enabled) {
                statusIcon = " \u00a7a\u2713";
                statusColor = -11141291;
            } else {
                statusIcon = " \u00a7c\u2717";
                statusColor = -43691;
            }
            long timeSinceChange = System.currentTimeMillis() - this.lastStatusChangeTime;
            if (timeSinceChange < 1000L) {
                float pulse = (float)(Math.sin((double)timeSinceChange * 0.005) * 0.5 + 0.5);
                int alpha = 128 + (int)(127.0f * pulse);
                statusColor = alpha << 24 | statusColor & 0xFFFFFF;
            }
        }
        this.drawScaledText(context, title + statusIcon, this.x + 5, currentY, statusColor, 0.7f);
        return currentY + 8;
    }

    private int drawMachineInfo(class_332 context, int currentY) {
        int innerX = this.x + 5;
        String machineInfo = "\u00a77Type: \u00a7e" + this.config.machineType;
        this.drawScaledText(context, machineInfo, innerX, currentY, -1, 0.65f);
        String location = String.format("\u00a78[%d, %d, %d]", this.config.position.method_10263(), this.config.position.method_10264(), this.config.position.method_10260());
        int machineTextWidth = (int)((float)this.textRenderer.method_1727(machineInfo) * 0.65f);
        int locationX = innerX + machineTextWidth + 3;
        this.drawScaledText(context, location, locationX, currentY, -5592406, 0.65f);
        return currentY;
    }

    private int drawRecipeFilter(class_332 context, int currentY, int mouseX, int mouseY, float delta) {
        int innerX = this.x + 5;
        this.drawScaledText(context, "\u00a77Recipe:", innerX, currentY + 1, -5592406, 0.65f);
        if (!this.config.isRecipeFilterValid()) {
            this.drawWarningIcon(context, this.x + this.width - 15, this.y + 4);
            int dropdownEndX = innerX + 35 + 80;
            this.drawScaledText(context, "\u00a7c(Invalid)", dropdownEndX + 2, currentY + 1, -43691, 0.7f);
        }
        this.recipeFilterDropdown.method_25394(context, mouseX, mouseY, delta);
        return currentY;
    }

    private void drawFuelFilter(class_332 context, int currentY, int mouseX, int mouseY, float delta) {
        int innerX = this.x + 5;
        this.drawScaledText(context, "\u00a77Fuel:", innerX, currentY + 1, -5592406, 0.65f);
        this.fuelFilterDropdown.method_25394(context, mouseX, mouseY, delta);
    }

    private void drawStatistics(class_332 context, int currentY) {
        String statusText;
        int innerX = this.x + 5;
        if (this.config.enabled) {
            statusText = "\u00a7aActive";
            int statusColor = -11141291;
        } else {
            statusText = "\u00a7cDisabled";
            int statusColor = -43691;
        }
        String stats = String.format("%s \u00a77- Processed: \u00a7f%,d", statusText, this.config.itemsProcessed);
        this.drawScaledText(context, stats, innerX, currentY, -1, 0.65f);
    }

    private void drawWarningIcon(class_332 context, int iconX, int iconY) {
        boolean showWarning;
        long elapsed = System.currentTimeMillis() - this.warningStartTime;
        boolean bl = showWarning = elapsed / 500L % 2L == 0L;
        if (showWarning) {
            this.drawScaledText(context, "\u00a7c\u26a0", iconX, iconY, -1, 0.8f);
        }
    }

    private void drawScaledText(class_332 context, String text, int x, int y, int color, float scale) {
        Matrix3x2f oldMatrix = new Matrix3x2f((Matrix3x2fc)context.method_51448());
        Matrix3x2f scaleMatrix = new Matrix3x2f().scaling(scale, scale);
        context.method_51448().mul((Matrix3x2fc)scaleMatrix);
        Matrix3x2f translateMatrix = new Matrix3x2f().translation((float)x / scale, (float)y / scale);
        context.method_51448().mul((Matrix3x2fc)translateMatrix);
        context.method_51433(this.textRenderer, text, 0, 0, color, false);
        context.method_51448().set((Matrix3x2fc)oldMatrix);
    }

    private void renderDropdowns(class_332 context, int mouseX, int mouseY) {
        if (this.recipeFilterDropdown != null && this.recipeFilterDropdown.isOpen()) {
            this.recipeFilterDropdown.renderDropdown(context, mouseX, mouseY);
        }
        if (this.fuelFilterDropdown != null && this.fuelFilterDropdown.isOpen()) {
            this.fuelFilterDropdown.renderDropdown(context, mouseX, mouseY);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.config == null) {
            return false;
        }
        class_11910 mouseInput = new class_11910(button, 0);
        class_11909 click = new class_11909(mouseX, mouseY, mouseInput);
        if (this.enabledCheckbox.method_25402(click, false)) {
            return true;
        }
        if (this.recipeFilterDropdown.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        return this.fuelFilterDropdown.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double horizontal, double vertical) {
        if (this.recipeFilterDropdown.isOpen()) {
            return this.recipeFilterDropdown.method_25401(mouseX, mouseY, horizontal, vertical);
        }
        if (this.fuelFilterDropdown.isOpen()) {
            return this.fuelFilterDropdown.method_25401(mouseX, mouseY, horizontal, vertical);
        }
        return false;
    }

    public void setOnConfigUpdate(Consumer<ProcessProbeConfig> callback) {
        this.onConfigUpdate = callback;
    }

    public ProcessProbeConfig getConfig() {
        return this.config;
    }
}

