/*
 * Decompiled with CFR 0.152.
 */
package de.rayzs.pat.api.netty.bukkit.handlers;

import de.rayzs.pat.api.event.PATEventHandler;
import de.rayzs.pat.api.event.events.FilteredTabCompletionEvent;
import de.rayzs.pat.api.netty.bukkit.BukkitPacketAnalyzer;
import de.rayzs.pat.api.netty.bukkit.BukkitPacketHandler;
import de.rayzs.pat.api.storage.Storage;
import de.rayzs.pat.plugin.BukkitLoader;
import de.rayzs.pat.plugin.logger.Logger;
import de.rayzs.pat.utils.Reflection;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.entity.Player;

public class LegacyPacketHandler
implements BukkitPacketHandler {
    @Override
    public boolean handleIncomingPacket(Player player, Object packetObj) throws Exception {
        Field stringField = Reflection.getFirstFieldByType(packetObj.getClass(), "String", Reflection.SearchOption.ENDS);
        if (stringField == null) {
            Logger.warning("Failed PacketAnalyze process! (#1)");
            return false;
        }
        String text = (String)stringField.get(packetObj);
        BukkitPacketAnalyzer.insertPlayerInput(player, text);
        return true;
    }

    @Override
    public boolean handleOutgoingPacket(Player player, Object packetObj) throws Exception {
        boolean cancelsBeforeHand;
        String input = BukkitPacketAnalyzer.getPlayerInput(player);
        if (input == null) {
            return false;
        }
        int spaces = 0;
        if (input.startsWith("/")) {
            String[] split;
            if ((input = input.replace("/", "")).contains(" ") && (spaces = (split = input.split(" ")).length) > 0) {
                input = split[0];
            }
            if (!(cancelsBeforeHand = Storage.Blacklist.canPlayerAccessTab(player, input))) {
                cancelsBeforeHand = Storage.ConfigSections.Settings.CUSTOM_VERSION.isTabCompletable(input) || Storage.ConfigSections.Settings.CUSTOM_PLUGIN.isTabCompletable(input);
            }
        } else {
            return true;
        }
        for (Field field : Reflection.getFields(packetObj)) {
            FilteredTabCompletionEvent filteredTabCompletionEvent;
            field.setAccessible(true);
            Object result = field.get(packetObj);
            if (!(result instanceof String[])) continue;
            ArrayList<String> newResultList = new ArrayList<String>();
            String[] tR = (String[])result;
            boolean doesBypassNamespace = Storage.ConfigSections.Settings.BLOCK_NAMESPACE_COMMANDS.doesBypass(player);
            if (spaces == 0) {
                for (String s2 : tR) {
                    if (!BukkitLoader.isLoaded()) continue;
                    if (!s2.startsWith("/")) {
                        newResultList.add(s2);
                        continue;
                    }
                    String tempName = s2.replaceFirst("/", "");
                    if (!doesBypassNamespace && Storage.ConfigSections.Settings.BLOCK_NAMESPACE_COMMANDS.isCommand(tempName) || Storage.Blacklist.canPlayerAccessTab(player, tempName)) continue;
                    newResultList.add(s2);
                }
            } else if (!cancelsBeforeHand && !(filteredTabCompletionEvent = PATEventHandler.callFilteredTabCompletionEvents(player.getUniqueId(), input, Arrays.asList(tR))).isCancelled()) {
                List suggestions = Arrays.stream(tR).filter(s -> filteredTabCompletionEvent.getCompletion().contains(s)).collect(Collectors.toList());
                newResultList.addAll(suggestions);
            }
            field.set(packetObj, newResultList.toArray(new String[0]));
        }
        return true;
    }
}

