/*
 * Decompiled with CFR 0.152.
 */
package de.rayzs.pat.api.storage.blacklist;

import de.rayzs.pat.api.storage.Storage;
import de.rayzs.pat.api.storage.blacklist.impl.GeneralBlacklist;
import de.rayzs.pat.api.storage.blacklist.impl.GroupBlacklist;

public class BlacklistCreator {
    public static GeneralBlacklist createGeneralBlacklist() {
        return new GeneralBlacklist("commands");
    }

    public static GeneralBlacklist createGeneralBlacklist(String server) {
        return new GeneralBlacklist("servers." + server + ".commands");
    }

    public static GroupBlacklist createGroupBlacklist(String group) {
        return new GroupBlacklist(group, "commands");
    }

    public static GroupBlacklist createGroupBlacklist(String group, String server, boolean ignoreExist) {
        if (!BlacklistCreator.exist(group, server) && !ignoreExist) {
            return null;
        }
        return new GroupBlacklist(group, "servers." + server + ".commands");
    }

    public static boolean exist(String server) {
        Object obj = Storage.Blacklist.getBlacklist().getConfig().get("global.servers." + server);
        return obj != null;
    }

    public static boolean exist(String group, String server) {
        Object obj = Storage.Blacklist.getBlacklist().getConfig().get("groups." + group + ".servers." + server);
        return obj != null;
    }
}

