/*
 * Decompiled with CFR 0.152.
 */
package de.rayzs.pat.plugin.listeners.bungee;

import de.rayzs.pat.api.event.PATEventHandler;
import de.rayzs.pat.api.event.events.ExecuteCommandEvent;
import de.rayzs.pat.api.storage.Storage;
import de.rayzs.pat.plugin.logger.Logger;
import de.rayzs.pat.utils.StringUtils;
import de.rayzs.pat.utils.message.MessageTranslator;
import de.rayzs.pat.utils.permission.PermissionUtil;
import java.util.List;
import java.util.UUID;
import net.md_5.bungee.api.connection.Connection;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.event.ChatEvent;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.event.EventHandler;

public class BungeeBlockCommandListener
implements Listener {
    @EventHandler(priority=64)
    public void onChat(ChatEvent event) {
        ExecuteCommandEvent executeCommandEvent;
        if (event.isCancelled()) {
            return;
        }
        Connection connection = event.getSender();
        if (!(connection instanceof ProxiedPlayer) || !event.getMessage().startsWith("/")) {
            return;
        }
        ProxiedPlayer player = (ProxiedPlayer)connection;
        String serverName = player.getServer().getInfo().getName();
        String command = event.getMessage();
        boolean bypassPermission = PermissionUtil.hasBypassPermission(player, command);
        if (bypassPermission) {
            return;
        }
        command = command.startsWith("/") ? command.substring(1) : command;
        String displayCommand = command = StringUtils.getFirstArg(command);
        command = StringUtils.replaceTriggers(command, "", "\\", "<", ">", "&");
        command = command.toLowerCase();
        List<String> notificationMessage = MessageTranslator.replaceMessageList(Storage.ConfigSections.Messages.NOTIFICATION.ALERT, "%player%", player.getName(), "%command%", displayCommand, "%server%", serverName);
        if (!Storage.ConfigSections.Settings.CANCEL_COMMAND.ENABLED) {
            return;
        }
        if (!Storage.Blacklist.canPlayerAccessChat(player, command, serverName)) {
            executeCommandEvent = PATEventHandler.callExecuteCommandEvents(player, event.getMessage(), true);
            if (executeCommandEvent.isBlocked()) {
                event.setCancelled(true);
                if (Storage.SEND_CONSOLE_NOTIFICATION) {
                    Logger.info(notificationMessage);
                }
                Storage.NOTIFY_PLAYERS.forEach(uuid -> {
                    Object p = Storage.getLoader().getPlayerObjByUUID((UUID)uuid);
                    if (p != null) {
                        MessageTranslator.send(p, notificationMessage);
                    }
                });
            }
            if (executeCommandEvent.isCancelled()) {
                return;
            }
        }
        if ((executeCommandEvent = PATEventHandler.callExecuteCommandEvents(player, event.getMessage(), false)).isBlocked()) {
            event.setCancelled(true);
        }
    }
}

