/*
 * Decompiled with CFR 0.152.
 */
package de.rayzs.pat.plugin.listeners.velocity;

import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.connection.DisconnectEvent;
import com.velocitypowered.api.event.player.ServerConnectedEvent;
import com.velocitypowered.api.event.player.ServerPreConnectEvent;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import de.rayzs.pat.api.brand.CustomServerBrand;
import de.rayzs.pat.api.event.PATEventHandler;
import de.rayzs.pat.api.event.events.ServerPlayersChangeEvent;
import de.rayzs.pat.api.netty.proxy.VelocityPacketAnalyzer;
import de.rayzs.pat.api.storage.Storage;
import de.rayzs.pat.plugin.VelocityLoader;
import de.rayzs.pat.utils.message.MessageTranslator;
import de.rayzs.pat.utils.permission.PermissionUtil;
import java.util.concurrent.TimeUnit;

public class VelocityConnectionListener {
    private final ProxyServer server;
    private final VelocityLoader loader;

    public VelocityConnectionListener(ProxyServer server, VelocityLoader loader) {
        this.server = server;
        this.loader = loader;
    }

    @Subscribe
    public void onServerPreConnect(ServerPreConnectEvent event) {
        Player player = event.getPlayer();
        PATEventHandler.callServerPlayersChangeEvents(player, ServerPlayersChangeEvent.Type.JOINED);
        if (CustomServerBrand.isEnabled()) {
            this.server.getScheduler().buildTask((Object)this.loader, () -> {
                if (player.isActive()) {
                    CustomServerBrand.sendBrandToPlayer(player);
                }
            }).delay(500L, TimeUnit.MILLISECONDS).schedule();
        }
        PermissionUtil.setPlayerPermissions(player.getUniqueId());
        if (Storage.OUTDATED && PermissionUtil.hasPermission(player, "joinupdate")) {
            this.server.getScheduler().buildTask((Object)this.loader, () -> {
                if (player.isActive()) {
                    MessageTranslator.send((Object)player, Storage.ConfigSections.Settings.UPDATE.OUTDATED, "%player%", player.getUsername());
                }
            }).delay(1L, TimeUnit.SECONDS).schedule();
        }
    }

    @Subscribe
    public void onServerSwitch(ServerConnectedEvent event) {
        Player player = event.getPlayer();
        if (!VelocityPacketAnalyzer.isInjected(player)) {
            VelocityPacketAnalyzer.inject(player);
        }
        if (Storage.ConfigSections.Settings.CUSTOM_BRAND.REPEAT_DELAY != -1) {
            return;
        }
        CustomServerBrand.sendBrandToPlayer(player);
    }

    @Subscribe
    public void onDisconnect(DisconnectEvent event) {
        Player player = event.getPlayer();
        PATEventHandler.callServerPlayersChangeEvents(player, ServerPlayersChangeEvent.Type.LEFT);
        PermissionUtil.resetPermissions(player.getUniqueId());
        VelocityPacketAnalyzer.uninject(player);
    }
}

