/*
 * Decompiled with CFR 0.152.
 */
package de.rayzs.pat.utils;

import de.rayzs.pat.plugin.logger.Logger;

public class VersionComparer {
    private static Version CURRENT_VERSION;
    private static Version NEWEST_VERSION;

    public static void setCurrentVersion(String versionName) {
        if (CURRENT_VERSION != null && CURRENT_VERSION.getVersionName().equals(versionName)) {
            return;
        }
        CURRENT_VERSION = new Version(versionName);
    }

    public static void setNewestVersion(String versionName) {
        if (NEWEST_VERSION != null && NEWEST_VERSION.getVersionName().equals(versionName)) {
            return;
        }
        NEWEST_VERSION = new Version(versionName);
    }

    public static Version getCurrentVersion() {
        return CURRENT_VERSION;
    }

    public static Version getNewestVersion() {
        return NEWEST_VERSION;
    }

    public static boolean isNewest() {
        if (CURRENT_VERSION == null || NEWEST_VERSION == null) {
            return true;
        }
        return CURRENT_VERSION.isSame(NEWEST_VERSION);
    }

    public static boolean isUnreleased() {
        if (CURRENT_VERSION == null || NEWEST_VERSION == null) {
            return true;
        }
        return CURRENT_VERSION.isNewer(NEWEST_VERSION);
    }

    public static boolean isOutdated() {
        if (CURRENT_VERSION == null || NEWEST_VERSION == null) {
            return false;
        }
        return CURRENT_VERSION.isOlder(NEWEST_VERSION);
    }

    public static boolean isDeveloperVersion() {
        return CURRENT_VERSION.getState() == State.DEV;
    }

    public static class Version {
        private final String versionName;
        private int release = -1;
        private int major = -1;
        private int patch = -1;
        private State state = State.RELEASE;

        public Version(String version) {
            this.versionName = version;
            try {
                String[] versionSplit = version.split("\\.");
                this.release = Integer.parseInt(versionSplit[0]);
                this.major = Integer.parseInt(versionSplit[1]);
                String patchAsString = versionSplit[2];
                patchAsString = patchAsString.contains("-") ? patchAsString.split("-")[0] : patchAsString;
                this.patch = Integer.parseInt(patchAsString);
                if (!version.contains("-")) {
                    return;
                }
                String stateName = version.split("-")[1].toUpperCase();
                this.state = State.valueOf(stateName);
            }
            catch (Throwable throwable) {
                Logger.warning("Failed to read version name! [" + version + "]");
                throwable.printStackTrace();
            }
        }

        public String getVersionName() {
            return this.versionName;
        }

        public boolean isSame(Version version) {
            return version.getVersionName().equals(this.versionName);
        }

        public boolean isNewer(Version comparedVersion) {
            return !this.isSame(comparedVersion) && !this.isOlder(comparedVersion);
        }

        public boolean isOlder(Version comparedVersion) {
            if (this.release > comparedVersion.getRelease()) {
                return false;
            }
            if (this.major > comparedVersion.getMajor()) {
                return false;
            }
            return this.patch < comparedVersion.getPatch();
        }

        public int getRelease() {
            return this.release;
        }

        public int getMajor() {
            return this.major;
        }

        public int getPatch() {
            return this.patch;
        }

        public State getState() {
            return this.state;
        }

        public boolean isInvalid() {
            return this.release == -1 || this.major == -1 || this.patch == -1;
        }
    }

    public static enum State {
        RELEASE,
        DEV,
        ALPHA,
        BETA;

    }
}

