/*
 * Decompiled with CFR 0.152.
 */
package de.rayzs.pat.utils.configuration.updater;

import de.rayzs.pat.plugin.logger.Logger;
import de.rayzs.pat.utils.Reflection;
import de.rayzs.pat.utils.configuration.ConfigurationBuilder;
import de.rayzs.pat.utils.configuration.Configurator;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class ConfigUpdater {
    private static List<String> NEWEST_CONFIG_INPUT = new ArrayList<String>();
    private static List<String> MISSING_PARTS = new ArrayList<String>();
    private static boolean LOADED = false;
    private static boolean AUTO_UPDATE = false;
    private static boolean ANNOUNCE = false;
    private static final String COMPARABLE_FILE_NAME = "comparable-config.yml";
    private static final String HOW_TO_READ_FILE_NAME = "How-To-Read.txt";

    public static void initialize() {
        try {
            MISSING_PARTS.clear();
            ConfigurationBuilder config = Configurator.get("config");
            ANNOUNCE = (Boolean)config.getOrSet("updater.announce-missing-parts", true);
            AUTO_UPDATE = (Boolean)config.getOrSet("updater.auto-update-config", false);
        }
        catch (Exception exception) {
            Logger.warning("Failed to find section 'updater.auto-config-updater' in config.yml!");
        }
        LOADED = true;
    }

    public static boolean shouldAutoUpdate() {
        return AUTO_UPDATE;
    }

    public static void addMissingPart(String path) {
        if (!MISSING_PARTS.contains(path)) {
            MISSING_PARTS.add(path);
        }
    }

    public static void broadcastMissingParts() {
        if (!LOADED) {
            return;
        }
        File outdatedConfig = new File("plugins/ProAntiTab/comparable-config.yml");
        File howReadFile = new File("plugins/ProAntiTab/How-To-Read.txt");
        if (MISSING_PARTS.isEmpty()) {
            if (outdatedConfig.delete()) {
                Logger.info("Deleted the '" + outdatedConfig.getName() + "' file, because it's no longer needed.");
            }
            if (howReadFile.delete()) {
                Logger.info("Deleted the '" + howReadFile.getName() + "' file, because it's no longer needed.");
            }
            return;
        }
        if (!ANNOUNCE) {
            return;
        }
        LinkedList<String> configInput = new LinkedList<String>(Arrays.asList("# WARNING: This file is auto generated and its sole purpose is to be used as comparison!\n# WARNING: It will be deleted once this file is no longer needed.", " ", " "));
        configInput.addAll(NEWEST_CONFIG_INPUT);
        Configurator.createResourcedFile("files\\" + (Reflection.isProxyServer() ? "proxy" : "bukkit") + "-config.yml", COMPARABLE_FILE_NAME, false);
        Configurator.createResourcedFile("files\\how-to-read.txt", HOW_TO_READ_FILE_NAME, false);
        try {
            ArrayList<String> input = new ArrayList<String>(Arrays.asList("# WARNING: This file is auto generated and its sole purpose is to be used as comparison!", "# WARNING: It will be deleted once this file is no longer needed.", " ", " "));
            input.addAll(Files.readAllLines(Paths.get(outdatedConfig.getAbsolutePath(), new String[0])));
            Files.write(outdatedConfig.toPath(), input, new OpenOption[0]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        Logger.warning(" ");
        Logger.warning("The config.yml is missing a few parts.");
        Logger.warning("What can be done to solve this issue? There are two options:");
        Logger.warning(" ");
        Logger.warning("Option 1: Delete your current config.yml and restart the server.");
        Logger.warning("Option 2: Set the missing parts/sections yourself in the config.yml.");
        Logger.warning(" ");
        Logger.warning("To simplify that process, a new file with the newest config.yml content has been created as comparison. (plugins/ProAntiTab/comparable-config.yml)");
        Logger.warning(" ");
        Logger.warning("Following parts are missing:");
        MISSING_PARTS.forEach(missing -> Logger.warning("- " + missing));
        Logger.warning(" ");
        Logger.warning("How to read? Check out the newly generated How-To-Read.txt file. ^^");
        Logger.warning(" ");
    }
}

