/*
 * Decompiled with CFR 0.152.
 */
package de.rayzs.pat.api.communication;

import de.rayzs.pat.api.communication.Communicator;
import de.rayzs.pat.api.storage.Storage;
import de.rayzs.pat.utils.scheduler.PATScheduler;
import de.rayzs.pat.utils.scheduler.PATSchedulerTask;
import org.bukkit.Bukkit;

public class BackendUpdater {
    private static PATSchedulerTask TASK;

    public static void handle() {
        if (BackendUpdater.isRunning() || !BackendUpdater.shouldRun() || !Storage.ConfigSections.Settings.HANDLE_THROUGH_PROXY.ENABLED) {
            return;
        }
        BackendUpdater.start();
    }

    public static boolean isRunning() {
        return TASK != null && TASK.isActive();
    }

    public static void start() {
        if (BackendUpdater.isRunning()) {
            return;
        }
        TASK = PATScheduler.createScheduler(() -> {
            if (BackendUpdater.shouldRun()) {
                Communicator.sendRequest();
            } else {
                BackendUpdater.stop();
            }
        }, 5L, 20L);
    }

    public static void stop() {
        if (TASK == null || !TASK.isActive()) {
            return;
        }
        TASK.cancelTask();
        TASK = null;
    }

    private static boolean shouldRun() {
        int onlinePlayerSize = Bukkit.getOnlinePlayers().size();
        return onlinePlayerSize >= 1;
    }
}

