/*
 * Decompiled with CFR 0.152.
 */
package de.rayzs.pat.api.communication.impl;

import de.rayzs.pat.api.communication.Client;
import de.rayzs.pat.api.communication.Communicator;
import de.rayzs.pat.plugin.BungeeLoader;
import de.rayzs.pat.utils.CommunicationPackets;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.Server;
import net.md_5.bungee.api.event.PluginMessageEvent;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.event.EventHandler;

public class BungeeClient
implements Client,
Listener {
    private static final ProxyServer SERVER = ProxyServer.getInstance();

    public BungeeClient() {
        SERVER.registerChannel("pat:channel");
        SERVER.getPluginManager().registerListener(BungeeLoader.getPlugin(), (Listener)this);
    }

    @Override
    public void send(Object packet) {
        for (ServerInfo serverInfo : ProxyServer.getInstance().getServers().values()) {
            try {
                serverInfo.sendData("pat:channel", CommunicationPackets.convertToBytes(packet));
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    @EventHandler
    public void onQueryReceive(PluginMessageEvent event) {
        if (!event.getTag().equalsIgnoreCase("pat:channel")) {
            return;
        }
        try {
            Object packetObj = CommunicationPackets.buildFromBytes(event.getData());
            if (!CommunicationPackets.isPacket(packetObj)) {
                return;
            }
            Server server = (Server)event.getSender();
            Communicator.receiveInformation(server.getInfo().getName(), packetObj);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }
}

