/*
 * Decompiled with CFR 0.152.
 */
package de.rayzs.pat.utils;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.TimeUnit;

public class ExpireList<T> {
    private final Cache<Object, Object> cache;

    public ExpireList(long expireTime, TimeUnit timeUnit) {
        this.cache = CacheBuilder.newBuilder().concurrencyLevel(2).expireAfterWrite(expireTime, timeUnit).build();
    }

    public ExpireList(ExpireList<T> expireList) {
        this.cache = expireList.getCache();
    }

    public boolean add(T t) {
        if (this.contains(t)) {
            return false;
        }
        this.cache.put(t, (Object)0);
        return true;
    }

    public void addIgnoreIfContains(T t) {
        this.cache.put(t, (Object)0);
    }

    public int getSize() {
        this.cache.cleanUp();
        return (int)this.cache.size();
    }

    public Cache<Object, Object> getCache() {
        return this.cache;
    }

    public boolean contains(T t) {
        return this.cache.getIfPresent(t) != null;
    }
}

