/*
 * Decompiled with CFR 0.152.
 */
package de.rayzs.pat.utils.configuration.impl;

import de.rayzs.pat.plugin.logger.Logger;
import de.rayzs.pat.utils.configuration.ConfigurationBuilder;
import de.rayzs.pat.utils.configuration.updater.ConfigUpdater;
import java.io.File;
import java.util.Collection;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.YamlConfiguration;

public class BukkitConfigurationBuilder
implements ConfigurationBuilder {
    private String fileName;
    private String filePath;
    private File file;
    private boolean loadDefault;
    private YamlConfiguration configuration;

    public BukkitConfigurationBuilder(String fileName) {
        this.init(fileName);
    }

    public BukkitConfigurationBuilder(String fileName, String filePath) {
        this.filePath = filePath;
        this.init(fileName);
    }

    protected void init(String fileName) {
        this.fileName = fileName;
        this.file = new File(this.filePath == null ? "./plugins/ProAntiTab" : this.filePath, fileName + ".yml");
        this.loadDefault = !this.file.exists();
        this.configuration = YamlConfiguration.loadConfiguration((File)this.file);
    }

    @Override
    public String getFilePath() {
        return this.filePath;
    }

    @Override
    public void reload() {
        this.init(this.fileName);
    }

    @Override
    public void save() {
        try {
            this.configuration.save(this.file);
        }
        catch (Exception exception) {
            Logger.info("Could not save configuration file! [file=" + this.fileName + ", message=" + exception.getMessage() + "]");
        }
    }

    @Override
    public ConfigurationBuilder set(String path, String target, Object object) {
        this.configuration.set((String)(path != null ? path + "." : "") + target, object instanceof String ? ((String)object).replace("\u00a7", "&") : object);
        return this;
    }

    @Override
    public ConfigurationBuilder set(String target, Object object) {
        this.set(null, target, object);
        return this;
    }

    @Override
    public ConfigurationBuilder setAndSave(String path, String target, Object object) {
        this.set(path, target, object);
        this.save();
        return this;
    }

    @Override
    public ConfigurationBuilder setAndSave(String target, Object object) {
        this.set(target, object);
        this.save();
        return this;
    }

    @Override
    public Object getOrSet(String path, String target, Object object) {
        Object result = this.get(path, target);
        if (result != null) {
            return result;
        }
        if (this.fileName.equals("config")) {
            if (!ConfigUpdater.shouldAutoUpdate()) {
                ConfigUpdater.addMissingPart(path + "." + target);
                return object;
            }
            this.set(path, target, object);
            return this.get(path, target);
        }
        this.set(path, target, object);
        this.save();
        return this.get(path, target);
    }

    @Override
    public Object getOrSet(String target, Object object) {
        Object result = this.get(target);
        if (result != null) {
            return result;
        }
        if (this.fileName.equals("config")) {
            if (!ConfigUpdater.shouldAutoUpdate()) {
                ConfigUpdater.addMissingPart(target);
                return object;
            }
            this.set(target, object);
            return this.get(target);
        }
        this.set(target, object);
        this.save();
        return this.get(target);
    }

    @Override
    public Object get(String target) {
        return this.get(null, target);
    }

    @Override
    public Object get(String path, String target) {
        Object object = this.configuration.get((String)(path != null ? path + "." : "") + target);
        if (object instanceof String) {
            String objString = (String)object;
            return ChatColor.translateAlternateColorCodes((char)'&', (String)objString);
        }
        return object;
    }

    @Override
    public Collection<String> getKeys(boolean deep) {
        return this.configuration.getKeys(deep);
    }

    @Override
    public Collection<String> getKeys(String section, boolean deep) {
        return this.configuration.getConfigurationSection(section).getKeys(deep);
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public boolean loadDefault() {
        return this.loadDefault;
    }
}

