/*
 * Decompiled with CFR 0.152.
 */
package de.rayzs.pat.utils.subargs;

import de.rayzs.pat.utils.subargs.ArgumentSource;
import de.rayzs.pat.utils.subargs.ArgumentStack;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ArgumentBuilder {
    private final ArgumentSource source;

    public ArgumentBuilder(ArgumentSource source) {
        this.source = source;
    }

    public List<String> getInputs() {
        return this.source.INPUTS;
    }

    public List<String> getResult(String input) {
        String firstInputArg = input.contains(" ") ? input.split(" ")[0] : input;
        for (Map.Entry<String, ArgumentStack> entry : this.source.ARGUMENT_STACKS.entrySet()) {
            if (!entry.getKey().equals(firstInputArg)) continue;
            return this.source.ARGUMENT_STACKS.get(entry.getKey()).getResult(input);
        }
        return Collections.emptyList();
    }

    public void clearAllArguments() {
        this.source.INPUTS.clear();
        this.source.ARGUMENT_STACKS.clear();
    }

    public void buildArgumentStacks(String input) {
        if (!input.contains(" ")) {
            return;
        }
        if (!this.source.INPUTS.contains(input)) {
            this.source.INPUTS.add(input);
        }
        boolean first = true;
        ArgumentStack argumentStack = null;
        for (String s : input.split(" ")) {
            if (!first) {
                argumentStack = argumentStack.createAndGetArgumentStack(s);
                continue;
            }
            argumentStack = this.source.ARGUMENT_STACKS.get(s);
            if (argumentStack == null) {
                argumentStack = new ArgumentStack();
                this.source.ARGUMENT_STACKS.put(s, argumentStack);
            }
            first = false;
        }
    }
}

