/*
 * Decompiled with CFR 0.152.
 */
package de.rayzs.pat.api.brand.impl;

import de.rayzs.pat.api.brand.ServerBrand;
import de.rayzs.pat.api.storage.Storage;
import de.rayzs.pat.plugin.BungeeLoader;
import de.rayzs.pat.utils.PacketUtils;
import de.rayzs.pat.utils.message.MessageTranslator;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.connection.Server;
import net.md_5.bungee.api.scheduler.ScheduledTask;

public class BungeeServerBrand
implements ServerBrand {
    private static final ProxyServer SERVER = BungeeLoader.getPlugin().getProxy();
    private static ScheduledTask TASK;
    private static String BRAND;

    @Override
    public void initializeTask() {
        if (TASK != null) {
            TASK.cancel();
        }
        if (!Storage.ConfigSections.Settings.CUSTOM_BRAND.ENABLED) {
            return;
        }
        if (Storage.ConfigSections.Settings.CUSTOM_BRAND.REPEAT_DELAY == -1) {
            BRAND = MessageTranslator.replaceMessage(Storage.ConfigSections.Settings.CUSTOM_BRAND.BRANDS.getLines().get(0)) + "\u00a7r";
            SERVER.getPlayers().forEach(this::send);
        } else {
            AtomicInteger animationState = new AtomicInteger(0);
            TASK = SERVER.getScheduler().schedule(BungeeLoader.getPlugin(), () -> {
                if (animationState.getAndIncrement() >= Storage.ConfigSections.Settings.CUSTOM_BRAND.BRANDS.getLines().size() - 1) {
                    animationState.set(0);
                }
                BRAND = MessageTranslator.replaceMessage(Storage.ConfigSections.Settings.CUSTOM_BRAND.BRANDS.getLines().get(animationState.get())) + "\u00a7r";
                SERVER.getPlayers().forEach(this::send);
            }, 1L, (long)Storage.ConfigSections.Settings.CUSTOM_BRAND.REPEAT_DELAY, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public void preparePlayer(Object playerObj) {
    }

    @Override
    public void send(Object playerObj) {
        if (!(playerObj instanceof ProxiedPlayer) || !Storage.ConfigSections.Settings.CUSTOM_BRAND.ENABLED) {
            return;
        }
        ProxiedPlayer player = (ProxiedPlayer)playerObj;
        String serverName = "";
        String playerName = player.getName();
        Server server = player.getServer();
        if (server != null) {
            serverName = server.getInfo().getName();
        }
        String customBrand = BRAND.replace("%player%", playerName).replace("%server%", serverName);
        PacketUtils.BrandManipulate serverBrand = new PacketUtils.BrandManipulate(customBrand);
        String brand = player.getPendingConnection().getVersion() >= 393 ? "minecraft:brand" : "MC|Brand";
        player.sendData(brand, serverBrand.getBytes());
    }

    @Override
    public PacketUtils.BrandManipulate createPacket(Object playerObj) {
        if (!(playerObj instanceof ProxiedPlayer) || !Storage.ConfigSections.Settings.CUSTOM_BRAND.ENABLED) {
            return null;
        }
        ProxiedPlayer player = (ProxiedPlayer)playerObj;
        String serverName = "";
        String playerName = player.getName();
        Server server = player.getServer();
        if (server != null) {
            serverName = server.getInfo().getName();
        }
        String customBrand = BRAND.replace("%player%", playerName).replace("%server%", serverName);
        return new PacketUtils.BrandManipulate(customBrand);
    }

    static {
        BRAND = Storage.ConfigSections.Settings.CUSTOM_BRAND.BRANDS.getLines().get(0);
    }
}

