/*
 * Decompiled with CFR 0.152.
 */
package de.rayzs.pat.api.netty.proxy;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.tree.CommandNode;
import de.rayzs.pat.api.brand.CustomServerBrand;
import de.rayzs.pat.api.communication.Communicator;
import de.rayzs.pat.api.communication.client.ClientInfo;
import de.rayzs.pat.api.storage.Storage;
import de.rayzs.pat.plugin.logger.Logger;
import de.rayzs.pat.utils.CommandsCache;
import de.rayzs.pat.utils.Reflection;
import de.rayzs.pat.utils.StringUtils;
import de.rayzs.pat.utils.node.CommandNodeHelper;
import de.rayzs.pat.utils.permission.PermissionUtil;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.MessageToMessageDecoder;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.PacketWrapper;
import net.md_5.bungee.protocol.packet.Commands;
import net.md_5.bungee.protocol.packet.PluginMessage;
import net.md_5.bungee.protocol.packet.TabCompleteResponse;

public class BungeePacketAnalyzer {
    public static final ConcurrentHashMap<ProxiedPlayer, Channel> INJECTED_PLAYERS = new ConcurrentHashMap();
    private static final String HANDLER_NAME = "pat-bungee-handler";
    private static final String PIPELINE_NAME = "packet-decoder";
    private static final HashMap<ProxiedPlayer, Boolean> PLAYER_MODIFIED = new HashMap();
    private static final HashMap<ProxiedPlayer, String> PLAYER_INPUT_CACHE = new HashMap();
    private static final com.mojang.brigadier.Command DUMMY_COMMAND = context -> 0;
    private static final List<String> PLUGIN_COMMANDS = new ArrayList<String>();
    private static Class<?> channelWrapperClass;
    private static Class<?> serverConnectionClass;
    private static final List<String> PROXY_COMMANDS;

    public static void injectAll() {
        ProxyServer.getInstance().getPlayers().forEach(BungeePacketAnalyzer::inject);
    }

    public static void uninjectAll() {
        ((ConcurrentHashMap.KeySetView)INJECTED_PLAYERS.keySet()).forEach(BungeePacketAnalyzer::uninject);
        INJECTED_PLAYERS.clear();
    }

    public static void setPluginCommands() {
        if (!PLUGIN_COMMANDS.isEmpty()) {
            return;
        }
        ProxyServer.getInstance().getPluginManager().getCommands().stream().filter(entry -> !PLUGIN_COMMANDS.contains(entry.getKey())).forEach(entry -> PLUGIN_COMMANDS.add((String)entry.getKey()));
    }

    public static boolean inject(ProxiedPlayer player) {
        if (channelWrapperClass == null) {
            channelWrapperClass = Reflection.getClass("net.md_5.bungee.netty.ChannelWrapper");
        }
        if (serverConnectionClass == null) {
            serverConnectionClass = Reflection.getClass("net.md_5.bungee.ServerConnection");
        }
        try {
            Field channelField = Reflection.getFieldByName(serverConnectionClass, "ch");
            Object channelWrapperObj = channelField.get(player.getServer());
            Channel channel = (Channel)Reflection.getFieldsByType(channelWrapperClass, "Channel", Reflection.SearchOption.ENDS).get(0).get(channelWrapperObj);
            if (channel == null) {
                Logger.warning("Failed to inject " + player.getName() + "! Channel is null.");
                return false;
            }
            channelField.setAccessible(false);
            if (channel.pipeline().names().contains(HANDLER_NAME)) {
                BungeePacketAnalyzer.uninject(player);
            }
            channel.pipeline().addAfter(PIPELINE_NAME, HANDLER_NAME, (ChannelHandler)new PacketDecoder(player));
            INJECTED_PLAYERS.put(player, channel);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
        return true;
    }

    public static void uninject(ProxiedPlayer player) {
        Channel channel;
        PLAYER_INPUT_CACHE.remove(player);
        PLAYER_MODIFIED.remove(player);
        if (INJECTED_PLAYERS.containsKey(player) && (channel = INJECTED_PLAYERS.get(player)) != null) {
            INJECTED_PLAYERS.remove(player);
            channel.eventLoop().submit(() -> {
                ChannelPipeline pipeline = channel.pipeline();
                if (pipeline.names().contains(HANDLER_NAME)) {
                    pipeline.remove(HANDLER_NAME);
                }
            });
        }
    }

    public static String getPlayerInput(ProxiedPlayer player) {
        String input = PLAYER_INPUT_CACHE.get(player);
        PLAYER_INPUT_CACHE.remove(player);
        return input;
    }

    private static void modifyCommands(ProxiedPlayer player, Commands commands) {
        ServerInfo serverInfo = player.getServer().getInfo();
        String serverName = serverInfo.getName();
        CommandNodeHelper helper = new CommandNodeHelper(commands.getRoot());
        HashMap<String, CommandsCache> cache = Storage.getLoader().getCommandsCacheMap();
        if (!cache.containsKey(serverName)) {
            cache.put(serverName, new CommandsCache());
        }
        CommandsCache commandsCache = (CommandsCache)cache.get(serverName);
        ArrayList<String> commandsAsString = new ArrayList<String>(PROXY_COMMANDS);
        commandsAsString.addAll(helper.getChildrenNames());
        commandsCache.handleCommands(commandsAsString, serverName);
        List<String> playerCommands = commandsCache.getPlayerCommands(commandsAsString, player, player.getUniqueId(), serverName);
        helper.removeIf(str -> !playerCommands.contains(str));
        for (Map.Entry command : ProxyServer.getInstance().getPluginManager().getCommands()) {
            if (ProxyServer.getInstance().getDisabledCommands().contains(command.getKey()) || commands.getRoot().getChild((String)command.getKey()) != null || !((Command)command.getValue()).hasPermission((CommandSender)player)) continue;
            String commandName = (String)command.getKey();
            String string = commandName = commandName.startsWith("/") ? commandName.substring(1) : commandName;
            if (!playerCommands.contains(commandName)) continue;
            CommandNode dummy = BungeePacketAnalyzer.createDummyCommandNode((String)command.getKey());
            commands.getRoot().addChild(dummy);
        }
    }

    private static CommandNode createDummyCommandNode(String command) {
        return ((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)command).executes(DUMMY_COMMAND)).then(RequiredArgumentBuilder.argument((String)"args", (ArgumentType)StringArgumentType.greedyString()).suggests(Commands.SuggestionRegistry.ASK_SERVER).executes(DUMMY_COMMAND)).build();
    }

    static {
        PROXY_COMMANDS = ProxyServer.getInstance().getPluginManager().getCommands().stream().map(entry -> {
            String key = (String)entry.getKey();
            return key.startsWith("/") ? key.substring(1) : key;
        }).toList();
    }

    private static class PacketDecoder
    extends MessageToMessageDecoder<PacketWrapper> {
        private final ProxiedPlayer player;

        private PacketDecoder(ProxiedPlayer player) {
            this.player = player;
        }

        protected void decode(ChannelHandlerContext channelHandlerContext, PacketWrapper wrapper, List<Object> list) {
            if (wrapper.packet == null) {
                list.add(wrapper);
                return;
            }
            if (wrapper.packet instanceof PluginMessage) {
                PluginMessage pluginMessage = (PluginMessage)wrapper.packet;
                if (CustomServerBrand.isEnabled() && CustomServerBrand.isBrandTag(pluginMessage.getTag())) {
                    return;
                }
            } else {
                if (wrapper.packet instanceof Commands) {
                    Commands response = (Commands)wrapper.packet;
                    BungeePacketAnalyzer.modifyCommands(this.player, response);
                    this.player.unsafe().sendPacket((DefinedPacket)response);
                    return;
                }
                if (wrapper.packet instanceof TabCompleteResponse) {
                    TabCompleteResponse response = (TabCompleteResponse)wrapper.packet;
                    if (this.player.getPendingConnection().getVersion() < 754 && !PermissionUtil.hasBypassPermission(this.player)) {
                        String cursor;
                        ClientInfo clientInfo = Communicator.getClientByName(this.player.getServer().getInfo().getName());
                        if (clientInfo == null || !PLAYER_INPUT_CACHE.containsKey(this.player)) {
                            return;
                        }
                        boolean cancelsBeforeHand = false;
                        String rawPlayerInput = BungeePacketAnalyzer.getPlayerInput(this.player);
                        int spaces = rawPlayerInput.contains(" ") ? rawPlayerInput.split(" ").length : 0;
                        String playerInput = StringUtils.getFirstArg(rawPlayerInput);
                        String server = this.player.getServer().getInfo().getName();
                        if (!playerInput.equals("/")) {
                            boolean bl = cancelsBeforeHand = !Storage.Blacklist.canPlayerAccessTab(this.player, StringUtils.replaceFirst(playerInput, "/", ""), server);
                            if (!cancelsBeforeHand) {
                                boolean bl2 = cancelsBeforeHand = !Storage.ConfigSections.Settings.CUSTOM_VERSION.isTabCompletable(StringUtils.replaceFirst(playerInput, "/", "")) || Storage.ConfigSections.Settings.CUSTOM_PLUGIN.isTabCompletable(StringUtils.replaceFirst(playerInput, "/", ""));
                            }
                        }
                        if ((cursor = playerInput).startsWith("/")) {
                            if (spaces == 0) {
                                ArrayList<String> suggestions = new ArrayList<String>(response.getCommands());
                                if (Storage.ConfigSections.Settings.TURN_BLACKLIST_TO_WHITELIST.ENABLED) {
                                    BungeePacketAnalyzer.setPluginCommands();
                                    Storage.Blacklist.getServerBlacklists(server).forEach(blacklist -> blacklist.getCommands().stream().filter(command -> !suggestions.contains("/" + command)).forEach(command -> {
                                        if (PLUGIN_COMMANDS.contains(command)) {
                                            suggestions.add("/" + command);
                                        }
                                    }));
                                    PLUGIN_COMMANDS.stream().filter(command -> !suggestions.contains(command)).forEach(command -> {
                                        if (command.startsWith("/")) {
                                            command = StringUtils.replaceFirst(command, "/", "");
                                        }
                                        if (Storage.Blacklist.canPlayerAccessTab(this.player, command, server)) {
                                            suggestions.add("/" + command);
                                        }
                                    });
                                    suggestions.stream().filter(suggestion -> suggestion.startsWith(cursor) && !response.getCommands().contains(suggestion)).forEach(command -> response.getCommands().add(command));
                                } else {
                                    PLUGIN_COMMANDS.stream().filter(command -> !suggestions.contains(command)).forEach(suggestions::add);
                                    suggestions.removeIf(command -> {
                                        if (command.startsWith("/")) {
                                            command = StringUtils.replaceFirst(command, "/", "");
                                        }
                                        return !Storage.Blacklist.canPlayerAccessTab(this.player, command, server);
                                    });
                                    response.getCommands().clear();
                                    suggestions.forEach(command -> response.getCommands().add(command));
                                }
                                if (response.getCommands().isEmpty()) {
                                    return;
                                }
                            } else if (cancelsBeforeHand) {
                                return;
                            }
                            this.player.unsafe().sendPacket((DefinedPacket)new TabCompleteResponse(response.getCommands()));
                        }
                    }
                }
            }
            list.add(wrapper);
        }
    }
}

