/*
 * Decompiled with CFR 0.152.
 */
package de.rayzs.pat.api.storage.config.settings;

import de.rayzs.pat.api.storage.storages.ConfigStorage;
import de.rayzs.pat.utils.StringUtils;
import de.rayzs.pat.utils.configuration.helper.ConfigSectionHelper;
import de.rayzs.pat.utils.configuration.helper.MultipleMessagesHelper;
import java.util.Arrays;
import java.util.Collections;

public class CustomVersionSection
extends ConfigStorage {
    public boolean ENABLED;
    public boolean ALWAYS_TAB_COMPLETABLE;
    public MultipleMessagesHelper MESSAGE;
    public MultipleMessagesHelper COMMANDS;

    public CustomVersionSection() {
        super("custom-version");
    }

    @Override
    public void load() {
        super.load();
        this.ENABLED = (Boolean)new ConfigSectionHelper(this, "enabled", true).getOrSet();
        this.ALWAYS_TAB_COMPLETABLE = (Boolean)new ConfigSectionHelper(this, "always-tab-completable", false).getOrSet();
        this.COMMANDS = new MultipleMessagesHelper(this, "commands", Arrays.asList("icanhasbukkit", "about", "ver", "version"));
        this.MESSAGE = new MultipleMessagesHelper(this, "message", Collections.singletonList("&fThis server is running CraftBukkit version git-NasaSpigot-294 (MC: X)"));
    }

    public boolean isTabCompletable(String command) {
        if (!this.isCommand(command)) {
            return false;
        }
        return this.ALWAYS_TAB_COMPLETABLE;
    }

    public boolean isCommand(String command) {
        if (!this.ENABLED) {
            return false;
        }
        command = StringUtils.getFirstArg(command);
        for (String currentCommand : this.COMMANDS.getLines()) {
            if (!currentCommand.equalsIgnoreCase(command)) continue;
            return true;
        }
        return false;
    }
}

