/*
 * Decompiled with CFR 0.152.
 */
package de.rayzs.pat.plugin;

import de.rayzs.pat.api.brand.CustomServerBrand;
import de.rayzs.pat.api.communication.BackendUpdater;
import de.rayzs.pat.api.communication.Communicator;
import de.rayzs.pat.api.event.PATEventHandler;
import de.rayzs.pat.api.netty.bukkit.BukkitPacketAnalyzer;
import de.rayzs.pat.api.storage.Storage;
import de.rayzs.pat.plugin.PluginLoader;
import de.rayzs.pat.plugin.commands.BukkitCommand;
import de.rayzs.pat.plugin.listeners.bukkit.BukkitAntiTabListener;
import de.rayzs.pat.plugin.listeners.bukkit.BukkitBlockCommandListener;
import de.rayzs.pat.plugin.listeners.bukkit.BukkitPlayerConnectionListener;
import de.rayzs.pat.plugin.listeners.bukkit.PaperServerListPing;
import de.rayzs.pat.plugin.logger.Logger;
import de.rayzs.pat.plugin.metrics.bStats;
import de.rayzs.pat.plugin.modules.SubArgsModule;
import de.rayzs.pat.plugin.process.CommandProcess;
import de.rayzs.pat.utils.ArrayUtils;
import de.rayzs.pat.utils.CommandsCache;
import de.rayzs.pat.utils.CommunicationPackets;
import de.rayzs.pat.utils.Reflection;
import de.rayzs.pat.utils.VersionComparer;
import de.rayzs.pat.utils.adapter.LuckPermsAdapter;
import de.rayzs.pat.utils.adapter.ViaVersionAdapter;
import de.rayzs.pat.utils.configuration.Configurator;
import de.rayzs.pat.utils.configuration.updater.ConfigUpdater;
import de.rayzs.pat.utils.group.GroupManager;
import de.rayzs.pat.utils.group.TinyGroup;
import de.rayzs.pat.utils.hooks.PlaceholderHook;
import de.rayzs.pat.utils.message.MessageTranslator;
import de.rayzs.pat.utils.permission.PermissionUtil;
import de.rayzs.pat.utils.response.action.ActionHandler;
import de.rayzs.pat.utils.scheduler.PATScheduler;
import de.rayzs.pat.utils.scheduler.PATSchedulerTask;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.SimplePluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class BukkitLoader
extends JavaPlugin
implements PluginLoader {
    private static List<String> commands = new ArrayList<String>();
    private static List<String> allowedCommands = new ArrayList<String>();
    private static Plugin plugin;
    private static java.util.logging.Logger logger;
    private static boolean loaded;
    private static boolean suggestions;
    private static Map<String, Command> commandsMap;
    private PATSchedulerTask updaterTask;
    private final List<String> offlinePlayerNames = new ArrayList<String>();
    private long lastCommandsLoad = -1L;

    public void onLoad() {
        Configurator.createResourcedFile("files\\bukkit-config.yml", "config.yml", false);
        Configurator.createResourcedFile("files\\bukkit-storage.yml", "storage.yml", false);
        Configurator.createResourcedFile("files\\bukkit-placeholders.yml", "placeholders.yml", false);
        Configurator.createResourcedFile("files\\bukkit-custom-responses.yml", "custom-responses.yml", false);
    }

    public void onEnable() {
        plugin = this;
        logger = this.getLogger();
        for (OfflinePlayer offlinePlayerName : Bukkit.getOfflinePlayers()) {
            this.offlinePlayerNames.add(offlinePlayerName.getName());
        }
        this.loadCommandMap();
        CommandProcess.initialize();
        Reflection.initialize(this.getServer());
        ConfigUpdater.initialize();
        Storage.initialize(this, this.getDescription().getVersion());
        VersionComparer.get().setCurrentVersion(Storage.CURRENT_VERSION);
        Storage.loadAll(true);
        if (Bukkit.getServer().getPluginManager().getPlugin("PlaceholderAPI") != null) {
            new PlaceholderHook().register();
        }
        MessageTranslator.initialize();
        CustomServerBrand.initialize();
        bStats.initialize(this);
        PluginManager manager = this.getServer().getPluginManager();
        if (!Storage.ConfigSections.Settings.HANDLE_THROUGH_PROXY.ENABLED) {
            loaded = true;
            GroupManager.initialize();
            BukkitPacketAnalyzer.injectAll();
        } else {
            BackendUpdater.handle();
        }
        manager.registerEvents((Listener)new BukkitPlayerConnectionListener(), (Plugin)this);
        manager.registerEvents((Listener)new BukkitBlockCommandListener(), (Plugin)this);
        if (Reflection.getMinor() >= 13) {
            suggestions = true;
            manager.registerEvents((Listener)new BukkitAntiTabListener(), (Plugin)this);
        }
        if (Reflection.isPaper() && Reflection.getMinor() >= 12) {
            manager.registerEvents((Listener)new PaperServerListPing(), (Plugin)this);
        }
        this.registerCommand("proantitab", "pat");
        this.startUpdaterTask();
        Storage.PLUGIN_OBJECT = this;
        if (this.getServer().getPluginManager().getPlugin("LuckPerms") != null) {
            LuckPermsAdapter.initialize();
            Bukkit.getOnlinePlayers().forEach(player -> PermissionUtil.setPlayerPermissions(player.getUniqueId()));
        }
        if (this.getServer().getPluginManager().getPlugin("ViaVersion") != null) {
            ViaVersionAdapter.initialize();
        }
        if (Storage.USE_SIMPLECLOUD) {
            Logger.warning("Detected SimpleCloud. Therefore, MiniMessages are disabled!");
        }
        ConfigUpdater.broadcastMissingParts();
        ActionHandler.initialize();
        SubArgsModule.initialize();
        PATScheduler.createScheduler(this::loadAllCommands);
    }

    public void onDisable() {
        BackendUpdater.stop();
        BukkitPacketAnalyzer.uninjectAll();
        MessageTranslator.closeAudiences();
    }

    public void registerCommand(String ... commands) {
        BukkitCommand command = new BukkitCommand();
        for (String commandName : commands) {
            PluginCommand pluginCommand = this.getCommand(commandName);
            pluginCommand.setExecutor((CommandExecutor)command);
            pluginCommand.setTabCompleter((TabCompleter)command);
        }
    }

    @Override
    public void handleReload() {
        this.loadAllCommands();
    }

    @Override
    public boolean doesCommandExist(String command) {
        if (commandsMap == null) {
            return false;
        }
        this.loadAllCommands();
        return BukkitLoader.getAllCommands().contains(command);
    }

    @Override
    public Object getConsoleSender() {
        return Bukkit.getConsoleSender();
    }

    @Override
    public Object getPlayerObjByName(String name) {
        return Bukkit.getPlayer((String)name);
    }

    @Override
    public Object getPlayerObjByUUID(UUID uuid) {
        return Bukkit.getPlayer((UUID)uuid);
    }

    @Override
    public void updateCommandCache() {
    }

    @Override
    public HashMap<String, CommandsCache> getCommandsCacheMap() {
        return null;
    }

    @Override
    public boolean isPlayerOnline(String playerName) {
        return Bukkit.getPlayer((String)playerName) != null;
    }

    @Override
    public boolean doesPlayerExist(String playerName) {
        return ArrayUtils.containsIgnoreCase(this.getPlayerNames(), playerName);
    }

    @Override
    public String getPlayerServerName(UUID uuid) {
        return null;
    }

    @Override
    public List<UUID> getPlayerIdsByServer(String server) {
        return null;
    }

    @Override
    public List<String> getOnlinePlayerNames(String serverName) {
        return this.getOnlinePlayerNames();
    }

    @Override
    public List<UUID> getPlayerIds() {
        return null;
    }

    @Override
    public List<String> getOnlinePlayerNames() {
        return new ArrayList<String>(Bukkit.getServer().getOnlinePlayers().stream().map(Player::getName).toList());
    }

    @Override
    public List<String> getOfflinePlayerNames() {
        return this.offlinePlayerNames;
    }

    @Override
    public List<String> getPlayerNames() {
        ArrayList<String> playerNames = new ArrayList<String>(this.offlinePlayerNames);
        playerNames.addAll(this.getOnlinePlayerNames());
        return playerNames;
    }

    @Override
    public String getNameByUUID(UUID uuid) {
        Player player = Bukkit.getPlayer((UUID)uuid);
        return player != null ? player.getName() : "";
    }

    @Override
    public UUID getUUIDByName(String playerName) {
        Player player = Bukkit.getPlayer((String)playerName);
        return player != null ? player.getUniqueId() : null;
    }

    @Override
    public List<String> getServerNames() {
        return List.of();
    }

    public void startUpdaterTask() {
        if (!Storage.ConfigSections.Settings.UPDATE.ENABLED) {
            return;
        }
        this.updaterTask = PATScheduler.createAsyncScheduler(() -> {
            if (VersionComparer.get().computeComparison()) {
                this.updaterTask.cancelTask();
            }
        }, 20L, 20L * (long)Storage.ConfigSections.Settings.UPDATE.PERIOD);
    }

    public static void synchronize(CommunicationPackets.PacketBundle packetBundle) {
        Storage.LAST_SYNC = System.currentTimeMillis();
        Communicator.sendFeedback();
        CommunicationPackets.UnknownCommandPacket unknownCommandPacket = packetBundle.getUnknownCommandPacket();
        CommunicationPackets.CommandsPacket commandsPacket = packetBundle.getCommandsPacket();
        CommunicationPackets.GroupsPacket groupsPacket = packetBundle.getGroupsPacket();
        CommunicationPackets.NamespaceCommandsPacket namespaceCommandsPacket = packetBundle.getNamespaceCommandsPacket();
        CommunicationPackets.MessagePacket messagePacket = packetBundle.getMessagePacket();
        boolean updatedList = false;
        if (!messagePacket.getBaseBlockedMessage().getLines().isEmpty()) {
            Storage.ConfigSections.Settings.CANCEL_COMMAND.BASE_COMMAND_RESPONSE = messagePacket.getBaseBlockedMessage();
        }
        if (!messagePacket.getSubBlockedMessage().getLines().isEmpty()) {
            Storage.ConfigSections.Settings.CANCEL_COMMAND.SUB_COMMAND_RESPONSE = messagePacket.getSubBlockedMessage();
        }
        if (!messagePacket.getPrefix().isEmpty()) {
            Storage.ConfigSections.Messages.PREFIX.PREFIX = messagePacket.getPrefix();
        }
        if (Storage.ConfigSections.Settings.BLOCK_NAMESPACE_COMMANDS.ENABLED != namespaceCommandsPacket.isEnabled()) {
            Storage.ConfigSections.Settings.BLOCK_NAMESPACE_COMMANDS.ENABLED = namespaceCommandsPacket.isEnabled();
        }
        if (commandsPacket.getCommands() == null || commandsPacket.getCommands().isEmpty()) {
            Storage.Blacklist.getBlacklist().setList(new ArrayList<String>());
        } else if (!ArrayUtils.compareStringArrays(Storage.Blacklist.getBlacklist().getCommands(), commandsPacket.getCommands())) {
            updatedList = true;
            Storage.Blacklist.getBlacklist().setList(commandsPacket.getCommands());
        }
        if (Storage.ConfigSections.Settings.TURN_BLACKLIST_TO_WHITELIST.ENABLED != commandsPacket.turnBlacklistToWhitelistEnabled()) {
            Storage.ConfigSections.Settings.TURN_BLACKLIST_TO_WHITELIST.ENABLED = commandsPacket.turnBlacklistToWhitelistEnabled();
        }
        HashMap cpyCache = new HashMap();
        GroupManager.getGroups().forEach(group -> cpyCache.put(group.getGroupName(), group.getCommands()));
        GroupManager.clearAllGroups();
        for (TinyGroup group2 : groupsPacket.getGroups()) {
            List currentExistingList = (List)cpyCache.get(group2.getGroupName());
            if (!updatedList && currentExistingList != null && !ArrayUtils.compareStringArrays(currentExistingList, group2.getCommands())) {
                updatedList = true;
            }
            GroupManager.setGroup(group2.getGroupName(), group2.getPriority(), group2.getCommands());
        }
        Storage.ConfigSections.Settings.CUSTOM_UNKNOWN_COMMAND.MESSAGE = unknownCommandPacket.getMessage();
        if (Storage.ConfigSections.Settings.CUSTOM_UNKNOWN_COMMAND.ENABLED != unknownCommandPacket.isEnabled()) {
            Storage.ConfigSections.Settings.CUSTOM_UNKNOWN_COMMAND.ENABLED = unknownCommandPacket.isEnabled();
        }
        if (!loaded) {
            loaded = true;
        }
        if (Reflection.getMinor() >= 13 && updatedList) {
            BukkitAntiTabListener.updateCommands();
            Logger.debug("Force server to load all players tab-completion due to received sync!");
        }
        PATEventHandler.callReceiveSyncEvents(packetBundle);
    }

    public static List<String> getAllCommands() {
        return new ArrayList<String>(commands);
    }

    public static List<String> getAllowedCommands() {
        return new ArrayList<String>(allowedCommands);
    }

    private void loadCommandMap() {
        try {
            if (Bukkit.getPluginManager() instanceof SimplePluginManager) {
                Field commandMapField = SimplePluginManager.class.getDeclaredField("commandMap");
                commandMapField.setAccessible(true);
                SimpleCommandMap simpleCommandMap = (SimpleCommandMap)commandMapField.get(Bukkit.getPluginManager());
                Field knownCommandsField = SimpleCommandMap.class.getDeclaredField("knownCommands");
                knownCommandsField.setAccessible(true);
                commandsMap = (Map)knownCommandsField.get(simpleCommandMap);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (commandsMap == null) {
            Logger.warning("Failed to get server commands!");
        }
    }

    private void loadAllCommands() {
        if (this.lastCommandsLoad != -1L && System.currentTimeMillis() - this.lastCommandsLoad < 1000L) {
            return;
        }
        ArrayList<String> result = new ArrayList<String>();
        if (commandsMap == null) {
            result.addAll(Bukkit.getHelpMap().getHelpTopics().stream().map(topic -> {
                String name = topic.getName();
                if (name.startsWith("/")) {
                    name = name.substring(1);
                }
                return name;
            }).toList());
            return;
        }
        commandsMap.entrySet().forEach(entry -> {
            String key = (String)entry.getKey();
            Command command = (Command)entry.getValue();
            result.add(key);
            if (!command.getAliases().isEmpty()) {
                result.addAll(command.getAliases());
            }
        });
        boolean turn = Storage.ConfigSections.Settings.TURN_BLACKLIST_TO_WHITELIST.ENABLED;
        List<String> allowedCommands = new ArrayList(result).stream().filter(command -> {
            if (turn) {
                return Storage.Blacklist.getBlacklist().isListed((String)command);
            }
            return !Storage.Blacklist.getBlacklist().isListed((String)command);
        }).toList();
        this.lastCommandsLoad = System.currentTimeMillis();
        commands = result;
        BukkitLoader.allowedCommands = allowedCommands;
    }

    public static boolean useSuggestions() {
        return suggestions;
    }

    public static Plugin getPlugin() {
        return plugin;
    }

    public static java.util.logging.Logger getPluginLogger() {
        return logger;
    }

    public static boolean isLoaded() {
        return loaded;
    }

    static {
        loaded = false;
        suggestions = false;
        commandsMap = null;
    }
}

