/*
 * Decompiled with CFR 0.152.
 */
package de.rayzs.pat.plugin.listeners.bukkit;

import com.destroystokyo.paper.event.server.PaperServerListPingEvent;
import com.destroystokyo.paper.profile.PlayerProfile;
import com.destroystokyo.paper.profile.ProfileProperty;
import de.rayzs.pat.api.storage.Storage;
import de.rayzs.pat.utils.ExpireCache;
import de.rayzs.pat.utils.StringUtils;
import de.rayzs.pat.utils.message.replacer.PlaceholderReplacer;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.profile.PlayerTextures;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PaperServerListPing
implements Listener {
    private static final ExpireCache<Integer, List<ProtocolHoverLine>> CACHED_PROTOCOL_NAMES = new ExpireCache(1L, TimeUnit.SECONDS);
    private static final UUID RANDOM_UUID = UUID.randomUUID();
    private static final int CACHE_KEY = 0;

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPaperServerListPing(PaperServerListPingEvent event) {
        if (!Storage.ConfigSections.Settings.CUSTOM_PROTOCOL_PING.ENABLED) {
            return;
        }
        if (Storage.ConfigSections.Settings.CUSTOM_PROTOCOL_PING.ALWAYS_SHOW) {
            event.setProtocolVersion(0);
        }
        int online = Bukkit.getOnlinePlayers().size();
        int onlineExtend = online + Storage.ConfigSections.Settings.CUSTOM_PROTOCOL_PING.EXTEND_COUNT;
        int max = Bukkit.getMaxPlayers();
        if (Storage.ConfigSections.Settings.CUSTOM_PROTOCOL_PING.USE_EXTEND_AS_MAX_COUNT) {
            event.setMaxPlayers(onlineExtend);
        }
        String versionName = Storage.ConfigSections.Settings.CUSTOM_PROTOCOL_PING.PROTOCOL.replace("%online_extended%", String.valueOf(onlineExtend)).replace("%online%", String.valueOf(online)).replace("%max%", String.valueOf(max));
        if (Storage.ConfigSections.Settings.CUSTOM_PROTOCOL_PING.HIDE_PLAYERS) {
            event.getPlayerSample().clear();
            event.setHidePlayers(true);
        } else if (Storage.ConfigSections.Settings.CUSTOM_PROTOCOL_PING.USE_CUSTOM_PLAYERLIST) {
            List<ProtocolHoverLine> cachedPlayerNames = CACHED_PROTOCOL_NAMES.get(0);
            event.getPlayerSample().clear();
            if (cachedPlayerNames != null) {
                event.getPlayerSample().addAll(cachedPlayerNames);
            } else {
                Storage.ConfigSections.Settings.CUSTOM_PROTOCOL_PING.PLAYERLIST.getLines().forEach(line -> {
                    if (line.contains("%players%")) {
                        List<String> playerNames = Storage.getLoader().getOnlinePlayerNames();
                        playerNames = playerNames.size() > 30 ? playerNames.subList(0, 30) : playerNames;
                        for (String currentPlayerName : playerNames) {
                            String playerName = StringUtils.replace(line, "%players%", currentPlayerName, "&", "\u00a7");
                            event.getPlayerSample().add(new ProtocolHoverLine(playerName, RANDOM_UUID));
                        }
                    } else {
                        String playerName = this.replaceString((String)line, online, onlineExtend, max);
                        if (playerName.contains("\n")) {
                            String[] nameSplit = playerName.split("\n");
                            for (String name : nameSplit = nameSplit.length > 30 ? Arrays.copyOfRange(nameSplit, 0, 30) : nameSplit) {
                                event.getPlayerSample().add(new ProtocolHoverLine(name, RANDOM_UUID));
                            }
                        } else {
                            event.getPlayerSample().add(new ProtocolHoverLine(playerName, RANDOM_UUID));
                        }
                    }
                });
            }
        }
        event.setVersion(this.replaceString(versionName, online, onlineExtend, max));
    }

    private String replaceString(String string, int online, int onlineExtend, int max) {
        String replaced = string.replace("&", "\u00a7").replace("%online_extended%", String.valueOf(onlineExtend)).replace("%online%", String.valueOf(online)).replace("%max%", String.valueOf(max));
        return replaced.contains("%") ? PlaceholderReplacer.replace(null, replaced) : replaced;
    }

    private static class ProtocolHoverLine
    implements PlayerProfile {
        private String name;
        private String id;

        public ProtocolHoverLine(String name, UUID id) {
            this.name = name;
            this.id = id.toString();
        }

        @Nullable
        public UUID getUniqueId() {
            return UUID.fromString(this.id);
        }

        @Nullable
        public String getName() {
            return this.name;
        }

        @NotNull
        public String setName(@Nullable String s) {
            return "";
        }

        @Nullable
        public UUID getId() {
            return this.getUniqueId();
        }

        @Nullable
        public UUID setId(@Nullable UUID uuid) {
            return null;
        }

        @NotNull
        public PlayerTextures getTextures() {
            return null;
        }

        public void setTextures(@Nullable PlayerTextures playerTextures) {
        }

        public Set<ProfileProperty> getProperties() {
            return null;
        }

        public boolean hasProperty(@Nullable String s) {
            return false;
        }

        public void setProperty(@NotNull ProfileProperty profileProperty) {
        }

        public void setProperties(@NotNull Collection<ProfileProperty> collection) {
        }

        public boolean removeProperty(@Nullable String s) {
            return false;
        }

        public void clearProperties() {
        }

        public boolean isComplete() {
            return false;
        }

        public boolean completeFromCache() {
            return false;
        }

        public boolean completeFromCache(boolean b) {
            return false;
        }

        public boolean completeFromCache(boolean b, boolean b1) {
            return false;
        }

        public boolean complete(boolean b) {
            return false;
        }

        public boolean complete(boolean b, boolean b1) {
            return false;
        }

        @NotNull
        public CompletableFuture<PlayerProfile> update() {
            return null;
        }

        public @NotNull org.bukkit.profile.PlayerProfile clone() {
            return null;
        }

        public Map<String, Object> serialize() {
            return null;
        }
    }
}

