/*
 * Decompiled with CFR 0.152.
 */
package de.rayzs.pat.plugin.listeners.velocity;

import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.event.command.CommandExecuteEvent;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ServerConnection;
import de.rayzs.pat.api.event.PATEventHandler;
import de.rayzs.pat.api.event.events.ExecuteCommandEvent;
import de.rayzs.pat.api.storage.Storage;
import de.rayzs.pat.utils.StringUtils;
import de.rayzs.pat.utils.message.MessageTranslator;
import de.rayzs.pat.utils.permission.PermissionUtil;
import java.util.List;
import java.util.UUID;

public class VelocityBlockCommandListener {
    public static CommandExecuteEvent handleCommand(Player player, String command) {
        return VelocityBlockCommandListener.handleCommand(new CommandExecuteEvent((CommandSource)player, command));
    }

    public static CommandExecuteEvent handleCommand(CommandExecuteEvent event) {
        ExecuteCommandEvent executeCommandEvent;
        if (!event.getResult().isAllowed()) {
            return event;
        }
        CommandSource commandSource = event.getCommandSource();
        Object consoleSender = Storage.getLoader().getConsoleSender();
        if (!(commandSource instanceof Player)) {
            return event;
        }
        Player player = (Player)commandSource;
        String command = StringUtils.getFirstArg(event.getCommand());
        String serverName = player.getCurrentServer().isPresent() ? ((ServerConnection)player.getCurrentServer().get()).getServerInfo().getName() : "unknown";
        boolean bypassPermission = PermissionUtil.hasBypassPermission(player, command);
        if (bypassPermission) {
            return event;
        }
        String displayCommand = StringUtils.replaceTriggers(command, "", "\\", "<", ">", "&");
        command = command.toLowerCase();
        List<String> notificationMessage = MessageTranslator.replaceMessageList(Storage.ConfigSections.Messages.NOTIFICATION.ALERT, "%player%", player.getUsername(), "%command%", displayCommand, "%server%", serverName);
        if (!Storage.ConfigSections.Settings.CANCEL_COMMAND.ENABLED) {
            return event;
        }
        if (!Storage.Blacklist.canPlayerAccessChat(player, command, serverName)) {
            executeCommandEvent = PATEventHandler.callExecuteCommandEvents(player, event.getCommand(), true, !Storage.ConfigSections.Settings.TURN_BLACKLIST_TO_WHITELIST.ENABLED);
            if (executeCommandEvent.isBlocked()) {
                event.setResult(CommandExecuteEvent.CommandResult.denied());
                if (!executeCommandEvent.doesNotify()) {
                    return event;
                }
                if (Storage.SEND_CONSOLE_NOTIFICATION) {
                    MessageTranslator.send(consoleSender, notificationMessage);
                }
                Storage.NOTIFY_PLAYERS.stream().forEach(uuid -> {
                    Object p = Storage.getLoader().getPlayerObjByUUID((UUID)uuid);
                    if (p != null) {
                        MessageTranslator.send(p, notificationMessage);
                    }
                });
            }
            if (executeCommandEvent.isCancelled()) {
                return event;
            }
        }
        if ((executeCommandEvent = PATEventHandler.callExecuteCommandEvents(player, event.getCommand(), false, false)).isBlocked()) {
            event.setResult(CommandExecuteEvent.CommandResult.denied());
        }
        return event;
    }
}

