/*
 * Decompiled with CFR 0.152.
 */
package de.rayzs.pat.utils;

import de.rayzs.pat.api.storage.Storage;
import de.rayzs.pat.utils.Reflection;
import de.rayzs.pat.utils.configuration.helper.MultipleMessagesHelper;
import de.rayzs.pat.utils.group.TinyGroup;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.List;
import java.util.UUID;

public class CommunicationPackets {
    public static byte[] convertToBytes(Object obj) {
        byte[] byArray;
        ByteArrayOutputStream arrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream outputStream = new ObjectOutputStream(arrayOutputStream);
        try {
            outputStream.writeObject(obj);
            outputStream.flush();
            byArray = arrayOutputStream.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    outputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception exception) {
                return null;
            }
        }
        outputStream.close();
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object buildFromBytes(byte[] bytes) {
        ByteArrayInputStream arrayInputStream = new ByteArrayInputStream(bytes);
        try (ObjectInputStream input = new ObjectInputStream(arrayInputStream);){
            Object object = input.readObject();
            if (object.getClass() == null) {
                Object var4_6 = null;
                return var4_6;
            }
            Object object2 = object;
            return object2;
        }
        catch (Throwable throwable3) {
            return null;
        }
    }

    public static boolean isPacket(Object object) {
        return object instanceof CommunicationPacket;
    }

    public static interface CommunicationPacket {
    }

    public static class GroupsPacket
    implements Serializable {
        private final List<TinyGroup> groups;

        public GroupsPacket(List<TinyGroup> groups) {
            this.groups = groups;
        }

        public List<TinyGroup> getGroups() {
            return this.groups;
        }
    }

    public static class CommandsPacket
    implements Serializable {
        private List<String> commands;
        private boolean turnBlacklistToWhitelist;

        public void setCommands(List<String> commands) {
            this.commands = commands;
        }

        public void setTurnBlacklistToWhitelist(boolean turnBlacklistToWhitelist) {
            this.turnBlacklistToWhitelist = turnBlacklistToWhitelist;
        }

        public boolean turnBlacklistToWhitelistEnabled() {
            return this.turnBlacklistToWhitelist;
        }

        public List<String> getCommands() {
            return this.commands;
        }
    }

    public static class UnknownCommandPacket
    implements Serializable {
        private final MultipleMessagesHelper message;
        private final boolean enabled;

        public UnknownCommandPacket() {
            this.enabled = Storage.ConfigSections.Settings.CUSTOM_UNKNOWN_COMMAND.ENABLED;
            this.message = Storage.ConfigSections.Settings.CUSTOM_UNKNOWN_COMMAND.MESSAGE;
        }

        public MultipleMessagesHelper getMessage() {
            return this.message;
        }

        public boolean isEnabled() {
            return this.enabled;
        }
    }

    public static class NamespaceCommandsPacket
    implements Serializable {
        private final boolean enabled;

        public NamespaceCommandsPacket() {
            this.enabled = Storage.ConfigSections.Settings.BLOCK_NAMESPACE_COMMANDS.ENABLED;
        }

        public boolean isEnabled() {
            return this.enabled;
        }
    }

    public static class MessagePacket
    implements Serializable {
        private final String prefix;
        private final MultipleMessagesHelper baseBlockedMessage;
        private final MultipleMessagesHelper subBlockedMessage;

        public MessagePacket() {
            this.prefix = Storage.ConfigSections.Messages.PREFIX.PREFIX;
            this.baseBlockedMessage = Storage.ConfigSections.Settings.CANCEL_COMMAND.BASE_COMMAND_RESPONSE;
            this.subBlockedMessage = Storage.ConfigSections.Settings.CANCEL_COMMAND.SUB_COMMAND_RESPONSE;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public MultipleMessagesHelper getBaseBlockedMessage() {
            return this.baseBlockedMessage;
        }

        public MultipleMessagesHelper getSubBlockedMessage() {
            return this.subBlockedMessage;
        }
    }

    public static class PacketBundle
    implements CommunicationPacket,
    Serializable {
        private final CommandsPacket commandsPacket;
        private final GroupsPacket groupsPacket;
        private final UnknownCommandPacket unknownCommandPacket;
        private final NamespaceCommandsPacket namespaceCommandsPacket;
        private final MessagePacket messagePacket;
        private final String proxyToken;
        private final String serverId;
        private final boolean velocity;

        public PacketBundle(String proxyToken, String serverId, CommandsPacket commandsPacket, GroupsPacket groupsPacket) {
            this.proxyToken = proxyToken;
            this.serverId = serverId;
            this.commandsPacket = commandsPacket;
            this.groupsPacket = groupsPacket;
            this.unknownCommandPacket = new UnknownCommandPacket();
            this.namespaceCommandsPacket = new NamespaceCommandsPacket();
            this.messagePacket = new MessagePacket();
            this.velocity = Reflection.isVelocityServer();
        }

        public boolean isVelocity() {
            return this.velocity;
        }

        public boolean isToken(String token) {
            return this.proxyToken.equals(token);
        }

        public boolean isId(String id) {
            return this.idIgnored() || this.serverId.equals(id);
        }

        public boolean idIgnored() {
            return this.serverId == null;
        }

        public CommandsPacket getCommandsPacket() {
            return this.commandsPacket;
        }

        public GroupsPacket getGroupsPacket() {
            return this.groupsPacket;
        }

        public UnknownCommandPacket getUnknownCommandPacket() {
            return this.unknownCommandPacket;
        }

        public MessagePacket getMessagePacket() {
            return this.messagePacket;
        }

        public NamespaceCommandsPacket getNamespaceCommandsPacket() {
            return this.namespaceCommandsPacket;
        }
    }

    public static class ForcePermissionResetPacket
    implements Serializable {
        private final String proxyToken;
        private UUID targetUUID = null;

        public ForcePermissionResetPacket(String proxyToken) {
            this.proxyToken = proxyToken;
        }

        public ForcePermissionResetPacket(String proxyToken, UUID targetUUID) {
            this.proxyToken = proxyToken;
            this.targetUUID = targetUUID;
        }

        public UUID getTargetUUID() {
            return this.targetUUID;
        }

        public boolean hasTarget() {
            return this.targetUUID != null;
        }

        public boolean isToken(String token) {
            return this.proxyToken.equals(token);
        }
    }

    public static class RequestPacket
    implements CommunicationPacket,
    Serializable {
        private final String proxyToken;
        private final String serverId;

        public RequestPacket(String proxyToken, String serverId) {
            this.proxyToken = proxyToken;
            this.serverId = serverId;
        }

        public String getServerId() {
            return this.serverId;
        }

        public boolean isToken(String token) {
            return this.proxyToken.equals(token);
        }
    }

    public static class FeedbackPacket
    implements CommunicationPacket,
    Serializable {
        private final String proxyToken;
        private final String serverId;

        public FeedbackPacket(String proxyToken, String serverId) {
            this.proxyToken = proxyToken;
            this.serverId = serverId;
        }

        public String getServerId() {
            return this.serverId;
        }

        public boolean isToken(String token) {
            return this.proxyToken.equals(token);
        }
    }

    public static class BackendDataPacket
    implements CommunicationPacket,
    Serializable {
        private final String proxyToken;
        private final String serverName;
        private final String serverId;

        public BackendDataPacket(String proxyToken, String serverId, String serverName) {
            this.proxyToken = proxyToken;
            this.serverId = serverId;
            this.serverName = serverName;
        }

        public String getServerId() {
            return this.serverId;
        }

        public String getServerName() {
            return this.serverName;
        }

        public boolean isToken(String token) {
            return this.proxyToken.equals(token);
        }
    }
}

