/*
 * Decompiled with CFR 0.152.
 */
package de.rayzs.pat.utils;

import de.rayzs.pat.plugin.logger.Logger;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;

public class ConnectionBuilder {
    private String url = null;
    private String response = null;
    private List<String> responseList = new ArrayList<String>();
    private Object[] parameters = null;
    private int timeout = -1;

    public ConnectionBuilder setUrl(String url) {
        this.url = url;
        return this;
    }

    public ConnectionBuilder setTimeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    public ConnectionBuilder setProperties(Object ... parameters) {
        this.parameters = parameters;
        return this;
    }

    public ConnectionBuilder connect() {
        try {
            String rawUrl = this.url;
            URL url = new URL(rawUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            if (this.timeout != -1) {
                connection.setConnectTimeout(this.timeout);
            }
            connection.setRequestProperty("User-Agent", "Mozilla/5.0");
            connection.setRequestProperty("Accept-Language", "en-US,en;q=0.5");
            if (this.parameters != null && this.parameters.length > 0) {
                Object firstParam = null;
                Object secondParam = null;
                for (Object parameter : this.parameters) {
                    if (firstParam == null) {
                        firstParam = parameter;
                        continue;
                    }
                    secondParam = parameter;
                    connection.setRequestProperty((String)firstParam, (String)secondParam);
                    firstParam = null;
                }
            }
            Scanner scanner = new Scanner(connection.getInputStream());
            StringBuilder builder = new StringBuilder("\\");
            while (scanner.hasNextLine()) {
                String next = scanner.nextLine();
                this.responseList.add(next);
                builder.append(" ").append(next);
            }
            this.response = builder.toString().replace("\\ ", "");
        }
        catch (Exception exception) {
            Logger.warning("Could not reach plugin page! More information below. (" + String.valueOf(exception) + ")");
        }
        return this;
    }

    public boolean hasResponse() {
        return this.response != null;
    }

    public String getResponse() {
        return this.response;
    }

    public List<String> getResponseList() {
        return this.responseList;
    }
}

