/*
 * Decompiled with CFR 0.152.
 */
package de.rayzs.pat.utils;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;

public class PacketUtils {
    public static String readString(ByteBuf buf) throws Exception {
        return PacketUtils.readString(buf, Short.MAX_VALUE);
    }

    public static String readString(ByteBuf byteBuf, int maxLength) throws Exception {
        int len = PacketUtils.readVarInt(byteBuf);
        if (len > maxLength * 3) {
            throw new Exception("Cannot receive string longer than " + maxLength * 3 + " (got " + len + " bytes)");
        }
        String string = byteBuf.toString(byteBuf.readerIndex(), len, StandardCharsets.UTF_8);
        byteBuf.readerIndex(byteBuf.readerIndex() + len);
        if (string.length() > maxLength) {
            throw new Exception("Cannot receive string longer than " + maxLength + " (got " + string.length() + " characters)");
        }
        return string;
    }

    public static int readVarInt(ByteBuf input) throws Exception {
        return PacketUtils.readVarInt(input, 5);
    }

    public static int readVarInt(ByteBuf input, int maxBytes) throws Exception {
        byte in;
        int out = 0;
        int bytes = 0;
        do {
            in = input.readByte();
            out |= (in & 0x7F) << bytes++ * 7;
            if (bytes <= maxBytes) continue;
            throw new Exception("VarInt too big (max " + maxBytes + ")");
        } while ((in & 0x80) == 128);
        return out;
    }

    public static void writeVarInt(int value, ByteBuf output) {
        do {
            int part = value & 0x7F;
            if ((value >>>= 7) != 0) {
                part |= 0x80;
            }
            output.writeByte(part);
        } while (value != 0);
    }

    public static void writeString(String string, ByteBuf byteBuf) throws Exception {
        PacketUtils.writeString(string, byteBuf, Short.MAX_VALUE);
    }

    public static void writeString(String string, ByteBuf byteBuf, int maxLength) throws Exception {
        if (string.length() > maxLength) {
            throw new Exception("Cannot send string longer than " + maxLength + " (got " + string.length() + " characters)");
        }
        byte[] bytes = string.getBytes(StandardCharsets.UTF_8);
        if (bytes.length > maxLength * 3) {
            throw new Exception("Cannot send string longer than " + maxLength * 3 + " (got " + bytes.length + " bytes)");
        }
        PacketUtils.writeVarInt(bytes.length, byteBuf);
        byteBuf.writeBytes(bytes);
    }

    public static class BrandManipulate {
        private final int capacity;
        private final String brand;
        private final byte[] bytes;
        private ByteBuf byteBuf;

        public BrandManipulate(String brand) {
            this.brand = brand;
            this.capacity = brand.getBytes(StandardCharsets.UTF_8).length + 1;
            this.bytes = this.buildBytes(true);
        }

        public BrandManipulate(String brand, boolean releases) {
            this.brand = brand;
            this.capacity = brand.getBytes(StandardCharsets.UTF_8).length + 1;
            this.bytes = this.buildBytes(releases);
        }

        public byte[] getBytes() {
            return this.bytes;
        }

        private byte[] buildBytes(boolean release) {
            this.byteBuf = Unpooled.buffer((int)this.capacity);
            try {
                PacketUtils.writeString(this.brand, this.byteBuf);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            byte[] bytes = this.byteBuf.array();
            if (release) {
                this.byteBuf.release();
            }
            return bytes;
        }

        public String getBrand() {
            return this.brand;
        }

        public ByteBuf getByteBuf() {
            return this.byteBuf;
        }
    }
}

