/*
 * Decompiled with CFR 0.152.
 */
package de.rayzs.pat.utils;

import de.rayzs.pat.api.storage.Storage;
import de.rayzs.pat.plugin.logger.Logger;
import de.rayzs.pat.utils.ConnectionBuilder;
import de.rayzs.pat.utils.NumberUtils;
import java.util.Arrays;
import java.util.List;

public class VersionComparer {
    private static final VersionComparer instance = new VersionComparer();
    private final List<String> ignoreVersions = Arrays.asList("1.9.1", "1.9.2");
    private final String versionUrl = "https://www.rayzs.de/proantitab/api/version.php";
    private final int versionLength = 3;
    private Version currentVersion;
    private Version newestVersion;
    private VersionState versionState = VersionState.UPDATED;
    private boolean shouldAnnounce = true;

    public static VersionComparer get() {
        return instance;
    }

    private VersionComparer() {
    }

    public boolean computeComparison() {
        String result = new ConnectionBuilder().setUrl("https://www.rayzs.de/proantitab/api/version.php").setProperties("ProAntiTab", "4454").connect().getResponse();
        if (result == null) {
            result = "/";
        }
        if (result.equals("/")) {
            Logger.warning("Failed to connect to plugin page! Version comparison cannot be made. (No internet?)");
            return false;
        }
        Storage.NEWER_VERSION = result;
        VersionComparer.get().setNewestVersion(Storage.NEWER_VERSION);
        if (VersionComparer.get().isNewer()) {
            if (this.shouldAnnounce) {
                this.shouldAnnounce = false;
                Logger.info("\u00a78[\u00a7fPAT | Bukkit\u00a78] \u00a77Please be aware that you are currently using a \u00a7bdeveloper \u00a77version of ProAntiTab. Bugs, errors and a lot of debug messages might be included.");
            }
            return true;
        }
        if (VersionComparer.get().isUpdated()) {
            if (this.shouldAnnounce) {
                this.shouldAnnounce = false;
                Storage.ConfigSections.Settings.UPDATE.UPDATED.getLines().forEach(Logger::warning);
            }
            return false;
        }
        if (VersionComparer.get().isOutdated()) {
            if (this.shouldAnnounce) {
                this.shouldAnnounce = false;
                Storage.OUTDATED = true;
                Storage.ConfigSections.Settings.UPDATE.OUTDATED.getLines().forEach(Logger::warning);
            }
            return true;
        }
        return false;
    }

    public void setCurrentVersion(String version) {
        if (version == null) {
            return;
        }
        this.currentVersion = new Version(version);
    }

    public void setNewestVersion(String version) {
        if (version == null) {
            return;
        }
        if (this.ignoreVersions.contains(version)) {
            return;
        }
        this.newestVersion = new Version(version);
        this.compute();
    }

    public VersionState getVersionState() {
        return this.versionState;
    }

    public boolean isUpdated() {
        return this.versionState == VersionState.UPDATED;
    }

    public boolean isOutdated() {
        return this.versionState == VersionState.OUTDATED;
    }

    public boolean isNewer() {
        return this.versionState == VersionState.NEWER;
    }

    private void compute() {
        if (this.currentVersion == null || this.newestVersion == null) {
            return;
        }
        int[] crntNum = this.currentVersion.getVersionNums();
        int[] newNum = this.newestVersion.getVersionNums();
        for (int i = 0; i < 3; ++i) {
            if (crntNum[i] > newNum[i]) {
                this.versionState = VersionState.NEWER;
                return;
            }
            if (crntNum[i] >= newNum[i]) continue;
            this.versionState = VersionState.OUTDATED;
            return;
        }
    }

    public static enum VersionState {
        NEWER,
        UPDATED,
        OUTDATED;

    }

    private class Version {
        private final int[] versionNums = new int[3];
        private final String versionString;

        public Version(String versionString) {
            this.versionString = versionString;
            this.setVersionNums();
        }

        public String getVersionName() {
            return this.versionString;
        }

        public int[] getVersionNums() {
            return this.versionNums;
        }

        private void setVersionNums() {
            if (!this.versionString.contains(".")) {
                return;
            }
            String[] details = this.versionString.split("\\.");
            for (int i = 0; i < details.length && i < 3; ++i) {
                int detail;
                String detailString = details[i];
                if (!NumberUtils.isDigit(detailString)) continue;
                this.versionNums[i] = detail = Integer.parseInt(detailString);
            }
        }
    }
}

